<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Вихід, якщо доступ до нього прямий
}
$login_changes_safe = "";

// +++++++++++++++++ Отключаем проверку SSL-сертификата Wordpress
if( get_option( 'solass_wp_ssl_off', '' ) ) {
// Отключаем проверку SSL сертификатов	
add_filter('https_ssl_verify', '__return_false');
add_filter('https_local_ssl_verify', '__return_false');
$login_changes_safe = $login_changes_safe.'<li class="no_func">'.__( 'Вимкнена перевірка SSL-сертифікату Wordpress. ', 'solass-wp').'<br><strong>'.__( '!!! УВАГА !!!', 'solass-wp').' '.__( 'Не залишайне ввімкненою функцію на тривалий час.'.'</strong>', 'solass-wp').'</li>';
}

//------------------------------------------------------------------------------------------------------ //
//-------------------------------- !!! ДИЗАЙН-ОФОРМЛЕННЯ ЕЛЕМЕНТІВ ------------------------------------- //
//------------------------------------------------------------------------------------------------------ //


// +++++++++ Змінюємо лого для панелі входу в адмінку
if (!function_exists('solass_wp_login_logo') && esc_attr( get_option( 'logo_admin', '' ) )) {
function solass_wp_login_logo(){
$solass_css_login = ' #login h1 a, .login h1 a { background: url('. SOLASS_WP_PLUGIN_URL .'images/solass-web-login.svg) no-repeat center center !important; height: 90px !important; width: 90px !important; background-size: contain !important; } ';
$css_login = '#login h1 a, .login h1 a { background: url('. esc_attr( get_option( 'logo_admin', '' ) ) .') no-repeat center center !important; height: 90px !important; width: 90px !important; background-size: contain !important; }';
echo '<style type="text/css"> '.$css_login.' </style>
';
}
add_action('login_head', 'solass_wp_login_logo');
$login_changes = '<li>'.__( 'Змінено логотип панелі входу', 'solass-wp').'</li>';
}

// +++++++++ Ставим ссыллку с логотипа на сайт, а не на wordpress.org 
add_filter('login_headerurl', function() { return home_url(); }); // или site_url()
// +++++++++ убираем title в логотипе "сайт работает на wordpress" 
add_filter('login_headertext', '__return_empty_string'); 

// +++++++++ Изменение текста в подвале админ-панели
if (!function_exists('solass_wp_footer_admin_func')) { 
function solass_wp_footer_admin_func_var () { 
global $login_changes;
if ( esc_attr( get_option( 'solass_wp_admin_footer_text'.SOLASS_WP_POLYLANG_LANG, '' ) )) {
$login_changes = $login_changes.'<li>'.__( 'Змінений підпис у підвалі адмін-системи', 'solass-wp').'</li>';
}
}
add_filter('init', 'solass_wp_footer_admin_func_var');

function solass_wp_footer_admin_func () { 
if ( esc_attr( get_option( 'solass_wp_admin_footer_text'.SOLASS_WP_POLYLANG_LANG, '' ) )) {
echo get_option( 'solass_wp_admin_footer_text'.SOLASS_WP_POLYLANG_LANG, '' ) ;
} else {
echo __( '<p id="footer-left" class="alignleft"><em>Сайт працює на <a href="http://wordpress.org" target="_blank" rel="noopener">WordPress</a>. Ви використовуєте плагін «SOLASS WPSettings» розроблений <a href="https://solass.com.ua/" target="_blank" rel="noopener">дизайн студією «SOLASS»</a>.</em></p>', 'solass-wp');
}
}
add_filter('admin_footer_text', 'solass_wp_footer_admin_func');
}

/*
if( get_option( 'solass_wp_login_url', '' ) ) {
$new_wp_login = get_home_url().'/'.get_option( 'solass_wp_login_url', '' );
$login_changes_safe = $login_changes_safe.'<li>'.__( 'Посилання для залогінення у адмін систему тепер - <a href="'.$new_wp_login.'" target=_blank>'.$new_wp_login.'</a>', 'solass-wp').'</li>';

add_filter('site_url', 'wplogin_filter', 10, 3);
function wplogin_filter( $url, $path, $orig_scheme ) {
$old = array( "/(wp-login\.php)/");
$new = array( get_option( 'solass_wp_login_url', '' ) );
return preg_replace( $old, $new, $url, 1);
}
}
*/

// ----------------- редирект с login на /wp-login.php  и с admin на /wp-admin 
if( get_option( 'solass_wp_login_url', '' )) {  // && $this_function_on
/*
$new_wp_login = get_home_url().'/'.get_option( 'solass_wp_login_url', '' );
$login_changes_safe = $login_changes_safe.'<li>'.__( 'Посилання для залогінення у адмін систему тепер - <a href="'.$new_wp_login.'" target=_blank>'.$new_wp_login.'</a>', 'solass-wp').'</li>';

add_action('template_redirect', 'solass_login_redirect');
if (!function_exists('solass_login_redirect')) { 
function solass_login_redirect(){
$new_wp_login = get_option( 'solass_wp_login_url', '' );
	if( strpos($_SERVER['REQUEST_URI'], $new_wp_login)!==false )
		$loc = '/wp-admin/';
	elseif( strpos($_SERVER['REQUEST_URI'], $new_wp_login )!==false )
		$loc = '/wp-login.php';
	if( isset($loc) ){
		header( 'Location: '.get_option('site_url').$loc, true, 303 );
		exit;
	}
}
}
*/

}

// +++++++++++++++ Можно скрыть разные линки при отображении постов блога (следующий, предыдущий, короткий url
$login_changes = $login_changes.'<li>'.__( 'Увімкнений скрипт заміни символа " | " на "&lt;br>" для класів: <code>vert_br, class_br, _br_, perenos_br</code>', 'solass-wp').'</li>'; 

// +++++++++++++++ Можно скрыть разные линки при отображении постов блога (следующий, предыдущий, короткий url
if( get_option( 'solass_wp_post_rel_link', '' )) { 
$login_changes = $login_changes.'<li>'.__( 'Відключені лінки для постів (наступний, попередній та ін.)', 'solass-wp').'</li>'; 
remove_action('wp_head','start_post_rel_link',10,0);
remove_action('wp_head','index_rel_link');
remove_action('wp_head','adjacent_posts_rel_link_wp_head', 10, 0 );
remove_action('wp_head','wp_shortlink_wp_head', 10, 0 ); 

function solass_wp_style_for_wp_head() { 
echo "<style> .wd-page-nav { display: none; } </style>";
}
add_action( 'wp_head', 'solass_wp_style_for_wp_head', 999 );
}

// +++++++++++++++++ Изменение длины цитаты Записей 
if( get_option( 'solass_wp_post_long_num', '' )) {
$login_changes = $login_changes.'<li>'.__( 'Цитата у списку записів змінена до ', 'solass-wp').get_option( 'solass_wp_post_long_num', '' ).__( ' (слів)', 'solass-wp').'</li>'; 
add_filter( 'excerpt_length', 'solass_wp_post_expert_long_num');
function solass_wp_post_expert_long_num( $length ) {
	return (int)get_option( 'solass_wp_post_long_num', '' ); // кол-во слов
}
}

// +++++++++++++++++++ Ссылка «Читать далее...» после цитаты в цикле. Замена `[...]`
if( get_option( 'solass_wp_post_link_name', '' )) { 
$link_massage = str_replace("...", "", get_option( 'solass_wp_post_link_name', '' ) );
$link_massage = str_replace("[]", "Read more", $link_massage );
if(!$link_massage) { $link_massage = "..."; }
$login_changes = $login_changes.'<li>'.__( 'Посилання [...] замінено на ', 'solass-wp').'"'.$link_massage.'"'.'</li>'; 
function solass_wp_excerpt_readmore($more) { 
global $post;
if( isset($post) ) {
if(get_option( 'solass_wp_post_link_name', '' ) == "...") { 
	$read_more = ""; 
} elseif ( get_option( 'solass_wp_post_link_name', '' ) == "...[]" ) { 
	$read_more = '<p><a href="'. get_permalink($post->ID) . '" class="btn btn-link btn-underline btn-primary">' . __( 'Read more') . '<i class="d-icon-arrow-right"></i></a></p>'; 
} else {
	$read_more = '<p><a href="'. get_permalink($post->ID) . '" class="btn btn-link btn-underline btn-primary">' . __( get_option( 'solass_wp_post_link_name', '' ), 'solass-wp') . '<i class="d-icon-arrow-right"></i></a></p>'; 
} 
}
	return '...</p> '.$read_more;
}
add_filter('excerpt_more', 'solass_wp_excerpt_readmore');
/*
add_filter('the_excerpt', 'solass_wp_replace_excerpt_func');
function solass_wp_replace_excerpt_func( $content ){
	$link = '<a class="read_more" href="'. get_permalink() .'">'.get_option( 'solass_wp_post_link_name', '' ).'</a>';
	return str_replace('[...]', $link, $content );
}
*/
}



// ++++++++++++ Коррекция дизайна флажков меню языков плагина Polylang

require_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Смотрим файл плагинов и Проверяем включен ли плагин Polylang 
$polyalang_on = "";
$url_lang_css = SOLASS_WP_PLUGIN_URL . 'css/pll-solass-wp-lang-menu.css'; 

if (is_plugin_active('polylang/polylang.php') ) { $polyalang_on = "ok"; } else { 
	 $login_changes = $login_changes.'<li>'.__( 'Плагін Polylang - НЕ АКТИВОВАНО! Стилі меню мов не підключені.', 'solass-wp').'</li>'; 
}
if( get_option( 'solass_wp_pll_lang_menu', '' ) && $polyalang_on ) {

if ( !file_exists( SOLASS_WP_PLUGIN_PATH . 'css/pll-solass-wp-lang-menu.css' ) ) {
$login_changes = $login_changes.'<li>'.__( 'Стилі меню мов НЕ ПІДКЛЮЧЕНІ! Не знайдено файл плагіну стилів оформлення.', 'solass-wp').'</li>';
} else {
$login_changes = $login_changes.'<li>'.__( 'Оформлення меню мов для плагіну Polylang - ПІДКЛЮЧЕНО!', 'solass-wp').'</li>';

if (!function_exists('solass_wp_lang_css')) { 
function solass_wp_lang_css() {
  wp_enqueue_style( dirname(plugin_basename(__FILE__), 2).'_pll_menu', SOLASS_WP_PLUGIN_URL . 'css/pll-solass-wp-lang-menu.css' ); 
}
}
add_action( 'wp_enqueue_scripts', 'solass_wp_lang_css' );
}
}


// +++++++++ Підключення css-файлів персональних стилів, або стилів теми
if( get_option( 'solass_wp_add_editor_styles', '' ) ) {  
	$theme_css_url = get_option( 'solass_wp_add_editor_styles', '' );
	$theme_directory = get_template_directory();
	if ( substr($theme_css_url, 0, 1) !== '/' ) { $theme_css_url_test = "/".$theme_css_url; } else { $theme_css_url_test = $theme_css_url; }
	if ( file_exists($theme_directory.$theme_css_url_test) ) {
	$login_changes = $login_changes.'<li>'.__( 'До візуального редактору підключений ваш CSS-файл стилів', 'solass-wp').'</li>'; 
	} else {
	$theme_css_url = "editor-style.css";
	$login_changes = $login_changes.'<li>'.__( '!!! Файл стилю редактору вказанний вами відсутній !!! Була спроба підключити файл: '.$theme_css_url.'<!--'.$theme_directory.$theme_css_url_test.'-->', 'solass-wp').'</li>'; 
	}
if (!function_exists('solass_wp_add_editor_styles')) { 
function solass_wp_add_editor_styles($theme_css_url) {
global $theme_css_url; 
	remove_editor_styles(); 
    add_editor_style( $theme_css_url ); 
}
}
add_action( 'admin_init', 'solass_wp_add_editor_styles' );
}

// +++++++++ Подключаем Iris Color Picker (форма выбора цвета в админке)
require_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Смотрим файл плагинов 
if ( !isset($_GET['page']) ) { $swp_get_page = ''; } else { $swp_get_page = $_GET['page']; }
if( get_option( 'solass_wp_color_colorpicker', '' ) && sanitize_text_field($swp_get_page) != 'xts_theme_settings' /*&& !is_plugin_active('woodmart-core/woodmart-core.php')*/ ) {  
$login_changes = $login_changes.'<li>'.__( 'Додана персональна палітра кольорів для ColorPicker', 'solass-wp').'</li>'; 
//if ( function_exists('colorpicker_enhancement') ) {  }
remove_action( 'admin_enqueue_scripts', 'colorpicker_enhancement' );
function solass_wp_colorpicker_enhancement() {
	// подключаем свой файл скрипта c установками для палитры
    wp_enqueue_script( 'wp-color-picker' );
	$colorpicker_js = "
	jQuery(document).ready(function($) { jQuery('.colorPicker').wpColorPicker({ alpha: true, palettes: [".get_option( 'solass_wp_color_colorpicker', '' )."], }); });
	";
	wp_add_inline_script( 'wp-color-picker', $colorpicker_js ); // Додаємо вставку скрипта у код сторінки після завантаженого файлу.
	/*$colorpicker_js_OLD = "
	jQuery(function($) {
	if (typeof $.wp !== 'undefined' && typeof $.wp.wpColorPicker !== 'undefined') { 
	$.wp.wpColorPicker.prototype.options = { width: 255, hide: true, alpha: true, palettes: [".get_option( 'solass_wp_color_colorpicker', '' )."], }; 
	}
	});
	";*/
}
add_action( 'admin_enqueue_scripts', 'solass_wp_colorpicker_enhancement' );
}


// +++++++++++++++++ Отключаем Emoji
if( get_option( 'solass_wp_del_emoji', true ) ){
$login_changes = $login_changes.'<li>'.__( 'Вимкнені картинки смайликів Emoji.', 'solass-wp').'</li>';
function solass_wp_disable_emojis() {
	remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
	remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
	remove_action( 'wp_print_styles', 'print_emoji_styles' );
	remove_action( 'admin_print_styles', 'print_emoji_styles' );	
	remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
	remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );	
	remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
	add_filter( 'tiny_mce_plugins', 'solass_wp_disable_emojis_tinymce' );
	add_filter( 'wp_resource_hints', 'solass_wp_disable_emojis_remove_dns_prefetch', 10, 2 );
}
add_action( 'init', 'solass_wp_disable_emojis' );

function solass_wp_disable_emojis_tinymce( $plugins ) {
	if ( is_array( $plugins ) ) {
		return array_diff( $plugins, array( 'wpemoji' ) );
	} else {
		return array();
	}
}

function solass_wp_disable_emojis_remove_dns_prefetch( $urls, $relation_type ) {
	if ( 'dns-prefetch' == $relation_type ) {
		/** This filter is documented in wp-includes/formatting.php */
		$emoji_svg_url = apply_filters( 'emoji_svg_url', 'https://s.w.org/images/core/emoji/2.2.1/svg/' );

		$urls = array_diff( $urls, array( $emoji_svg_url ) );
	}

	return $urls;
}
add_filter( 'emoji_svg_url', '__return_false' );

}

// +++++++++++++++++ підключаємо файл Кастомних налаштувань теми
if( get_option( 'solass_wp_customise', false ) ){
$login_changes = $login_changes.'<li>'.__( 'Увімкнено персональні налаштуваня кольорів, стилів та елементів сайту', 'solass-wp').'</li>';

if (file_exists(SOLASS_WP_PLUGIN_PATH . 'wp_customise/wp_customise.php')) {
include( SOLASS_WP_PLUGIN_PATH . 'wp_customise/wp_customise.php' );	
}

}

// +++++++++++++++++ підключаємо файл Кастомних налаштувань теми
if( get_option( 'solass_wp_brauser_barr', '' ) ) {
$login_changes = $login_changes.'<li>'.__( 'Шапка браузера має кастомний колір', 'solass-wp').'</li>';
	
add_action( 'wp_head', 'solass_add_custom_meta_tag' );
function solass_add_custom_meta_tag() {
	if ( is_admin() ) { return; } // Не виконувати в адмінці 
	$theme_color = get_option( 'solass_wp_brauser_barr', '' );
	echo '<meta name="theme-color" content="'.solass_wp_convert_color($theme_color, 'hex').'">' . "\n";
}
}

//------------------------------------------------------------------------------------------------------ //
//-------------------------------------- !!! УСТАНОВКИ SEO --------------------------------------------- //
//------------------------------------------------------------------------------------------------------ //


// ++++++++++++++ !!! ПОДКЛЮЧАЕМ СВОИ ФУНКЦИИ СОЗДАНИЯ МЕТА-ПОЛЕЙ в админке !!! (Работает без плагина ACF)
//
// ++++++++++++++ Подключаем файл кастомной функции SEO-вывода для страницы. Плагин Yoast SEO вполне не плох, можно подключить
require_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Смотрим файл плагинов
if (!is_plugin_active('wordpress-seo/wp-seo.php') && get_option( 'solass_wp_meta_page', '' )) { // Проверяем включен ли плагин Yoast SEO
if (file_exists(__DIR__ . '/seo.php')) {
$login_changes_seo = $login_changes_seo.'<li>'.__( 'Увімкнена функція МЕТА-полів', 'solass-wp').'</li>'; 
require_once __DIR__ . '/seo.php';
solass_wp_SEO_Tags::init();

// создаем в админке форму для редактирования метатегов
class_exists('solass_wp_Post_Meta_Box') && new solass_wp_Post_Meta_Box( array(
	'id'     => '_seo',
	'title'  => 'SEO поля',
	'priority'   => 'low',   // Приоритет блока для показа выше или ниже остальных блоков ('high' или 'low')  high, core, default, low.
	'fields' => array(
		'title' => array( 		'type'=>'text',    'title'=>'Title',       'desc'=>__( 'Заголовок сторінки (рекомендується 70 символів)', 'solass-wp'), 'attr'=>'style="width:99%;"'	),
		'description' => array(	'type'=>'textarea','title'=>'Description', 'desc'=>__( 'Опис сторінки (рекомендується 160 символів)', 'solass-wp'), 'attr'=>'style="width:99%;"' ),
		'keywords' => array( 	'type'=>'text',    'title'=>'Keywords',    'desc'=>__( 'Ключові слова для запису', 'solass-wp'),       'attr'=>'style="width:99%;"'	),
		'robots' => array( 		'type'=>'radio',   'title'=>'Robots',      'options' => array(''=>'index, follow', 'noindex, nofollow'=>'noindex,nofollow') ),
	),
) );
} else { $login_changes_seo = $login_changes_seo.'<li class="no_func">'.__( 'Відсутні файли для підключення функції.', 'solass-wp').'</li>';  }
} elseif (get_option( 'solass_wp_meta_page', '' ))  {
$login_changes_seo = $login_changes_seo.'<li class="no_func">'.__( 'Не працює функція МЕТА-полів! Увімкнено плагін <span class="nowrap">Yoast SEO</span>', 'solass-wp').'</li>'; 
}
	

// ++++++++++++++ Прописываем данные для ROBOTS.TXT !!! если его нет в корневой папке сайта, а если есть то с него возьмутся данные
//
function solass_wp_base_robotstxt(){ // базовые параметры robots.txt
$solass_wp_this_site_url = get_site_url();
$solass_wp_base_robotstxt = "
User-agent: * # For all bots
Disallow: /cgi-bin
Disallow: /?
Disallow: /wp-
Disallow: *?s=
Disallow: *&s=
Disallow: /search/
Disallow: /author/
Disallow: /users/
Disallow: */trackback
Disallow: */feed
Disallow: */rss
Disallow: */embed
Disallow: /xmlrpc.php
Disallow: *utm=
Disallow: *openstat=
Disallow: /tag/ # Close tags
Disallow: /readme.html # WordPress installation manual
Disallow: *?replytocom
Allow: /wp-content/uploads/
Allow: /wp-content/themes/
Allow: /*/*.js             
Allow: /*/*.css            
Allow: /wp-*.png           
Allow: /wp-*.jpg           
Allow: /wp-*.jpeg          
Allow: /wp-*.gif           
Allow: /wp-*.svg           
Allow: /wp-*.pdf 
Allow: */fonts

User-agent: GoogleBot # For Google
Disallow: /cgi-bin
Disallow: /?
Disallow: /wp-
Disallow: *?s=
Disallow: *&s=
Disallow: /search/
Disallow: /author/
Disallow: /users/
Disallow: */trackback
Disallow: */feed
Disallow: */rss
Disallow: */embed
Disallow: /xmlrpc.php
Disallow: *utm=
Disallow: *openstat=
Disallow: /tag/ # Close tags
Disallow: /readme.html
Disallow: *?replytocom
Allow: */uploads
Allow: /*/*.js
Allow: /*/*.css
Allow: /wp-*.png           
Allow: /wp-*.jpg           
Allow: /wp-*.jpeg          
Allow: /wp-*.gif           
Allow: /wp-*.svg           
Allow: /wp-*.pdf 
Allow: /wp-admin/admin-ajax.php
Allow: */fonts

User-agent: Yandex # For Yandex
Disallow: /cgi-bin
Disallow: /?
Disallow: /wp-
Disallow: *?s=
Disallow: *&s=
Disallow: /search/
Disallow: /author/
Disallow: /users/
Disallow: */trackback
Disallow: */feed
Disallow: */rss
Disallow: */embed
Disallow: /xmlrpc.php
Disallow: /tag/ # Close tags
Disallow: /readme.html
Disallow: *?replytocom
Allow: */uploads
Allow: /*/*.js
Allow: /*/*.css
Allow: /wp-*.png           
Allow: /wp-*.jpg           
Allow: /wp-*.jpeg          
Allow: /wp-*.gif           
Allow: /wp-*.svg           
Allow: /wp-*.pdf 
Allow: /wp-admin/admin-ajax.php
Allow: */fonts
Clean-Param: utm_source&utm_medium&utm_campaign
Clean-Param: openstat

Host: ".$solass_wp_this_site_url."
Sitemap: ".$solass_wp_this_site_url."/sitemap.xml";

return $solass_wp_base_robotstxt;
}


require_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Смотрим файл плагинов
if (!is_plugin_active('wordpress-seo/wp-seo.php') && get_option( 'solass_wp_robotstxt', '' )) { // Проверяем включен ли плагин Yoast SEO
$login_changes_seo = $login_changes_seo.'<li>'.__( 'Додані ваші дані до robots.txt', 'solass-wp').'</li>'; 
add_filter( 'robots_txt', 'solass_wp_add_robotstxt');
function solass_wp_add_robotstxt($text){
$solass_wp_robotstxt = get_option( 'solass_wp_robotstxt', '' );
$solass_wp_robotstxt = $text.$solass_wp_robotstxt;
return $solass_wp_robotstxt;
}
} elseif (get_option( 'solass_wp_robotstxt', '' ))  {
$login_changes_seo = $login_changes_seo.'<li class="no_func">'.__( 'Файл robots.txt редагується у іншому плагіні - <a href="admin.php?page=wpseo_tools&tool=file-editor" target=_blank><span class="nowrap">Yoast SEO</span></a>. Ваші дані не включені до файлу robots.txt!', 'solass-wp').'</li>'; 
}


//++++++++++++++++++++++++++ Подключаем код Google Analitics
// 
if( get_option( 'solass_wp_ga_id', '' ) && get_option( 'solass_wp_tracking', '' ) == "gtag") {
$login_changes_seo = $login_changes_seo.'<li>'.__( 'Включений код Google Analytics (gtag.js)', 'solass-wp').'</li>'; 
add_action('wp_head','solass_wp_google_analytics', 20); //'wp_footer'
function solass_wp_google_analytics() {
?>
<!-- Google Analytics - Global Site Tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo esc_attr( get_option( 'solass_wp_ga_id', '' ) ); ?>"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', '<?php echo esc_attr( get_option( 'solass_wp_ga_id', '' ) ); ?>');
</script>
<!-- End Google Analytics -->
<?php
}
} elseif ( get_option( 'solass_wp_ga_id', '' ) && get_option( 'solass_wp_tracking', '' ) == "ua") {
$login_changes_seo = $login_changes_seo.'<li>'.__( 'Включений код Google Analytics (analytics.js)', 'solass-wp').'</li>'; 
if (solass_wp_ModernBrowser()) { // Перевіряємо чи вважається браузер новим
// Код для сучасних браузерів 
add_action('wp_head','solass_wp_google_analytics_new_ua', 20); //'wp_footer'
function solass_wp_google_analytics_new_ua() { ?>
<!-- Google Analytics - Universal Analytics (new browser) -->
<script>window.ga=window.ga||function(){
(ga.q=ga.q||[]).push(arguments)};ga.l=+new Date;ga('create', 
'<?php echo esc_attr( get_option( 'solass_wp_ga_id', '' ) ); ?>', 'auto');ga('send', 'pageview');</script><script async 
src='https://www.google-analytics.com/analytics.js'></script>
<!-- End Google Analytics -->
<?php
}
} else { 
// Код для старих браузерів 
add_action('wp_head','solass_wp_google_analytics_ua', 20); //'wp_footer'
function solass_wp_google_analytics_ua() { ?>
<!-- Google Analytics - Universal Analytics (old browser) -->
<script>(function(i,s,o,g,r,a,m){i[
'GoogleAnalyticsObject']=r;i[r]=i[r]||function(){(i[r].q=i[r].
q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.
insertBefore(a,m)})(window,document,'script',
'https://www.google-analytics.com/analytics.js','ga');ga('create', 
'<?php echo esc_attr( get_option( 'solass_wp_ga_id', '' ) ); ?>', 'auto');ga('send', 
'pageview');</script>
<!-- End Google Analytics -->
<?php
}
}
}

//+++++++++++++++++ Выводим код вверху страницы между <HEAD>...</HEAD>
// 
if( get_option( 'solass_wp_head_code', '' )) {
$login_changes_seo = $login_changes_seo.'<li>'.__( 'Ваш код виводиться між тегами &lt;head>...&lt;/head>', 'solass-wp').'</li>'; 
add_action('wp_head','solass_wp_head_code', 20); //'wp_footer'
function solass_wp_head_code() {
?>
<!-- SOLASS WPSettings - Custom code at the top of the page -->
<?php echo get_option( 'solass_wp_head_code', '' ); ?>

<!-- End -->
<?php
}
}

//+++++++++++++++++++ Выводим код внизу страницы между перед </BODY>
// 
if( get_option( 'solass_wp_footer_code', '' )) {
$login_changes_seo = $login_changes_seo.'<li>'.__( 'Ваш код внизу сторінки виводиться перед тегом &lt;/body>', 'solass-wp').'</li>'; 
add_action('wp_footer','solass_wp_footer_code', 20); //'wp_head'
function solass_wp_footer_code() {
?>
<!-- SOLASS WPSettings - Custom code at the bottom of the page -->
<?php echo get_option( 'solass_wp_footer_code', '' ); ?>

<!-- End -->
<?php
}
}


//------------------------------------------------------------------------------------------------------ //
//----------------------------------------------- !!! CSS ---------------------------------------------- //
//------------------------------------------------------------------------------------------------------ //


//+++++++++++++++++ Выводим пользовательский CSS-код на всех страницах
// 
if( get_option( 'solass_wp_css_code', '' ) &&  get_option( 'solass_wp_css_type', '' ) == "code") {
if( get_option( 'solass_wp_css_code_head', true )) {
// Выводим код вверху страницы между <HEAD>...</HEAD> 
if (!isset($login_changes_css)) { $login_changes_css = ''; }
$login_changes_css = $login_changes_css.'<li>'.__( 'Ваш CSS-код виводиться між тегами &lt;head>', 'solass-wp').'</li>'; 
add_action('wp_head','solass_wp_head_css_code', 20); //'wp_footer'
function solass_wp_head_css_code() { ?>
<!-- SOLASS WPSettings - Custom CSS at the top of the page -->
<style>
<?php echo get_option( 'solass_wp_css_code', '' ); ?>

</style>
<!-- End -->
<?php
}
} else {
// Выводим код внизу страницы между перед </BODY>
$login_changes_css = $login_changes_css.'<li>'.__( 'Ваш CSS-код виводиться внизу сторінки перед тегом &lt;/body>', 'solass-wp').'</li>'; 
add_action('wp_footer','solass_wp_footer_css_code', 20); //'wp_head'
function solass_wp_footer_css_code() { ?>
<!-- SOLASS WPSettings - Custom CSS at the bottom of the page -->
<style>
<?php echo get_option( 'solass_wp_css_code', '' ); ?>

</style>
<!-- End -->
<?php
}
}
}

if( get_option( 'solass_wp_css_code', '' ) && get_option( 'solass_wp_css_type', '' ) == "file" ) {
$uploads_dir_var = wp_upload_dir();
$upload_dir_css_file = $uploads_dir_var['baseurl'].'/solass-wp-uploads'.'/custom_swps.css';
$login_changes_css = $login_changes_css.'<li>'.__( 'CSS-код підключається до сторінок у вигляді файлу - ', 'solass-wp').'<a href="'.$upload_dir_css_file.'" target=_blank>custom_swps.css</a></li>'; 
// Підключаємо файл стилю
function solass_wp_css_file() {
	$uploads_dir_var = wp_upload_dir();
	$upload_dir_css_file = $uploads_dir_var['baseurl'].'/solass-wp-uploads'.'/custom_swps.css';
	// Підключаємо стилі
	wp_enqueue_style( dirname(plugin_basename(__FILE__),2).'_custom_swps', $upload_dir_css_file ); 
}
if( get_option( 'solass_wp_css_code_head', true )) { 
$login_changes_css = $login_changes_css.'<li>'.__( 'Файл ваших CSS-стилів підключається у верхній частині коду сторінки між тегами &lt;head>', 'solass-wp').'</li>'; 
add_action( 'wp_enqueue_scripts', 'solass_wp_css_file', PHP_INT_MAX ); 
} else {
$login_changes_css = $login_changes_css.'<li>'.__( 'Файл ваших CSS-стилів підключається у нижній частині коду сторінки', 'solass-wp').'</li>'; 
add_action( 'wp_footer', 'solass_wp_css_file' ); 
}
}


//+++++++++++++++++ Виводимо базовий CSS-код від розробників SOLASS
//
if( get_option( 'solass_wp_base_css', '' ) && get_option( 'solass_wp_base_css_on', false ) ) {
$uploads_dir_var = wp_upload_dir();
$upload_dir_css_file = $uploads_dir_var['baseurl'].'/solass-wp-uploads/solass_wp_base_css.css';
$login_changes_css = $login_changes_css.'<li>'.__( 'Підключено базовий CSS від розробників - ', 'solass-wp').'<a href="'.$upload_dir_css_file.'" target=_blank>solass_wp_base_css.css</a></li>'; 
// Підключаємо файл стилю
add_action( 'wp_enqueue_scripts', 'solass_wp_base_css', PHP_INT_MAX );
function solass_wp_base_css() {
	$uploads_dir_var = wp_upload_dir();
	$upload_dir_css_file = $uploads_dir_var['baseurl'].'/solass-wp-uploads/solass_wp_base_css.css';
    wp_enqueue_style( 'solass_wp_base_css', $upload_dir_css_file, array() , get_plugin_data(__FILE__)['Version']);
}
}



//------------------------------------------------------------------------------------------------------ //
//------------------------------------------ !!! WOOCOMMERCE ------------------------------------------- //
//------------------------------------------------------------------------------------------------------ //
if ( !isset($login_changes_woo) ) { $login_changes_woo = ""; }

require_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Смотрим файл плагинов
if (is_plugin_active('woocommerce/woocommerce.php')) { // Проверяем включен ли плагин WooCommerce


// +++++++++++ Функция преобразования магазина в КАТАЛОГ

if( get_option( 'solass_wp_katalog_on', '' ) ) { 
$login_changes_woo = $login_changes_woo.'<li><strong>'.__( 'WooCommerce працює у режимі каталогу', 'solass-wp').'</strong></li>'; 

add_action( 'wp', 'solass_wp_remove_woocommerce_hooks' );
function solass_wp_remove_woocommerce_hooks() {
    remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
    remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
    remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );
    remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
    remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cart_totals', 10 );
    remove_action( 'woocommerce_proceed_to_checkout', 'woocommerce_button_proceed_to_checkout', 20 );
    remove_action( 'woocommerce_checkout_order_review', 'woocommerce_checkout_payment', 20 );
    remove_action( 'woocommerce_checkout_order_review', 'woocommerce_checkout_coupon_form', 10 );
    remove_action( 'woocommerce_review_order_before_submit', 'woocommerce_checkout_shipping_form', 10 );
    remove_action( 'woocommerce_review_order_before_submit', 'woocommerce_checkout_terms_and_conditions', 20 );
    remove_action( 'woocommerce_review_order_after_submit', 'woocommerce_checkout_order_review', 10 );
    remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
if( !get_option( 'solass_wp_katalog_price_on', '' ) ) { remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 ); } //ціна
if( !get_option( 'solass_wp_katalog_excerpt_on', true ) ) { remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 ); } //короткий опис
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50 );
//    add_filter( 'woocommerce_product_tabs', 'solass_wp_remove_product_tabs', 98 ); // Вызов функции отключения вкладок
    add_filter( 'woocommerce_is_purchasable', '__return_false' );
	add_filter( 'woocommerce_add_to_cart_fragments', 'solass_wp_remove_cart_link_fragment' );
}

// Вывод подробного описания без вкладки
if( get_option( 'solass_wp_katalog_description_on', '' ) ) {
$login_changes_woo = $login_changes_woo.'<li>'.__( 'Виводиться тільки детальний опис товару', 'solass-wp').'</li>'; 
add_action( 'woocommerce_product_tabs', 'show_product_tabs_contents', 50 );
function show_product_tabs_contents() {
    global $product;
    // Вывод содержимого вкладок
    the_content();
}
}

if( get_option( 'solass_wp_katalog_line_info', '' ) && !get_option( 'solass_wp_katalog_description_on', '' ) ) {
$login_changes_woo = $login_changes_woo.'<li>'.__( 'Вкладки виводяться друг під другом', 'solass-wp').'</li>'; 
function woocommerce_output_product_data_tabs() {
 
	// сохраняем в массив все вкладки
	$product_tabs = apply_filters( 'woocommerce_product_tabs', array() );
 
	if ( empty( $product_tabs ) ) {
		return;
	}
	echo '<div class="woocommerce-tabs wc-tabs-wrapper">';
	// цикл для каждой вкладки
	foreach ( $product_tabs as $key => $product_tab ) {
		echo '<div id="tab-' . esc_attr( $key ) . '">';
		// callback – функция для вывода содержимого вкладки
		if ( isset( $product_tab[ 'callback' ] ) ) {
			call_user_func( $product_tab[ 'callback' ], $key, $product_tab );
		}
		echo '</div>';
	}
	echo '</div>';
}
}

// Отключение вкладок (Отключил функцию не зная где применить)
function solass_wp_remove_product_tabs( $tabs ) { 
        foreach ( $tabs as $key => $tab ) { 
		if( get_option( 'solass_wp_katalog_description_on', true ) ) { $desc_key = 'description'; } else { $desc_key = 'none'; }
		if($tabs[$desc_key] != $tabs[esc_attr( $key )]) { unset( $tabs[esc_attr( $key )] ); }
        }
	// Стандартні вкладки
/*	unset( $tabs['description'] ); 
    unset( $tabs['reviews'] );
    unset( $tabs['additional_information'] );
*/
    return $tabs;
}

// Удаление ссылки на корзину и количества товаров в шапке сайта
function solass_wp_remove_cart_link_fragment( $fragments ) {
    unset( $fragments['a.cart-contents'] );
    return $fragments;
}

}


// +++++++++++ End КАТАЛОГ



// +++++++++++ ДОДАТКОВИЙ опис категорії внизу сторінки
if( get_option( 'solass_wp_taxonomy_custom_meta', '' ) ) { 
$login_changes_woo = $login_changes_woo.'<li>'.__( 'Додатковий опис розділу виводиться внизу сторінки.', 'solass-wp').'</li>';

add_action( 'product_cat_edit_form_fields', 'solass_wp_taxonomy_edit_meta_field', 10, 2 );
function solass_wp_taxonomy_edit_meta_field($term) {
$t_id = $term->term_id;
$term_meta = get_option( "taxonomy_$t_id" );
$content = $term_meta['custom_term_meta'] ? wp_kses_post( $term_meta['custom_term_meta'] ) : '';
$settings = array( 'textarea_name' => 'term_meta[custom_term_meta]' );
?>
<tr class="form-field">
<th scope="row" valign="top"><label for="term_meta[custom_term_meta]"><?php echo __( 'Додатковий опис', 'solass-wp'); ?></label></th>
<td>
<?php wp_editor( $content, 'product_cat_details', $settings ); ?>
</td>
</tr>
<?php
}

add_action( 'edited_product_cat', 'solass_wp_save_taxonomy_custom_meta', 10, 2 );
add_action( 'create_product_cat', 'solass_wp_save_taxonomy_custom_meta', 10, 2 );
function solass_wp_save_taxonomy_custom_meta( $term_id ) {
  if ( isset( $_POST['term_meta'] ) ) {
    $t_id = $term_id;
    $term_meta = get_option( "taxonomy_$t_id" );
    $cat_keys = array_keys( $_POST['term_meta'] );
    foreach ( $cat_keys as $key ) {
      if ( isset ( $_POST['term_meta'][$key] ) ) {
        $term_meta[$key] = wp_kses_post( stripslashes($_POST['term_meta'][$key]) );
      }
    }
    update_option( "taxonomy_$t_id", $term_meta );
  }
}

// woocommerce_after_shop_loop (после товара и до страниц) - вызывается раньше чем woocommerce_after_main_content
add_action( 'woocommerce_after_main_content', 'solass_wp_product_cat_archive_add_meta' ); 
function solass_wp_product_cat_archive_add_meta() {
  $t_id = get_queried_object()->term_id;
  $term_meta = get_option( "taxonomy_$t_id" );
  $term_meta_content = $term_meta['custom_term_meta'];
  if ( $term_meta_content != '' ) {
    if ( is_tax( array( 'product_cat', 'product_tag' ) ) && 0 === absint( get_query_var( 'paged' ) ) ) {
      echo '<div class="woo-sc-box normal rounded full">';
      echo apply_filters( 'the_content', $term_meta_content );
      echo '</div>';
    }
  }
}

}


// +++++++++++ Додаємо сортування товарів зі знижками
if( get_option( 'solass_wp_sort_discount', '' ) ) { 
$login_changes_woo = $login_changes_woo.'<li>'.__( 'Додане сортування за знижкою', 'solass-wp').'</li>'; 

add_filter( 'woocommerce_catalog_orderby', 'solass_wp_add_sort_discount' );
function solass_wp_add_sort_discount( $options ){
 	$options[ 'discount_amount' ] = __( 'Сортування за знижкою', 'solass-wp');
	return $options;
}

add_filter( 'woocommerce_get_catalog_ordering_args', 'solass_wp_custom_product_sorting' );
function solass_wp_custom_product_sorting( $args ) {
	// Сортируем по проценту скидки – от высокого к низкому
	if( isset( $_GET[ 'orderby' ] ) && 'discount_amount' === $_GET['orderby'] ) {
		$args[ 'meta_key' ] = 'discount_amount';
		$args[ 'order' ] = 'DESC'; // от высокого к низкому
	}
	return $args;
}

add_action( 'woocommerce_product_quick_edit_save', 'solass_wp_meta_discount' );
add_action( 'woocommerce_process_product_meta', 'solass_wp_meta_discount');
function solass_wp_meta_discount( $product ) {
	$product = wc_get_product( $product );
	// если товар не на распродаже, то удаляем мета поле и больше ничего не делаем
	if( ! $product->is_on_sale() ) {
		delete_post_meta( $product->get_id(), 'discount_amount' );
		return;
	}
	$regular = $product->get_regular_price();
	$sale = $product->get_sale_price();
	$discount = round( 100 - ( $sale / $regular * 100), 2 );
	// сохраняем процент скидки в мета-поле
	update_post_meta( $product->get_id(), 'discount_amount', $discount );
}

}

//+++++++ Переносимо товар що закінчився в кінець списку
if( get_option( 'solass_wp_exclude_prod', '' ) ) { 
if (!isset($login_changes_woo)) { $login_changes_woo = ''; }
$login_changes_woo = $login_changes_woo.'<li>'.__( 'Товар що закінчився виводиться у кінці списку', 'solass-wp').'</li>'; 

class iWC_Orderby_Stock_Status {
public function __construct() {
    if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
        add_filter('posts_clauses', array($this, 'solass_wp_order_by_stock_status'), 2000);
    }
}
public function solass_wp_order_by_stock_status($posts_clauses) {
    global $wpdb;  
    if (is_woocommerce() && (is_shop() || is_product_category() || is_product_tag())) {
        $posts_clauses['join'] .= " INNER JOIN $wpdb->postmeta istockstatus ON ($wpdb->posts.ID = istockstatus.post_id) ";
        $posts_clauses['orderby'] = " istockstatus.meta_value ASC, " . $posts_clauses['orderby'];
        $posts_clauses['where'] = " AND istockstatus.meta_key = '_stock_status' AND istockstatus.meta_value <> '' " . $posts_clauses['where'];
    }
    return $posts_clauses;
    }
}
new iWC_Orderby_Stock_Status;

}

//+++++++ Убираем вывод и подсчет доставки на всех страницах
if( get_option( 'solass_wp_dostavka', '' ) ) {
$login_changes_woo = $login_changes_woo.'<li>'.__( 'Вимкнута інформація про доставку', 'solass-wp').'</li>'; 
add_filter('woocommerce_cart_shipping_method_full_label','solass_wp_remove_local_pickup_free_label', 10, 2); 
function solass_wp_remove_local_pickup_free_label($full_label, $method){ 
    $full_label = substr($full_label, 0, strpos($full_label, ':')); 
    return $full_label; 
}
}

//+++++++ Убираем вывод цены в магазине если она равна НУЛЮ
if( get_option( 'solass_wp_null_price', '' ) ) {
if(!isset($login_changes_woo)) { $login_changes_woo = ''; }
$login_changes_woo = $login_changes_woo.'<li>'.__( 'Не виводиться ціна яка дорівнює нулю', 'solass-wp').'</li>'; 

add_filter( 'woocommerce_get_price_html','solass_wp_maybe_hide_price',10,2);
function solass_wp_maybe_hide_price($price_html, $product) { 
// Если включена функция и есть цены на странице, то добавляем код очистки сложных нулевых цен
require_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Смотрим файл плагинов
if ( is_plugin_active('wpc-grouped-product-premium/wpc-grouped-product.php') || is_plugin_active('wpc-grouped-product/wpc-grouped-product.php') ) { 
add_action( 'wp_footer', 'solass_wp_clear_null_price', 1 ); 
}
	$test_price_html = intval( preg_replace('/\D/', '', strip_tags( preg_replace('/<[^>]+class=["\']woocommerce-Price-currencySymbol["\'][^>]*>.*?<\/[^>]+>/', '', $price_html ) ) ) );
	if($product->get_price() > 0 || $test_price_html){ 
	 //echo "------ ".$test_price_html." ----------";
     return $price_html;
     }
    return '&nbsp;';
}

// Проверяем включен ли плагин WPC Grouped Product for WooCommerce
function solass_wp_clear_null_price() { 
echo "
<!-- Скрипт очистки нульової ціни на сторінці -->
<script>
    function swp_updatePriceVisibility() {
        // Получаем все элементы с классом .woocommerce-Price-amount
        var priceElements = document.querySelectorAll('.woocommerce-Price-amount');
        // Перебираем все элементы
        priceElements.forEach(function (element) {
            // Получаем текстовое содержимое span
            var priceText = element.textContent;
            // Извлекаем числовое значение из текста (убираем знак валюты и запятую)
            var price = parseFloat(priceText.replace(/[^\d.]/g, ''));
            // Устанавливаем видимость в зависимости от значения
            element.style.visibility = (price > 0) ? 'visible' : 'hidden';
        });
    }
    // Вызываем функцию сразу и устанавливаем периодическую проверку каждую секунду
    swp_updatePriceVisibility();
    setInterval(swp_updatePriceVisibility, 1000);
</script>
";
}
	
} 

//++++++++ Отключаем кнопку "в корзину" в магазине если цена товара равна НУЛЮ
if( get_option( 'solass_wp_add_to_cart', '' ) ) {
$login_changes_woo = $login_changes_woo.'<li>'.__( 'Вимкнута кнопка "у корзину" коли відсутня ціна', 'solass-wp').'</li>'; 
add_filter( 'woocommerce_is_purchasable', 'solass_wp_remove_add_to_cart_on_0', 10, 2 );
function solass_wp_remove_add_to_cart_on_0 ( $purchasable, $product ){
        if( $product->get_price() == 0 )
            $purchasable = false;
        return $purchasable;
    }
}


// +++++++++++++++ Устанавливаем категорию WooCommerce по умолчанию ++++++++++++

if( get_option( 'solass_wp_woo_default_categories', '' ) ) { 

$category_name = add_action( 'init', function() { 
global $login_changes_woo;
$arr_categories = get_option( 'solass_wp_woo_default_categories', '' ); 
$categories_info = solass_wp_get_page_by_id('product_cat', $arr_categories[0]);
if ($categories_info) { $category_name = $categories_info->my_title; }
// return $category_name;
$login_changes_woo = $login_changes_woo.'<li>'.__( 'Дефолтною категорією для WooCommerce вcтановлено "', 'solass-wp').$category_name.'" ('.$arr_categories[0].')</li>'; 
} );

add_filter( 'option_default_product_cat', function( $value, $option ) { 
$arr_categories = get_option( 'solass_wp_woo_default_categories', '' ); 
return (int)$arr_categories[0]; 
}, 9999, 2 );

}

/* +++++++++++++ Вывод информации под ценой в верхней части +++++++++ */
add_action( 'init', 'solass_wp_admin_woo_price_text_func' ); //admin_init
function solass_wp_admin_woo_price_text_func() {
global $login_changes_woo;
$solass_wp_admin_woo_price_text = 'solass_wp_admin_woo_price_text' . SOLASS_WP_POLYLANG_LANG; 

if ( esc_attr( get_option( 'solass_wp_admin_woo_price_text' . SOLASS_WP_POLYLANG_LANG, '' ) ) ) {
$login_changes_woo = $login_changes_woo.'<li>'.__( 'Додана інформація яка виводиться під ціною на сторінці продукту').'</li>'; 

add_action( 'woocommerce_single_product_summary', 'solass_wp_admin_woo_price_text_print', 11); 
function solass_wp_admin_woo_price_text_print(){
echo wpautop( do_shortcode( get_option( 'solass_wp_admin_woo_price_text' . SOLASS_WP_POLYLANG_LANG, '' ) ) ); //вывод текста с учетом форматирования и шорткодов
} 
}
}

/* +++++++++++++ Автоматическое добавление аттрибута к товару имеющему стоимость НОЛЬ +++++++++ */

if( get_option( 'swp_product_attribute_woo_options', '' ) && get_option( 'swp_product_attribute_woo_name', '' )  ) { 

if (get_option( 'swp_product_attribute_woo_on', '' )) {
$login_changes_woo = $login_changes_woo.'<li>'.__( 'Додається автоматично аттрибут "'.get_option( 'swp_product_attribute_woo_name', '' ).'" до всіх товарів без ціни').'</li>'; 
} else { 
$login_changes_woo = $login_changes_woo.'<li>'.__( 'Автоматичне видалення атрибуту "'.get_option( 'swp_product_attribute_woo_name', '' ).'" у всіх товарів що його мають').'</li>'; 
}

function solass_wp_print_product_attribute_on_prew() { 
	global $post;
	// Получаем объект продукта
    $product = wc_get_product($post->ID);

	$prod_slug_attribute = get_option( 'swp_product_attribute_woo_name', '' ); 
	$attribute_id = wc_attribute_taxonomy_id_by_name($prod_slug_attribute);
	$term_id_array = array( (int)get_option( 'swp_product_attribute_woo_options', '' )[0] ); //392 
		
	$term = get_term_by('id', (int)get_option( 'swp_product_attribute_woo_options', '' )[0], $prod_slug_attribute); 
	
if ( ( $product->get_price() == 0 || !$product->get_price() || $product->get_attribute($prod_slug_attribute) ) ) { 

if( $attribute_id ) {
$price_html = intval( preg_replace('/\D/', '', strip_tags( preg_replace('/<[^>]+class=["\']woocommerce-Price-currencySymbol["\'][^>]*>.*?<\/[^>]+>/', '', $product->get_price_html() ) ) ) );
//echo "--------- ".$price_html." -------- ".$product->get_price()." ------- ".$product->get_type();

	// Получаем объект продукта
	//$product = wc_get_product($post_id);
    $attribute_name = $prod_slug_attribute; // Замените на имя вашего атрибута
    $attribute_value = $term_id_array;   // Замените на значение вашего атрибута
	$attributes = $product->get_attributes();

    // Проверяем, если стоимость продукта равна 0
    if ( ($product->get_price() == 0 || !$product->get_price() ) && !$price_html && get_option( 'swp_product_attribute_woo_on', '' ) ) { 
	/* && ( $product->is_type('simple') || $product->is_type('variable') ) */
$attribute_array = array(
    $prod_slug_attribute => array(
        'id' => $attribute_id,
        'name' => $prod_slug_attribute,
        'options' => $term_id_array, //392
        'position' => 1,
        'visible' => 1,
        'variation' => false,
    ),
); 
// Перебираем массив и создаем объекты WC_Product_Attribute
$obj_attributes = array();
foreach ($attribute_array as $attribute_slug => $attribute_data) {
    $new_attribute = new WC_Product_Attribute();
    $new_attribute->set_id($attribute_data['id']); // Устанавливаем ID (если есть)
    $new_attribute->set_name($attribute_data['name']);
    $new_attribute->set_options($attribute_data['options']);
    $new_attribute->set_position($attribute_data['position']);
    $new_attribute->set_visible($attribute_data['visible']);
    $new_attribute->set_variation($attribute_data['variation']);

    $obj_attributes[$attribute_slug] = $new_attribute; 
}
$attributes[$prod_slug_attribute] = $obj_attributes[$prod_slug_attribute];

} else { 
/*
 $attribute_array = array( $prod_slug_attribute => array( 'id' => '', 'name' => $prod_slug_attribute, 'options' => $term_id_array, 'position' => 1, 'visible' => 0, 'variation' => false, ), ); 
*/
unset($attributes[$prod_slug_attribute]); 
}
//print_r($attributes);
$product->set_attributes( $attributes );
$product->save();
}
//echo '<div class="product-labels labels-rounded" style="z-index: 11;"><span class="attribute-label product-label label-term-call-for-pricing label-attribute-pa_backorder">'.$term->name.'</span></div>';
//echo "----------".print_r($product);
}
}
// Хук перед выводом ярлыков на превью в списке товара
add_action('woocommerce_before_shop_loop_item', 'solass_wp_print_product_attribute_on_prew', 1); //
// Хук перед выводом ярлыков на большом фото в карточке товара
add_action('woocommerce_before_single_product', 'solass_wp_print_product_attribute_on_prew', 1);

}


/* +++++++++++++++++++++++++ Функции работы с вкладками ++++++++++++++++++++++++++ */

if( get_option( 'woo_tabs_arrey', '' ) ) {

$solass_wp_woo_tabs_arrey = get_option( 'woo_tabs_arrey', '' );
$nazva_tab = ""; $unset_tab = ""; $page_tab = ""; $number_tab = 0;
foreach ( $solass_wp_woo_tabs_arrey as $key => $tab ) { 
	$number_tab = $number_tab + 1;
	if(!empty($tab['unset'])) { $unset_tab =  $unset_tab.__( $tab['tabs'], 'solass-wp').", "; }
	if(!empty($tab['title']) && $tab['title']) { $nazva_tab =  $nazva_tab.__( $tab['title'], 'solass-wp').", "; }
	if(!empty($tab['page'])) { $page_tab =  $page_tab.__( $tab['page'][0], 'solass-wp').", "; }
//unset  //title  //priority  //page 
//description  //additional_information  //reviews  //wd_additional_tab
} 
	$nazva_tab = substr($nazva_tab,0,-2);
	if($unset_tab) { $login_changes_woo = $login_changes_woo.'<li>' . __( 'Вимкнутий показ деяких вкладок', 'solass-wp') . '</li>'; }
	if($nazva_tab) { $login_changes_woo = $login_changes_woo.'<li>' . __( 'Змінені назви деяких вкладок: ', 'solass-wp') . $nazva_tab . '</li>'; } 
	if($page_tab) { $login_changes_woo = $login_changes_woo.'<li>' . __( 'Підключений вивод сторінки до вкладки', 'solass-wp') . '</li>'; } 
	$login_changes_woo = $login_changes_woo.'<li>' . __( 'Можливо змінена послідовність вкладок', 'solass-wp') . '</li>';

// ++++++++++ Переименование вкладок WooCommerce
add_filter( 'woocommerce_product_tabs', 'solass_wp_truemisha_rename_tabs', 25 );
function solass_wp_truemisha_rename_tabs( $tabs ) { 
$solass_wp_woo_tabs_arrey = get_option( 'woo_tabs_arrey', '' );
foreach ( $solass_wp_woo_tabs_arrey as $key => $tab ) { 
if($tab['title']) { $tabs[ $tab['tabs'] ][ 'title' ] = $tab['title']; }
}
//	$tabs[ 'wd_additional_tab' ][ 'title' ] = 'Умови доставки';
//	$tabs[ 'description' ][ 'title' ] = 'Про товар';
//	$tabs[ 'reviews' ][ 'title' ] = 'Что думают люди';
//	$tabs[ 'additional_information' ][ 'title' ] = 'Характеристики'; 
	return $tabs;
}

// ++++++++++++++ Изменение порядка вкладок WooCommerce
add_filter( 'woocommerce_product_tabs', 'solass_wp_truemisha_reorder_tabs', 25 );
function solass_wp_truemisha_reorder_tabs( $tabs ) { 
$solass_wp_woo_tabs_arrey = get_option( 'woo_tabs_arrey', '' );
foreach ( $solass_wp_woo_tabs_arrey as $key => $tab ) { 
if(!$tab['close'] && $tab['tabs']) { 
	$tabs[ $tab['tabs'] ][ 'priority' ] = (int)$tab['priority'];
}
}
//	$tabs[ 'description' ][ 'priority' ] = 2;
//	$tabs[ 'additional_information' ][ 'priority' ] = 0;
//	$tabs[ 'wd_additional_tab' ][ 'priority' ] = 1;
	return $tabs;
}

// ++++++++++++++ Вывод содержимого указанной страницы для вкладки
add_filter( 'woocommerce_product_tabs', 'solass_wp_custom_description_tab', 25 );
function solass_wp_custom_description_tab( $tabs ) { 
global $solass_wp_tab_page_info;
$solass_wp_woo_tabs_arrey = get_option( 'woo_tabs_arrey', '' );
$tab['page'] = null;
foreach ( $solass_wp_woo_tabs_arrey as $key => $tab ) { 
if(!empty($tab['page'][0])) {  
//$solass_wp_tab_page_info = solass_wp_get_page_by_id( 'page', $tab['page'][0]);
$solass_wp_tab_page_info = $tab['page'][0];
$tabs[ $tab['tabs'] ][ 'callback' ] = 'solass_wp_tab_page';  
}
$tab['page'] = null;
}
	return $tabs;
}

function solass_wp_tab_page() { 
global $solass_wp_tab_page_info; 
//print_r($solass_wp_tab_page_info); 
$my_post_obj = get_post( $solass_wp_tab_page_info );
//echo $my_post_obj->post_content;
$elementor_data = null;
$wpb_data = null; $wpb_data_css = null;
$solass_wp_post_obj = null;
$elementor_data = get_post_meta( $solass_wp_tab_page_info, '_elementor_data', true );
$wpb_data = get_post_meta( $solass_wp_tab_page_info, '_wpb_post_custom', true );
$wpb_data_css = get_post_meta( $solass_wp_woo_acc_page_info, '_wpb_shortcodes_custom_css', false ); 
   if ( ! empty( $elementor_data ) ) { 
        $content = \Elementor\Plugin::instance()->frontend->get_builder_content( $solass_wp_tab_page_info, true ); 
        echo $content;
function solass_wp_elementor_start_js() { ?>
    <script>
	// Код перерасчета позиций для плагина Elementor
	jQuery(document).ready(function($) {
		$('[role="tablist"]').on('click', '[role="tab"]', function() { 
//		elementorFrontend.elementsHandler.runReadyTrigger('updateElementPosition');
	}); 
	});
    </script>
<?php }
add_action( 'wp_footer', 'solass_wp_elementor_start_js', 999 );
	   
    } elseif ( ! empty( $wpb_data ) || ! empty( $wpb_data_css ) ) { 
	   $solass_wp_post_obj = wpautop($my_post_obj->post_content); 
	   if( ! empty( $wpb_data ) ) { $solass_wp_post_obj = $wpb_data; }
	//	echo $solass_wp_post_obj; 
	   echo apply_filters( 'the_content', $solass_wp_post_obj, 25 );
   	} else { 
       $my_post_obj = get_post( $solass_wp_tab_page_info );
	   $solass_wp_post_obj = wpautop($my_post_obj->post_content); 
      echo apply_filters( 'the_content', $solass_wp_post_obj, 25 );
    }
}

// +++++++++++ Функция отключения вкладок WooCommerce
add_filter( 'woocommerce_product_tabs', 'solass_wp_truemisha_remove_product_tabs', 25 );
function solass_wp_truemisha_remove_product_tabs( $tabs ) { 
$solass_wp_woo_tabs_arrey = get_option( 'woo_tabs_arrey', '' );
foreach ( $solass_wp_woo_tabs_arrey as $key => $tab ) { 
if(!empty($tab['unset']) || !empty($tab['close'])) { unset( $tabs[ $tab['tabs'] ] ); }
}
//	unset( $tabs[ 'description' ] ); // вкладка Описание
//	unset( $tabs[ 'reviews' ] ); // вкладка Отзывы
//	unset( $tabs[ 'additional_information' ] ); // вкладка Детали 
	return $tabs;
}

}
// --------End Функции работы с вкладками



/* +++++++++++++ Функції додавання додаткових параметрів до карточки товару +++++++++++++++++++++++ */

if( get_option( 'solass_wp_prod_text_var', false ) ) {
$login_changes_woo = $login_changes_woo.'<li>'.__( 'Доданий до товару "Текстовий додатковий параметр"', 'solass-wp').'</li>'; 

// Добавление поля загрузки файла в редактировании товара
function solass_wp_custom_product_text() {
    global $post;
    echo '<div class="options_group">';
    // Поле для загрузки файла
    woocommerce_wp_text_input( array(
        'id' => 'swp_custom_prod_text',
        'label' => 'Додатковий параметр',
        'description' => 'Додатковий параметр - це користувацька інформація/значення що можуть використовуватись у карточці товару',
        'desc_tip' => 'true',
    ) );
    echo '</div>';
}
add_action( 'woocommerce_product_options_general_product_data', 'solass_wp_custom_product_text' );

// Сохранение кастомной информации при сохранении товара
function solass_wp_save_custom_product_text( $post_id ) {
    if ( isset( $_POST['swp_custom_prod_text'] ) ) {
        update_post_meta( $post_id, 'swp_custom_prod_text', sanitize_text_field( $_POST['swp_custom_prod_text'] ) );
    }
}
add_action( 'woocommerce_process_product_meta', 'solass_wp_save_custom_product_text' );


// Включаємо вивід інформації на сторінці по хуку
if( get_option( 'solass_wp_prod_text_var_position', '' ) ) {
$solass_wp_prod_text_var_prioritet = get_option( 'solass_wp_prod_text_var_prioritet', 0 );
// Виводемо параметр у необхідному місці
add_action( get_option( 'solass_wp_prod_text_var_position', 'woocommerce_after_single_product_summary' ), 'solass_wp_add_custom_info_after_wishlist', $solass_wp_prod_text_var_prioritet); 
function solass_wp_add_custom_info_after_wishlist() { 
    global $post;
    $swp_custom_prod_text = get_post_meta( $post->ID, 'swp_custom_prod_text', true );
    if ( ! empty( $swp_custom_prod_text ) ) {
    echo '<div class="swp_custom_prod_text">'.$swp_custom_prod_text.'</div>';
    }
}
}

}

/* +++++++++++++ Функції додавання завантаження файлу до карточки товару +++++++++++++++++++++++ */

if( get_option( 'solass_wp_prod_file', false ) ) {
$login_changes_woo = $login_changes_woo.'<li>'.__( 'Додана до товару форма завантаження файлу', 'solass-wp').'</li>'; 

// Добавление поля загрузки файла в редактировании товара
function solass_wp_custom_product_file_upload_field() { 
    global $post;
    $file_url = get_post_meta( $post->ID, 'swp_custom_prod_file', true );
    $file_name = !empty($file_url) ? basename($file_url) : ''; 
	$prew_url = solass_wp_get_correct_prew_file_url($file_url);
 ?>
   <div class="options_group">
   <p class="form-field prod_file_upload_field">
            <label for="swp_custom_prod_file"><?php _e('Файл для завантаження', 'solass-wp'); ?></label>
            <span>
            <span class="term-image-wrapper prew_admin_load_file" style="width: 40px; height: 40px; display: inline-block;">
            <?php //echo wp_get_attachment_image($file_url, 'thumbnail'); ?>
			<img src="<?php echo $prew_url; ?>" alt="" class="inner_images" style="width: 40px; height: 40px; overflow: hidden; vertical-align: middle;"/>
            </span>
                <input type="button" class="button button-secondary upload_term_image_button" style="vertical-align: middle;" value="<?php _e('Додати файл', 'solass-wp'); ?>" />
                <input type="button" class="button button-secondary remove_term_image_button" style="vertical-align: middle;" value="<?php _e('Видалити файл', 'solass-wp'); ?>" />
				<?php echo '<span class="term_image_name" style="margin: 0 15px; vertical-align: middle;"><a href="'.$file_url.'" target=_blank>'.$file_name.'</a></span>'; ?>
            	<input type="hidden" class="prod_file_upload" name="swp_custom_prod_file" value="<?php echo esc_attr($file_url); ?>" />
            	<input type="hidden" class="start_prod_file_upload" value="<?php echo esc_attr($file_url); ?>" />
            	<input type="hidden" class="start_prod_file_upload_prew" value="<?php echo esc_attr($prew_url); ?>" />
            </span>
    </p>
    </div>
<?php 
}
add_action( 'woocommerce_product_options_general_product_data', 'solass_wp_custom_product_file_upload_field' );

// Зберігаємо URL файлу при збереженні товару
function solass_wp_save_custom_product_file_url( $post_id ) {
    if ( isset( $_POST['swp_custom_prod_file'] ) ) {
        update_post_meta( $post_id, 'swp_custom_prod_file', sanitize_text_field( $_POST['swp_custom_prod_file'] ) );
    }
}
add_action( 'woocommerce_process_product_meta', 'solass_wp_save_custom_product_file_url' );


// Включаємо вивід інформації на сторінці по хуку 
// базовий дизайн у вигляді кнопки для завантаження
if( get_option( 'solass_wp_prod_file_position', '' ) ) {

$solass_wp_prod_file_prioritet = get_option( 'solass_wp_prod_file_prioritet', 0 );
// Виводемо параметр у необхідному місці
add_action( get_option( 'solass_wp_prod_file_position', 'woocommerce_after_single_product_summary' ), 'solass_wp_add_custom_button_after_wishlist', $solass_wp_prod_file_prioritet ); 
function solass_wp_add_custom_button_after_wishlist() { 
global $product;
$product_id = $product->get_id();
//$product_id = get_the_ID();
    global $post;
    $file_url = get_post_meta( $post->ID, 'swp_custom_prod_file', true );
    if ( ! empty( $file_url ) ) {
	// Ваш HTML код для кнопки
    echo '<div class="wd-action-btn load-prod-file-btn">
    	<a class="btn btn-color-primary btn-style-bordered btn-style-round " href="'.esc_url( $file_url ).'" rel="nofollow" target=_blank data-added-text="'.__( 'Завантажити/передивитись', 'solass-wp').'">
		<span class="name-prod-file-btn"></span><span class="dashicons dashicons-download rotated-element--90 margin-ico-left-5"></span>
        </a>
    </div>
	<style>.name-prod-file-btn::before{content:"'.__( 'Брошура про продукт', 'solass-wp').'"}</style>';
    }
}
}

}


// ------------- Управляем выводом информации на странице покупки товара ------------------ //
if( get_option( 'solass_wp_custom_thankyou_message', '' ) ) {
$login_changes_woo = $login_changes_woo.'<li>'.__( 'Виводиться персональна інформація на сторінці успішного замовлення', 'solass-wp').'</li>'; 

// Додавання повідомлення на сторінці підтвердження замовлення
add_action('woocommerce_thankyou', 'swp_custom_thankyou_message_based_on_payment_method', 0, 1);
function swp_custom_thankyou_message_based_on_payment_method($order_id) { 
$solass_wp_custom_thankyou_message = get_option( 'solass_wp_custom_thankyou_message', '' );
    if (!$order_id) return;

    $order = wc_get_order($order_id);
    
    // Получаем метод оплаты
    $payment_method = $order->get_payment_method();

    // В зависимости от метода оплаты выводим разные сообщения
    if ($payment_method == 'cod') {
        // Если выбран "Наложенный платеж"
        echo '<!-- Оплата проводиться накладним платежем -->';
    } elseif ($payment_method == 'cheque') {
        // Если выбран QR-код
		echo swp_echo_content_page($solass_wp_custom_thankyou_message);
        echo '<!-- Оплата проводиться через QR-код -->';
    } elseif ($payment_method == 'bacs') {
        // Если выбран банковский перевод
        echo '<!-- Оплата банківським переказом -->';
    } else {
        // Для всех остальных методов оплаты
        echo '<!-- Інші види платежів -->';
    }
}


// Додавання повідомлення у текст листа про отримання замовлення. Текст розміщується після таблиці товарів
add_action('woocommerce_email_order_details', 'swp_custom_thankyou_message_based_on_payment_method_in_email' , 20, 4);
function swp_custom_thankyou_message_based_on_payment_method_in_email($order, $sent_to_admin, $plain_text, $email) {
$solass_wp_custom_thankyou_message = get_option( 'solass_wp_custom_thankyou_message', '' );
    // Получаем ID заказа
    $order_id = $order->get_id();
    // Получаем метод оплаты
    $payment_method = $order->get_payment_method();

    // В зависимости от метода оплаты выводим разные сообщения
    if ($payment_method == 'cod') {
        // Если выбран "Наложенный платеж"
        echo '<!--Оплата проводиться накладним платежем.-->';
    } elseif ($payment_method == 'cheque') {
        // Если выбран QR-код
        echo '<!--Оплата проводиться через QR-код.-->'; 
        echo swp_echo_content_page($solass_wp_custom_thankyou_message);
        echo '<br><br>'; 

    } elseif ($payment_method == 'bacs') {
        // Если выбран банковский перевод
        echo '<!--Оплата банківським переказом.-->';
    } else {
        // Для всех остальных методов оплаты
        echo '<!--Інші види платежів.-->';
    }
}


}


/* +++++++++++++++++++++++++++++++ Функции работы со страницами аккаунта ++++++++++++++++++++++++++ */

if( get_option( 'woo_acc_menu_arrey', '' ) ) {

$solass_wp_woo_acc_menu_arrey = get_option( 'woo_acc_menu_arrey', '' );
$nazva_tab = ""; $unset_tab = ""; $unset_tab_num = 0; $page_tab = ""; $number_tab = 0; $on_acc_page = ""; $on_acc_page_num = 0;
foreach ( $solass_wp_woo_acc_menu_arrey as $key => $tab ) { 
	$number_tab = $number_tab + 1;
	if(isset($tab['unset'])) { $unset_tab =  $unset_tab.__( $tab['tabs'], 'solass-wp').", "; $unset_tab_num = $unset_tab_num + 1; } 
	if(!$tab['close'] && !isset($tab['unset']) && $tab['tabs'] && $tab['title']) { $on_acc_page = $on_acc_page.$tab['title'].", "; $on_acc_page_num = $on_acc_page_num + 1; }
//unset  //title  //priority  //page 
//description  //additional_information  //reviews  //wd_additional_tab
} 
	if($on_acc_page) { $login_changes_woo = $login_changes_woo.'<li>' . __( 'Додані користувацькі сторінки аккаунта', 'solass-wp') . '</li>'; }
	if($unset_tab) { $login_changes_woo = $login_changes_woo.'<li>' . __( 'Вимкнутий показ деяких сторінок аккаунта', 'solass-wp') . '</li>'; }

// +++++++++++++++++++++ Додаємо користувацькі розділи до аккаунту користувача у WooCommerce
add_filter ( 'woocommerce_account_menu_items', 'solass_wp_acc_link', 25 );
function solass_wp_acc_link( $menu_links ){
$solass_wp_woo_acc_menu_arrey = get_option( 'woo_acc_menu_arrey', '' ); 
//	print_r($solass_wp_woo_acc_menu_arrey);
$new_menu_links = array_slice( $menu_links, 0, count($menu_links) - 1, true ); 
foreach ( $solass_wp_woo_acc_menu_arrey as $key => $tab ) { 
if( empty($tab['pers']) || !empty( get_user_meta(wp_get_current_user()->ID, 'personal_dostup', true) ) ) {
if ( !$tab['close'] && !isset($tab['unset']) && $tab['tabs'] && $tab['title'] ) { 
$tab['tabs'] = esc_attr( solass_wp_translit($tab['tabs']) );
$new_menu_links = $new_menu_links + array( $tab['tabs'] => __( $tab['title'], 'solass-wp') ); 
}
}
}	
$new_menu_links = $new_menu_links + array_slice( $menu_links,  count($menu_links) - 1, NULL, true );

	return $new_menu_links;

}

// ++++++++++ Оголошуємо користувацькі сторінки до аккаунту користувача у WooCommerce згідно якорів
add_action( 'init', 'solass_wp_reg_acc_page', 25 );
function solass_wp_reg_acc_page() {
$solass_wp_woo_acc_menu_arrey = get_option( 'woo_acc_menu_arrey', '' );
foreach ( $solass_wp_woo_acc_menu_arrey as $key => $tab ) { 
if (!$tab['close'] && !isset($tab['unset']) && $tab['tabs'] && $tab['title']) {
$tab['tabs'] = esc_attr( solass_wp_translit($tab['tabs']) );
add_rewrite_endpoint( $tab['tabs'], EP_PAGES );
add_action( 'woocommerce_account_'.$tab['tabs'].'_endpoint', 'solass_wp_add_acc_page', 25 );
}
}	
}
// ++++++++ Функція виводу сторінки аккаунту
function solass_wp_add_acc_page() { 
global $post;
// Проверяем, существует ли объект $post и у него есть ли свойство post_name (слаг)
//if (is_object($post) && property_exists($post, 'post_name')) {

$hook_acc_page = current_action();
$slug_acc_page = str_replace(array("woocommerce_account_", "_endpoint"), "", current_action());
// print_r($slug_acc_page);
//echo "--------------------------------".$tab['tabs']."<br>";

$tab['page'] = null;
$solass_wp_woo_acc_menu_arrey = get_option( 'woo_acc_menu_arrey', '' );
//print_r($solass_wp_woo_acc_menu_arrey);
foreach ( $solass_wp_woo_acc_menu_arrey as $key => $tab ) { 
if( !empty($tab['page'][0]) && $slug_acc_page == $tab['tabs'] ) {  
//$solass_wp_tab_page_info = solass_wp_get_page_by_id( 'page', $tab['page'][0]);
$solass_wp_woo_acc_page_info = (int)$tab['page'][0];
}
$tab['page'] = null;
} 
$my_post_obj = get_post( $solass_wp_woo_acc_page_info );
//echo $my_post_obj->post_content;
$elementor_data = null;
$wpb_data = null; $wpb_data_css = null;
$solass_wp_post_obj = null;
$elementor_data = get_post_meta( $solass_wp_woo_acc_page_info, '_elementor_data', false );
$wpb_data = get_post_meta( $solass_wp_woo_acc_page_info, '_wpb_post_custom', false ); 
$wpb_data_css = get_post_meta( $solass_wp_woo_acc_page_info, '_wpb_shortcodes_custom_css', false ); 
//echo '<br>--------------------<br>'.$elementor_data.'<br>--------------------<br>'.print_r($wpb_data_css).'<br>--------------------<br>'; 
   if ( ! empty( $elementor_data ) ) { 
        $content = \Elementor\Plugin::instance()->frontend->get_builder_content( $solass_wp_woo_acc_page_info, true ); 
        echo $content;
    } elseif ( ! empty( $wpb_data ) ||  ! empty( $wpb_data_css ) ) { 
	   $solass_wp_post_obj = wpautop($my_post_obj->post_content); 
	   if( ! empty( $wpb_data ) ) { $solass_wp_post_obj = $wpb_data; }
	//	echo $solass_wp_post_obj; 
	   echo apply_filters( 'the_content', $solass_wp_post_obj, 25 );
   	} else { 
       $my_post_obj = get_post( $solass_wp_woo_acc_page_info );
	   $solass_wp_post_obj = wpautop($my_post_obj->post_content); 
	//	echo $solass_wp_post_obj; 
      echo apply_filters( 'the_content', $solass_wp_post_objt, 25 );
    }
	
//	echo 'В последний раз вы входили вчера через браузер Safari.';
}

// ++++++++++ Вивод іконок меню аккаунта користувача !!! функція не допрацьована !!!
if (!is_admin()) { 
//add_action('wp_head', 'solass_wp_style_acc_page_icon');
function solass_wp_style_acc_page_icon() {
	echo '<style> /* ---------- '.__( 'Іконки сторінок аккаунта користувача WooCommerce', 'solass-wp').' ----------- */ 
	';
$solass_wp_woo_acc_menu_arrey = get_option( 'woo_acc_menu_arrey', '' );
foreach ( $solass_wp_woo_acc_menu_arrey as $key => $tab ) { 
if (!$tab['close'] && !isset($tab['unset']) && $tab['tabs'] && $tab['title']) {
$tab['tabs'] = esc_attr( solass_wp_translit($tab['tabs']) );
if(!$tab['icon']) { 	echo ' body.woocommerce-account ul li.woocommerce-MyAccount-navigation-link--'.$tab['tabs'].' a:before { content: "\f111"; font-family: dashicons; } '; } 
}
}	
	echo ' </style> ';
}
}

/* Частина коду з параметром позиції позицій
foreach ( $solass_wp_woo_tabs_arrey as $key => $tab ) { 
if(!$tab['close'] && $tab['tabs']) { 
	$tabs[ $tab['tabs'] ][ 'priority' ] = (int)$tab['priority'];
}
}
*/

}
// --------End Функции работы со страницами аккаунта




// +++++++++++ Отключаем вывод блока Related products
if( get_option( 'solass_wp_related_products', '' ) ) {
$login_changes_woo = $login_changes_woo.'<li>'.__( 'Відключений блок "Супутні товари"', 'solass-wp').'</li>'; 
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20); 
remove_action( 'woocommerce_product_after_tabs', 'woocommerce_output_related_products', 20); 
}

// +++++++++++++++ Отключаем для шорткода списка товара в магазине !!! товары отсутствующие на складе !!!
if( get_option( 'solass_wp_products_query', '' ) ) {
$login_changes_woo = $login_changes_woo.'<li>'.__( 'Не виводяться товари відсутні на складі', 'solass-wp').'</li>'; 
add_filter( 'woocommerce_shortcode_products_query', function( $query_args, $atts, $loop_name ){
    if( $loop_name == 'recent_products' ){
        $query_args['meta_query'] = array( array(
            'key'     => '_stock_status',
            'value'   => 'outofstock',
            'compare' => 'NOT LIKE',
        ) );
    }
    return $query_args;
}, 10, 3);
}

// ++++++++++++ Полностью отключить оплату на сайте 
if( get_option( 'solass_wp_products_no_payment', '' ) ) {
$login_changes_woo = $login_changes_woo.'<li>'.__( 'Відключено вибір оплати при оформленні замовлення', 'solass-wp').'</li>'; 
add_filter('woocommerce_cart_needs_payment', '__return_false');
}



//--------------Формируем шорткод атрибутов товара
// вызываем его echo do_shortcode("[product_attributes id='37']");

add_shortcode("product_attributes", "solass_wp_display_product_attributes");
function solass_wp_display_product_attributes( $atts ) {
    // Shortcode attribute (or argument)
    $atts = shortcode_atts( array( 'id'    => '' ), $atts, 'product_attributes' );
    if( ! ( isset($atts['id']) && $atts['id'] > 0 ) ) return;
    $product = wc_get_product($atts['id']);
    ob_start();
    do_action( 'woocommerce_product_additional_information', $product );
    return ob_get_clean();
}
/* А это просто код вывода атрибутов на страницев PHP
<div class="my_atributes">
<?php do_action( 'woocommerce_product_additional_information', $product ); ?>
</div>
*/


/* Функция отключения кнопок сравнения и желаний для базового плагина YITH
// Удаление кнопки сравнения
add_filter( 'woocommerce_after_shop_loop_item', 'remove_compare_button', 1 );
add_filter( 'woocommerce_single_product_summary', 'remove_compare_button', 1 );
function remove_compare_button() {
    if ( class_exists( 'YITH_Woocompare_Frontend' ) ) {
        remove_action( 'woocommerce_after_shop_loop_item', array( YITH_Woocompare_Frontend(), 'add_compare_link' ), 20 );
        remove_action( 'woocommerce_single_product_summary', array( YITH_Woocompare_Frontend(), 'add_compare_link' ), 35 );
    }
}

// Удаление кнопки списка желаний
add_filter( 'woocommerce_after_shop_loop_item', 'remove_wishlist_button', 10 );
add_filter( 'woocommerce_single_product_summary', 'remove_wishlist_button', 10 );
function remove_wishlist_button() {
    if ( class_exists( 'YITH_WCWL' ) ) {
        remove_action( 'woocommerce_after_shop_loop_item', array( YITH_WCWL(), 'add_to_wishlist' ), 15 );
        remove_action( 'woocommerce_single_product_summary', array( YITH_WCWL(), 'add_to_wishlist' ), 15 );
    }
}
*/

	
/*----------- Выводим ярлык скидки для плагина WPC Grouped Product for WooCommerce ------------------ */
if( get_option( 'solass_wp_sale_wpc_grouped', false ) ) {

require_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Смотрим файл плагинов
if ( is_plugin_active('wpc-grouped-product-premium/wpc-grouped-product.php') || is_plugin_active('wpc-grouped-product/wpc-grouped-product.php') ) { 

add_action('woocommerce_before_single_product_summary', 'swp_display_grouped_product_price_difference_single', 10);
function swp_display_grouped_product_price_difference_single() {
    global $product;

    // Проверяем, является ли текущий продукт групповым продуктом типа "grouped" или "woosg"
    if ( $product->is_type('woosg') ) {
        // Получаем метаданные дочерних продуктов
        $woosg_ids = $product->get_meta('woosg_ids');

        // Если есть метаданные
        if (!empty($woosg_ids)) {
            // Переменные для хранения сумм базовой и акционной цен дочерних продуктов
            $total_regular_price = 0;
            $total_sale_price = 0;

            foreach ($woosg_ids as $child_id => $child_data) {
                // Получаем ID и SKU дочернего продукта
                $child_product_id = $child_data['id'];
                $child_product_sku = $child_data['sku'];
                // Получаем объект дочернего продукта
                $child_product = wc_get_product($child_product_id);
                // Получаем базовую цену дочернего продукта
                $child_regular_price = $child_product->get_regular_price();
                $total_regular_price += $child_regular_price;
                // Получаем акционную цену дочернего продукта
                $child_sale_price = $child_product->get_sale_price();
                if ($child_sale_price !== '') {
                    $total_sale_price += $child_sale_price;
                } else {
                    $total_sale_price += $child_regular_price;
                }
            }
            // Разница между суммой базовых и акционных цен дочерних продуктов
            $price_difference = $total_regular_price - $total_sale_price;

			if($total_regular_price && empty( $product->get_regular_price() ) ) { 
				// Обновляем значения в базе данных
    			$product->update_meta_data('_regular_price', $total_regular_price);
    			$product->update_meta_data('_sale_price', $total_sale_price);
    			// Сохраняем изменения
    			$product->save();
			}
            // Если есть скидка, выводим ярлык скидки
            if ( $price_difference > 0 ) {
                // Выводим ярлык скидки
                //echo '<div class="onsale">-' . round(($price_difference / $total_regular_price) * 100) . '%</div>';
				$product->set_regular_price($total_regular_price);
    			$product->set_sale_price($total_sale_price); 
            }
        }
    }
}


add_action('woocommerce_before_shop_loop_item_title', 'swp_display_grouped_product_price_difference', 5);
function swp_display_grouped_product_price_difference() {
    global $product;

    // Проверяем, является ли текущий продукт групповым продуктом типа "grouped" или "woosg"
    if ($product->is_type('woosg') ) { // && empty( $product->get_regular_price() ) && empty( $product->get_sale_price() )  
        // Получаем метаданные дочерних продуктов
        $woosg_ids = $product->get_meta('woosg_ids');
        // Если есть метаданные
        if (!empty($woosg_ids)) {
            // Переменные для хранения сумм базовой и акционной цен дочерних продуктов
            $total_regular_price = 0;
            $total_sale_price = 0;
            foreach ($woosg_ids as $child_id => $child_data) {
                // Получаем ID и SKU дочернего продукта
                $child_product_id = $child_data['id'];
                $child_product_sku = $child_data['sku'];
                // Получаем объект дочернего продукта
                $child_product = wc_get_product($child_product_id);
                // Получаем базовую цену дочернего продукта
                $child_regular_price = $child_product->get_regular_price();
                $total_regular_price += $child_regular_price;
                // Получаем акционную цену дочернего продукта
                $child_sale_price = $child_product->get_sale_price();
                if ($child_sale_price !== '') {
                    $total_sale_price += $child_sale_price;
                } else {
                    $total_sale_price += $child_regular_price;
                }
            }
            // Разница между суммой базовых и акционных цен дочерних продуктов
            $price_difference = $total_regular_price - $total_sale_price;
            // Если есть скидка, выводим ярлык скидки
            if ( $price_difference > 0 ) { //&& $total_regular_price != $price_difference
                // Выводим ярлык скидки
				$product->set_regular_price($total_regular_price);
    			$product->set_sale_price($total_sale_price); 
//                echo '<span class="onsale">-' . round(($price_difference / $total_regular_price) * 100) . '%</span>';
            }
        }
    }
}
}
}
/* AND Functions - WPC Grouped Product for WooCommerce */





} // --------- End проверки подключения плагина WooCommerce



//------------------------------------------------------------------------------------------------------ //
//------------------------------------- !!! УСТАНОВКИ БЕЗОПАСНОСТИ ------------------------------------- //
//------------------------------------------------------------------------------------------------------ //

function solass_wp_set_headers() {

add_action('send_headers', function() {
//if (!headers_sent()) {
    header('X-Content-Type-Options: nosniff'); // Установка этого параметра заставит браузер загружать внешние ресурсы только в том случае, если тип содержимого соответствует ожидаемому. Это предотвращает вредоносный скрытый код в неожиданных файлах.
    header('X-Frame-Options: SAMEORIGIN'); // Заголовок ответа X-Frame-Options указывает, разрешено ли странице отображать страницу в <iframe>, <frame> или <object>. Избегайте атак с использованием clickjacking, просто не позволяя встраивать свой контент на другие веб-сайты.
    header('X-XSS-Protection: 1; mode=block'); // Заголовок X-XSS-Protection может предотвратить некоторые виды атак с использованием межсайтовых сценариев. Настроить очень просто.
//}
});

// Указывает вашему веб-серверу использовать только HTTPS и не разрешать небезопасные HTTP-соединения. 
// Перед внедрением важно убедиться, что у вашего веб-сайта есть сертификат SSL и он работает правильно.
//header('Strict-Transport-Security: max-age=31536000;');

//Это способ указать браузеру, какие функции он может использовать на веб-сайте. С его помощью вы можете явно запретить доступ к камере, микрофону, геолокации и многим другим функциям. https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Feature-Policy
//header("Feature-Policy: accelerometer 'none' ; ambient-light-sensor 'none' ; autoplay 'none' ; camera 'none' ; encrypted-media 'none' ; fullscreen 'none' ; geolocation 'none' ; gyroscope 'none' ; magnetometer 'none' ; microphone 'none' ; midi 'none' ; payment 'none' ; speaker 'none' ; sync-xhr 'none' ; usb 'none' ; notifications 'none' ; vibrate 'none' ; push 'none' ; vr 'none' ");

}
add_action('wp', 'solass_wp_set_headers');
$login_changes_safe = $login_changes_safe.'<li>'.__( 'Увімкнений ряд заходів для запобіганню різного роду атак (clickjacking, межсайтові сценарії та ін.)', 'solass-wp').'</li>';



// +++++++++++++++++++++ Визов сторінки /wp-login.php за новою адресою +++++++++++ //

if ( esc_attr( get_option( 'solass_wp_custom_login', '' )) && get_option( 'solass_wp_login_url', '' ) ) { 

$new_wp_login = get_home_url().'/'.get_option( 'solass_wp_login_url', '' );
$login_changes_safe = $login_changes_safe.'<li>'.__( 'Сторінка входу в систему адміністрування змінена і має тепер URL: ', 'solass-wp')."<a href='".get_home_url()."/".get_option( 'solass_wp_login_url', '' )."' target=_blank>".get_home_url()."/".get_option( 'solass_wp_login_url', '' ).'</a>. '.__( 'Доступ за старими посиланнями заблоковано для автоматичних запитів.', 'solass-wp').'</li>';

// Змінюємо wp-login.php на нову адресу
add_filter('site_url', 'solass_wp_wplogin_filter', 10, 3);
function solass_wp_wplogin_filter( $url, $path, $orig_scheme )
{
$old = array( "/(wp-login\.php)/");
$new = array( get_option( 'solass_wp_login_url', '' ) );
return preg_replace( $old, $new, $url, 1);
}

} elseif ( esc_attr( get_option( 'solass_wp_login_url', '' ) ) ) {
	
// редирект с пользовательского простого URL на /wp-login.php  и с admin на /wp-admin
$new_wp_login = get_home_url().'/'.get_option( 'solass_wp_login_url', '' );
$login_changes_safe = $login_changes_safe.'<li>'.__( 'Посилання для залогінення у адмін систему спрощено на <a href="'.$new_wp_login.'" target=_blank>'.$new_wp_login.'</a>', 'solass-wp').'</li>';

add_action('template_redirect', 'solass_login_redirect');
if (!function_exists('solass_login_redirect')) {
function solass_login_redirect(){
if ( is_admin() ) { return; } // Не редиректим админку
$new_wp_login = get_option( 'solass_wp_login_url', '' );
$loc = '';
	if( strpos($_SERVER['REQUEST_URI'], $new_wp_login)!==false )
		$loc = site_url( '/wp-admin/' );
	elseif( strpos($_SERVER['REQUEST_URI'], $new_wp_login )!==false )
		$loc = site_url( '/wp-login.php' );
	if( isset($loc) ){
		if ( !headers_sent() ) {
			wp_redirect( $loc, 303 ); exit;
		}
		//header( 'Location: '.get_option('site_url').$loc, true, 303 ); exit;
	}
}
}

}


// ++++++++++++++++++++++++ Добавляем Google reCAPTCHA на страницу входа +++++++++++++++++ //
if ( esc_attr( get_option( 'solass_wp_site_key_google', '' ) )) { 
$login_changes_safe = $login_changes_safe.'<li>'.__( 'Увімкнена Google reCAPTCHA 3 для форми входу у адмын-систему.', 'solass-wp').'</li>';

function add_recaptcha_to_login_page() {
	$site_google_key = get_option( 'solass_wp_site_key_google', '' );
    echo '<script src="https://www.google.com/recaptcha/api.js?render='.$site_google_key.'"></script>';
}
add_action('login_enqueue_scripts', 'add_recaptcha_to_login_page');

function solass_wp_add_recaptcha_to_login_page() {
	$site_google_key = get_option( 'solass_wp_site_key_google', '' );
?>
	<input type="hidden" name="g-recaptcha-response" id="g-recaptcha-response">
	<script>
document.addEventListener("DOMContentLoaded", function(event) {
    grecaptcha.ready(function() {
        grecaptcha.execute('<?php echo $site_google_key; ?>', {action: 'login'}).then(function(token) {
            document.getElementById('g-recaptcha-response').value = token;
        });
    });
});
	</script>
<!--    <div class="g-recaptcha" data-sitekey="6LfZ9rYnAAAAAJnwlvNavz4L0Om1y5GX6NdN-tgT"></div>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
	<br>-->
<?php
}
add_action('login_form', 'solass_wp_add_recaptcha_to_login_page');
}

// +++++++++++++++++++++ Встановлений ліміт на кількість не вірних паролів при вході +++++++++++ //
if ( esc_attr( get_option( 'solass_wp_send_login_number', '' ) )) { 
$login_changes_safe = $login_changes_safe.'<li>'.__( 'Встановлений ліміт помилкових спроб входу у адмін-систему - ', 'solass-wp').esc_attr( get_option( 'solass_wp_send_login_number', '' ) ).'</li>';

function solass_wp_limit_login_attempts() {
    $max_attempts = esc_attr( get_option( 'solass_wp_send_login_number', '' ) ); // Максимальное количество попыток входа
    $timeout_minutes = 15; // Время в минутах, в течение которого будет действовать блокировка

    $ip = $_SERVER['REMOTE_ADDR'];
    $attempts = get_transient('login_attempts_' . $ip);
    if (!$attempts) {
        set_transient('login_attempts_' . $ip, 1, $timeout_minutes * 60);
    } else {
        if ($attempts >= $max_attempts) { 
			$html_info_timeout_minutes = '
			<div style="text-align: center;">
			<svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
			 width="80px" height="80px" viewBox="0 0 585.354 585.354" style="enable-background:new 0 0 585.354 585.354;"
			 xml:space="preserve">
			<g>
			<path d="M292.679,0C198.29,0,121.496,76.791,121.496,171.183v97.767c0,1.111-1.371,2.983-2.448,3.341
			c-9.257,3.087-16.775,5.762-23.657,8.415c-8.207,3.164-14.397,12.259-14.397,21.157v224.641c0,8.837,6.15,17.94,14.305,21.172
			c63.097,25.003,129.505,37.678,197.379,37.678s134.282-12.678,197.382-37.681c8.152-3.231,14.299-12.332,14.299-21.169V301.863
			c0-8.898-6.189-17.993-14.4-21.16c-6.885-2.653-14.402-5.328-23.652-8.415c-1.074-0.358-2.445-2.231-2.445-3.342V171.18
			C463.857,76.791,387.068,0,292.679,0z M246.053,370.281c0-25.769,20.875-46.622,46.623-46.622
			c25.746,0,46.621,20.851,46.621,46.622c0,17.075-9.629,31.371-23.311,39.475v77.081c0,12.886-10.426,23.311-23.311,23.311
			c-12.886,0-23.311-10.425-23.311-23.311v-77.081C255.683,401.652,246.053,387.356,246.053,370.281z M405,171.18v84.355
			c-36.834-7.926-74.623-11.94-112.306-11.943c-37.666,0-75.447,4.015-112.338,11.934V171.18c0-61.935,50.386-112.32,112.32-112.32
			C354.609,58.859,405,109.245,405,171.18z"/>
			</g>
			</svg>
			<h3 style="text-transform: uppercase;">'.__( "!!! Багато хибних спроб входу !!!", "solass-wp").'</h3>
			'.__( "Спробуйте знову через ".$timeout_minutes." хв.", "solass-wp").'
			</div>
			';
			wp_die( $html_info_timeout_minutes );
            //wp_die( sprintf( __( 'Багато хибних спроб входу. Спробуйте знову через %s хв.', 'solass-wp'), $timeout_minutes ) );
        }
        set_transient('login_attempts_' . $ip, $attempts + 1, $timeout_minutes * 60);
    }
}
add_action('wp_login_failed', 'solass_wp_limit_login_attempts');

}



// +++++++++++++++++++ Меняем сообщение при неправильном вводе пароля или логина
if ( esc_attr( get_option( 'solass_wp_err_login', '' ) )) { 
  $login_changes = $login_changes.'<li>'.__( 'Повідомлення про помилку входу змінене на вказане вами.', 'solass-wp').'</li>';
} else {
  $login_changes = $login_changes.'<li>'.__( 'Повідомлення помилки входу: "ПОМИЛКА! Невірний Логін та Пароль"', 'solass-wp').'</li>';
}
if (!function_exists('solass_no_wordpress_errors')) {
function solass_no_wordpress_errors(){
if ( esc_attr( get_option( 'solass_wp_err_login', '' ) )) { 
  return esc_attr( get_option( 'solass_wp_err_login', '' ) );
} else {
  return '<strong>ПОМИЛКА!</strong> Невірний Логін та Пароль';
}
}
}
add_filter( 'login_errors', 'solass_no_wordpress_errors' );


// ++++++++++++++++++++++++++   Удаление файлов license.txt и readme.html для защиты
//
if( get_option( 'solass_wp_del_readme', '' ) ) {
$login_changes_safe = $login_changes_safe.'<li>'.__( 'Файли: license.txt та readme.html видалені.', 'solass-wp').'</li>';

if (!function_exists('dell_license_readme')) { 	
	function dell_license_readme() {
if( is_admin() && ! defined('DOING_AJAX') ){
	$license_file = ABSPATH .'/license.txt';
	$readme_file = ABSPATH .'/readme.html';

	if( file_exists($license_file) && current_user_can('manage_options') ){ //
		$deleted = unlink($license_file) && unlink($readme_file);

		if( ! $deleted  ) {
			$GLOBALS['readmedel'] = 'Не вдалось видалити файли: license.txt и readme.html з папки `'. ABSPATH .'`. Видаліть їх вручну!';
		} else {
			$GLOBALS['readmedel'] = 'Файли: license.txt та readme.html видалені з папки `'. ABSPATH .'`.';
		}
		add_action( 'admin_notices', function(){  echo '<div class="error is-dismissible"><p>'. $GLOBALS['readmedel'] .'</p></div>'; } );
	}
}
}
add_action( 'init', 'dell_license_readme' );
}
}

// +++++++++++++++++ Удаление автора из списков новостей
if( get_option( 'solass_wp_del_autor_login', '' ) ) {
add_filter( 'the_author', '__return_empty_string' );
add_filter( 'get_the_author_display_name', '__return_empty_string' );
$login_changes_safe = $login_changes_safe.'<li>'.__( 'Вимкнено показ логіну автора у списках записів', 'solass-wp').'</li>';
}

## ++++++++++++++++++++ Полное Удаление версии WP
## Также нужно удалить файл readme.html в корне сайта
remove_action('wp_head', 'wp_generator'); // из заголовка
add_filter('the_generator', '__return_empty_string'); // из фидов и URL
$login_changes_safe = $login_changes_safe.'<li>'.__( 'Видалено версію WordPress з заголовку, URL, та фідів.', 'solass-wp').'</li>';


## ++++++++++++++++++ Отключим возможность редактировать файлы в админке для тем, плагинов 
if( get_option( 'solass_wp_admin_file_edit', '' ) ) {
define('DISALLOW_FILE_EDIT', true);
$login_changes_safe = $login_changes_safe.'<li>'.__( 'Вимкнено редагування в адмін-панелі тем/шаблонів та плагінів', 'solass-wp').'</li>';
}


## ++++++++++++++++++ Код виводу ролі/класу доступу користувача у тегу BODY 'role-***', а також класу 'logged-in' якщо користувач залогінений

// ----------- Отмечаем в BODY роли пользователя который залогинелся
$login_changes_safe = $login_changes_safe.'<li>'.__( 'Тег &lt;BODY&gt; містить клас доступу користувача', 'solass-wp').'</li>';
add_filter('body_class', function($classes) {
    if (is_user_logged_in()) {
        $user = wp_get_current_user();
        $roles = (array) $user->roles; // Получение всех ролей пользователя // wpseo_editor, wpseo_manager, translator, shop_manager, customer (клиент), subscriber, contributor, author, editor, administrator
        foreach ($roles as $role) {
            $classes[] = 'role-' . $role; // Добавляем класс для каждой роли
        }
        $classes[] = 'logged-in'; // Класс для незалогиненного пользователя
    } else {
        $classes[] = 'not-logged-in'; // Класс для незалогиненного пользователя
    }
    return $classes;
});


## ++++++++++++++++++ Додаємо функцію персонального доступу до розділів чи частин коду

if( get_option( 'solass_wp_pers_dostup', '' ) ) {
$login_changes_safe = $login_changes_safe.'<li>'.__( 'Увімкнене управління доступом до персональної інформації, коду чи сторінок', 'solass-wp').'</li>';

// Добавляем форму персональных разделов в настройках пользователя
add_action('edit_user_profile', 'solass_wp_custom_field_below_role_row');
add_action('show_user_profile', 'solass_wp_custom_field_below_role_row');
function solass_wp_custom_field_below_role_row($user) {
    ?>
<table style="display: none;">
    <tr class="personal_dostup_form">
        <th><?php echo __( 'Персональний доступ', 'solass-wp'); ?></th>
        <td>
            <input type="checkbox" name="personal_dostup" id="personal_dostup" value="1" <?php checked(get_user_meta($user->ID, 'personal_dostup', true), 1); ?>>
            <span class="description"><label for="personal_dostup"><?php echo __( 'Дозволити доступ до персональних розділів', 'solass-wp'); ?></label></span>
        </td>
    </tr>
</table>
    <?php
}
// ЗАПИСЬ параметра в настройках пользователя
add_action('edit_user_profile_update', 'solass_wp_custom_field_save');
add_action('personal_options_update', 'solass_wp_custom_field_save');
function solass_wp_custom_field_save($user_id) {
    if (current_user_can('edit_user', $user_id)) {
        $access_value = isset($_POST['personal_dostup']) ? 1 : 0;
        update_user_meta($user_id, 'personal_dostup', $access_value);
    }
}
// Перемещаем форму после строки роли пользователя
add_action('admin_footer', 'solass_wp_copy_custom_field_below_user_role_row');
function solass_wp_copy_custom_field_below_user_role_row() {
    if (strpos($_SERVER['REQUEST_URI'], 'user-edit.php') !== false || strpos($_SERVER['REQUEST_URI'], 'profile.php') !== false) {
        ?>
        <script>
        document.addEventListener('DOMContentLoaded', function () {
            var roleRow = document.querySelector('tr.user-role-wrap');
            var customRow = document.querySelector('tr.personal_dostup_form'); 
            if (roleRow && customRow) {
                roleRow.after(customRow.cloneNode(true)); // Вставляем копию
                customRow.remove(); // Удаляем оригинал
            }
        });
        </script>
        <?php
    }
}

// Добавляем колонку "Доступ" после колонки с ролью
add_filter('manage_users_columns', 'solass_wp_add_personal_access_column', 10, 1);
function solass_wp_add_personal_access_column($columns) {
    // Копируем все колонки до колонки 'roles'
    $new_columns = [];
    foreach ($columns as $key => $column) {
        $new_columns[$key] = $column;
        // После колонки "roles" добавляем колонку "personal_access"
        if ('role' === $key) {
            $new_columns['personal_access'] = __('Перс. доступ', 'solass-wp'); // Заголовок для новой колонки
        }
    }
    return $new_columns;
}
// Заполняем колонку "Доступ" значением (иконкой)
add_action('manage_users_custom_column', 'solass_wp_display_personal_access_column', 10, 3);
function solass_wp_display_personal_access_column($value, $column_name, $user_id) {
    if ('personal_access' === $column_name) {
        // Получаем значение персонального доступа
        $personal_access = get_user_meta($user_id, 'personal_dostup', true);
        $icon = $personal_access ? '<span class="dashicons dashicons-yes-alt" style="cursor: pointer;"></span>' : '<span class="dashicons dashicons-no-alt" style="cursor: pointer; opacity: 0.6;"></span>'; // Замените на нужную иконку
        $title = $personal_access ? __('Доступ дозволено', 'solass-wp') : __('Доступ заборонено', 'solass-wp');
        $data_status = $personal_access ? 1 : 0;

        // Возвращаем иконку для колонки
        return '<span class="personal-access-icon" data-user-id="' . $user_id . '" title="' . $title . '" data-status="'.$data_status.'">' . $icon . '</span>';
    }
    return $value;
}

// Добавляем JS код для изменения статуса по клику с использованием HTML иконок
add_action('admin_footer', 'solass_wp_add_personal_access_column_js');
function solass_wp_add_personal_access_column_js() {
?>
<style>#personal_access, .personal_access { text-align: center; width: 100px; }</style>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
        // Обработчик клика по иконке
        const icons = document.querySelectorAll('.personal-access-icon');
        icons.forEach(function(icon) {
            icon.addEventListener('click', function() {
                const userId = this.getAttribute('data-user-id');
                const currentStatus = this.getAttribute('data-status') === '1' ? 1 : 0; // Проверка текущего статуса
                
                // Меняем иконку в зависимости от текущего состояния
                const newStatus = currentStatus ? 0 : 1;
                const newIconHTML = newStatus ? 
                    '<span class="dashicons dashicons-yes-alt" style="cursor: pointer;"></span>' : // Иконка доступ разрешен
                    '<span class="dashicons dashicons-no-alt" style="cursor: pointer; opacity: 0.6;"></span>';  // Иконка доступ запрещен
                const newTitle = newStatus ? __('Доступ дозволено', 'solass-wp') : __('Доступ заборонено', 'solass-wp');

                // Отправляем AJAX запрос для обновления
                jQuery.ajax({
                    url: ajaxurl,
                    method: 'POST',
                    data: {
                        action: 'update_personal_access',
                        user_id: userId,
                        personal_access: newStatus,
                    },
                    success: function(response) {
                        if (response.success) {
                            // Обновляем иконку и описание
                            icon.innerHTML = newIconHTML;
                            icon.setAttribute('title', newTitle);
                            icon.setAttribute('data-status', newStatus); // Обновляем статус
                        }
                    }
                });
            });
        });
    });
    </script>
<?php
}
// ЗАПИСЬ, обработка AJAX запроса для обновления персонального доступа
add_action('wp_ajax_update_personal_access', 'update_personal_access');
function update_personal_access() {
    // Проверяем, что у нас есть пользователь и что запрос пришел с админки
    if (!current_user_can('edit_users')) {
        wp_send_json_error();
    }
    // Получаем данные из запроса
    $user_id = intval($_POST['user_id']);
    $personal_access = intval($_POST['personal_access']);
    // Обновляем значение в метаполе
    update_user_meta($user_id, 'personal_dostup', $personal_access);
    // Возвращаем успешный ответ
    wp_send_json_success();
}

}


# +++++++++++++++++++ Прячем страницу архива автора
// это обезопасит сайт от подбора логина 
// зарегистрированного пользователя/aдмина
if( get_option( 'solass_wp_del_autor_page', true ) ){
$login_changes_safe = $login_changes_safe.'<li>'.__( 'Прихована сторінка архіва автора', 'solass-wp').'</li>';
if( ! is_admin() ){
	add_action( 'pre_handle_404', 'solass_wp_remove_author_pages_page' );
	add_filter( 'author_link', 'solass_wp_remove_author_pages_link' );

	// Ставим 404 статус
if (!function_exists('solass_wp_remove_author_pages_page')) { 	
	function solass_wp_remove_author_pages_page( $false ) {
		if ( is_author() ) {
			global $wp_query;
			$wp_query->set_404();
			status_header( 404 );
			nocache_headers();

			return true; // для обрыва хука
		}

		return $false;
	}
}
	// удаляем ссылку
if (!function_exists('solass_wp_remove_author_pages_link')) { 	
	function solass_wp_remove_author_pages_link( $content ) {
		return home_url();
	}
}
}
}

// +++++++++++++  Удаляем опасные методы работы XML-RPC Pingback
if( get_option( 'solass_wp_del_xml_rpc', true ) ){
$login_changes_safe = $login_changes_safe.'<li>'.__( 'Видалено методи роботи XML-RPC Pingback.', 'solass-wp').'</li>';
add_filter('xmlrpc_enabled', '__return_false'); // Отключаем xmlrpc.php (Используется для взлома админки, подбора пароля) 

add_filter( 'xmlrpc_methods', 'solass_wp_sheensay_block_xmlrpc_attacks' );
function solass_wp_sheensay_block_xmlrpc_attacks( $methods ) {
   unset( $methods['pingback.ping'] );
   unset( $methods['pingback.extensions.getPingbacks'] );
   return $methods;
}
 
add_filter( 'wp_headers', 'solass_wp_sheensay_remove_x_pingback_header' );
function solass_wp_sheensay_remove_x_pingback_header( $headers ) {
   unset( $headers['X-Pingback'] );
   return $headers;
}
}



//------------------------------------------------------------------------------------------------------ //
//---------------------------------- !!! ФУНКЦІОНАЛ, ФІШКИ --------------------------------------------- //
//------------------------------------------------------------------------------------------------------ //
if( !isset($login_changes_functions) ) { $login_changes_functions = ""; }
/*
function display_sidebar_id_admin() {
    global $wp_registered_widgets;

    $widget_id = $_GET['widget_id'];
    $sidebar_id = '';

    foreach($wp_registered_widgets as $widget) {
        if($widget['id'] == $widget_id) {
            $sidebar_id = $widget['params'][0]['id'];
            break;
        }
    }

    echo '<p class="sidebar-id">' . __('Sidebar ID:', 'text-domain') . ' <strong>' . $sidebar_id . '</strong></p>';
}

add_action('in_widget_form', 'display_sidebar_id_admin');
*/


// ------------- Подключаем ключ API в плагине ACF и ACF PRO 
// --------------------------- для Google Maps
//
// https://console.cloud.google.com/apis/credentials
/*
// создаем объект карты
var map = new google.maps.Map(document.getElementById('map'), {
  center: {lat: 37.7749, lng: -122.4194},
  zoom: 8
});
// обработчик события изменения размеров контейнера карты
window.addEventListener('resize', function() {
  // вызываем метод trigger для обновления размеров карты
  google.maps.event.trigger(map, 'resize');
});
*/
if( get_option( 'solass_wp_google_map_api', '' ) ) {
$swp_google_api_key = get_option( 'solass_wp_google_map_api', '' );
add_action('wp_enqueue_scripts', function() { 
$swp_google_api_key = get_option( 'solass_wp_google_map_api', '' );
wp_enqueue_script( 'google-map', '//maps.googleapis.com/maps/api/js?sensor=false&language=ru&key='.$swp_google_api_key, array(), null, true );
});
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Підключений ключ API для використання Google map', 'solass-wp').'</li>';

require_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Смотрим файл плагинов
if (is_plugin_active('advanced-custom-fields-pro/acf.php') && get_option( 'solass_wp_google_map_api_acf', true )) { // Проверяем включен ли плагин ACF PRO
function solass_wp_acf_pro_google_map_api() { 
	acf_update_setting('google_api_key', get_option( 'solass_wp_google_map_api', '' )); // Ваш ключ Google API
}
add_action('acf/init', 'solass_wp_acf_pro_google_map_api');
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Підключений ключ Google map API для плагіну ACF PRO', 'solass-wp').'</li>';
} elseif (is_plugin_active('advanced-custom-fields/acf.php') && get_option( 'solass_wp_google_map_api_acf', true )) { // Проверяем включен ли плагин ACF обычный
function solass_wp_acf_google_map_api( $api ){
	$api['key'] = get_option( 'solass_wp_google_map_api', '' ); // Ваш ключ Google API
	return $api;
}
add_filter('acf/fields/google_map/api', 'solass_wp_acf_google_map_api');
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Підключений ключ Google map API для безкоштовного плагіну ACF', 'solass-wp').'</li>';
} 

}


// ++++++++++++++++++ Отключаем srcset и sizes для картинок в WordPress
if( get_option( 'solass_wp_del_srcset', true ) ) {
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Відключені srcset та sizes для картинок у WordPress', 'solass-wp').'</li>';
// Отменяем srcset
// выходим на раннем этапе, этот фильтр лучше чем 'wp_calculate_image_srcset'
add_filter('wp_calculate_image_srcset_meta', '__return_null' );

// Отменяем sizes - это поздний фильтр, но раннего как для srcset пока нет...
add_filter('wp_calculate_image_sizes', '__return_false',  99 );

// Удаляем фильтр, который добавляет srcset ко всем картинкам в тексте записи
remove_filter('the_content', 'wp_make_content_images_responsive' );

// Очищаем атрибуты из wp_get_attachment_image(), если по каким-то причинам они там остались...
add_filter('wp_get_attachment_image_attributes', 'solass_wp_unset_attach_srcset_attr', 99 );
function solass_wp_unset_attach_srcset_attr( $attr ){
	foreach( array('sizes','srcset') as $key )
		if( isset($attr[ $key ]) )    unset($attr[ $key ]);
	return $attr;
}
}

// +++++++++++++++++++++++ Функція відключення зменьшення у Wordpress дуже великих зображень '-scaled'
if( get_option( 'solass_wp_load_big_img', '' ) ) {
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Вимкнено примусове зменьшення великих зображень', 'solass-wp').'</li>';
add_filter( 'big_image_size_threshold', '__return_false' );
}

// +++++++++++++++++++++++ Страхуємося від відключення ACF плагіна та крашей його деяких основних функцій ------------- //
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Виправлення критичних помилок при відключенні плагіну ACF - <strong>увімкнено</strong>.', 'solass-wp').'</li>';
require_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Смотрим файл плагинов 
if ( !file_exists(WP_PLUGIN_DIR . '/advanced-custom-fields/acf.php') && !file_exists(WP_PLUGIN_DIR . '/advanced-custom-fields-pro/acf.php') ) { // Проверяем установлен ли плагин ACF 
//if (!is_plugin_active('advanced-custom-fields/acf.php') && !is_plugin_active('advanced-custom-fields-pro/acf.php') ) { } // Проверяем включен ли плагин ACF 
if ( !function_exists('get_field') ) { function get_field() { echo __( '<!-- ACF-плагін вимкений -->', 'solass-wp'); } }
if ( !function_exists('the_field') ) { function the_field() { echo  __( '<!-- ACF-плагін вимкений -->', 'solass-wp'); } }
}

// ++++++++++++++++++++++++ Выводим URL файла плагина в разделе админки плагинов
//
if( get_option( 'solass_wp_url_plagins', '' ) ) {
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Включений URL плагінів у <a href="plugins.php" target=_blank>списку плагінів</a>', 'solass-wp').'</li>';
if (!function_exists('true_echo_plugin_path')) { 
function true_echo_plugin_path( $plugin_meta, $plugin_file, $plugin_data, $status ) {
	echo '<code>' . $plugin_file . '</code><br />';
	return $plugin_meta;
}
}
add_filter( 'plugin_row_meta', 'true_echo_plugin_path', 10, 4 );
}

// +++++++++++++++++++++++ Функция удаления всех сообщений вызваных по событию 'admin_notices'
if( get_option( 'solass_wp_disable_all_notices', '' ) ) {
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Вимкнено показ всіх адмін-нотатків', 'solass-wp').'</li>';
add_action( 'admin_init', 'solass_wp_disable_all_notices' );
function solass_wp_disable_all_notices() {
  remove_all_actions( 'admin_notices' );
}
}


// ++++++++++++++ Отключаем лишние элементы, которые не планируете использовать
$funk_on_spisok_functions = get_option( 'solass_wp_on_spisok_functions', array() );
if( !empty($funk_on_spisok_functions) || empty($funk_on_spisok_functions['first_save']) ) {
$login_changes_test = "";
	
if( empty($funk_on_spisok_functions['first_save']) ) {
$funk_on_spisok_functions = $solass_wp_spisok_function;
}
	
foreach ($funk_on_spisok_functions as $funk_swp_function => $funk_swp_function_val) { 
if($funk_swp_function_val && $funk_swp_function != 'first_save' ) {
if ( empty($login_changes_test) ) {
$login_changes_test = "ok"; $login_changes_functions = $login_changes_functions.'<li>'.__( 'Відключено ряд функцій що рідко використовуються.', 'solass-wp').'</li>';
}
if($funk_swp_function == "feed_links_extra") { remove_action('wp_head','feed_links_extra', 3); }  // убирает ссылки на rss категорий
elseif($funk_swp_function == "feed_links")	 { remove_action('wp_head','feed_links', 2); } // минус ссылки на основной rss и комментарии
else { remove_action('wp_head',$funk_swp_function); }
}
}
/*
remove_action('wp_head','feed_links_extra', 3); // убирает ссылки на rss категорий
remove_action('wp_head','feed_links', 2); // минус ссылки на основной rss и комментарии
remove_action('wp_head','rsd_link');  // сервис Really Simple Discovery
remove_action('wp_head','wlwmanifest_link'); // Windows Live Writer
remove_action('wp_head','wp_generator');  // скрыть версию wordpress
remove_action('wp_head', 'pagenavi_css'); // Удаляем ненужный css плагина WP-PageNavi
//remove_action('wp_head', 'rel_canonical'); // Удаляем link rel="canonical" Лучше выводить с помощью плагина Yoast SEO или All In One SEO Pack
*/
}

if ( esc_attr( get_option( 'solass_wp_disable_update_info', false ) ) ) {
    
if( is_admin() ){ 
    $login_changes_functions = $login_changes_functions.'<li>'.__( 'Вимкнена "агресивна" перевірка оновлень що прискорює роботу адмін панелі', 'solass-wp').'</li>';
    
	// вимкнути перевірку оновлень при вході в адмін панель...
	remove_action( 'admin_init', '_maybe_update_core' );
	remove_action( 'admin_init', '_maybe_update_plugins' );
	remove_action( 'admin_init', '_maybe_update_themes' );

	// відключити перевірку оновлень при вході на спеціальну сторінку в панелі адмінки...
	remove_action( 'load-plugins.php', 'wp_update_plugins' );
	remove_action( 'load-themes.php', 'wp_update_themes' );

	// залишити примусову перевірку під час входу на сторінку оновлень...
	//remove_action( 'load-update-core.php', 'wp_update_plugins' );
	//remove_action( 'load-update-core.php', 'wp_update_themes' );

	// залиште примусову перевірку під час входу на сторінку «Оновлення/встановлення плагіна» або «Оновлення/встановлення теми» - це не заважає...
	//remove_action( 'load-update.php', 'wp_update_plugins' );
	//remove_action( 'load-update.php', 'wp_update_themes' );

	// не чіпайте подію cron, вона буде використовуватися для перевірки оновлень - тут все добре!
	//remove_action( 'wp_version_check', 'wp_version_check' );
	//remove_action( 'wp_update_plugins', 'wp_update_plugins' );
	//remove_action( 'wp_update_themes', 'wp_update_themes' );

	/**
	 * відключити необхідність оновлення браузера в консолі - ми завжди використовуємо топові браузери!
	 * ця перевірка відбувається раз на тиждень...
	 * @див. https://wp-kama.ru/function/wp_check_browser_version
	 */
	add_filter( 'pre_site_transient_browser_'. md5( $_SERVER['HTTP_USER_AGENT'] ), '__return_empty_array' );
}
}

// ++++++++++++++++++++ Отключаем RSS
if ( esc_attr( get_option( 'solass_wp_rss_off', true ) )) {
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Доступ до RSS-стрічок заблокований', 'solass-wp').'</li>';
function solass_wp_fb_disable_feed() {
wp_die( __('RSS-стрічка недоступна! Запрошуємо на головну сторінку сайту!') );
}
add_action('do_feed', 'solass_wp_fb_disable_feed', 1);
add_action('do_feed_rdf', 'solass_wp_fb_disable_feed', 1);
add_action('do_feed_rss', 'solass_wp_fb_disable_feed', 1);
add_action('do_feed_rss2', 'solass_wp_fb_disable_feed', 1);
add_action('do_feed_atom', 'solass_wp_fb_disable_feed', 1);
}


// ++++++++++++++ Удаляем не нужные линки скриптов и CSS
if (get_option( 'solass_wp_spisok_off_css', '' )) { $login_changes_functions = $login_changes_functions . '<li>' . __( 'Відключені стилі з id вказанних вами у списку: ', 'solass-wp') . implode(", ", get_option( 'solass_wp_spisok_off_css', '' )) . '</li>'; }
if (get_option( 'solass_wp_spisok_off_script', '' )) { $login_changes_functions = $login_changes_functions . '<li>' . __( 'Відключені скрипти з id вказанних вами у списку: ', 'solass-wp') . implode(", ", get_option( 'solass_wp_spisok_off_script', '' )) . '</li>'; }
if ( get_option( 'solass_wp_spisok_off_css', '' ) || get_option( 'solass_wp_spisok_off_script', '' ) ) {
add_action( 'wp_enqueue_scripts', 'solass_wp_remove_style_sctipt', 20 );
function solass_wp_remove_style_sctipt() {
$swp_spisok_style = get_option( 'solass_wp_spisok_off_css', '' );
$swp_spisok_script = get_option( 'solass_wp_spisok_off_script', '' );
if($swp_spisok_style) {
foreach ($swp_spisok_style as $style_id) {
wp_dequeue_style($style_id);
} 
}
if($swp_spisok_script) {
foreach ($swp_spisok_script as $script_id) {
wp_deregister_script($script_id);
} 
}
}
}

// ++++++++++++++++++++++++  Отключаем REST API и wp-json

if( get_option( 'solass_wp_rest_api', '' ) ){
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Вимкнуті REST API та wp-json.', 'solass-wp');
	
// Отключаем сам REST API
add_filter('rest_enabled', '__return_false');

// Отключаем фильтры REST API
remove_action( 'xmlrpc_rsd_apis',            'rest_output_rsd' );
remove_action( 'wp_head',                    'rest_output_link_wp_head', 10, 0 );
remove_action( 'template_redirect',          'rest_output_link_header', 11, 0 );
remove_action( 'auth_cookie_malformed',      'rest_cookie_collect_status' );
remove_action( 'auth_cookie_expired',        'rest_cookie_collect_status' );
remove_action( 'auth_cookie_bad_username',   'rest_cookie_collect_status' );
remove_action( 'auth_cookie_bad_hash',       'rest_cookie_collect_status' );
remove_action( 'auth_cookie_valid',          'rest_cookie_collect_status' );
remove_filter( 'rest_authentication_errors', 'rest_cookie_check_errors', 100 );

require_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Смотрим файл плагинов
if (!is_plugin_active('contact-form-7/wp-contact-form-7.php') ) { // Проверяем включен ли плагин ContactForm7
// Отключаем события REST API ------------ !!! для Contact Form 7 нужно комментировать !!! без них отправка не работает !!! 
remove_action( 'init',          'rest_api_init' );
remove_action( 'rest_api_init', 'rest_api_default_filters', 10, 1 );
remove_action( 'parse_request', 'rest_api_loaded' );
} else { 
$login_changes_functions = $login_changes_functions.' '.__( 'Деякі функції залишились працюючими для потреби плагіну Contact Form 7.', 'solass-wp'); 
}
$login_changes_functions = $login_changes_functions.'</li>';

// Отключаем Embeds связанные с REST API
remove_action( 'rest_api_init', 'wp_oembed_register_route'              );
remove_filter( 'rest_pre_serve_request', '_oembed_rest_pre_serve_request', 10, 4 );

remove_action( 'wp_head', 'wp_oembed_add_discovery_links' );
// если собираетесь выводить вставки из других сайтов на своем, то закомментируйте след. строку.
remove_action( 'wp_head', 'wp_oembed_add_host_js'                 );
}
	

// ++++++++++++++++++++ Вимикаємо сповіщення про оновлення плагінів 
//
//require_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Смотрим файл плагинов
//if (is_plugin_active('advanced-custom-fields/acf.php') || is_plugin_active('advanced-custom-fields-pro/acf.php') ) { // Проверяем включен ли плагин ACF 

if( get_option( 'solass_wp_plugin_not_update', '') ) {
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Вимкнені повідомлення про оновлення плагінів для вказанного списку.', 'solass-wp').'</li>';
if( !function_exists('solass_wp_plugin_not_updates') ) {
function solass_wp_plugin_not_updates($value) {
$array_plugin_not_update = get_option( 'solass_wp_plugin_not_update', '' );
foreach ( $array_plugin_not_update as $plugin_not_update) { 
//echo ' --------- '.$plugin_not_update.'<br>';
    if (isset($value->response[$plugin_not_update])) {
        unset($value->response[$plugin_not_update]); // отключаем уведомление для плагина 
     }
}
	return $value;
}
}
add_filter('site_transient_update_plugins', 'solass_wp_plugin_not_updates');
}

// Отключение оповещений о обновлении частоиспользуемых платых плагинов -------------- //
/*
if (!function_exists('solass_wp_plugin_updates')) { 
function solass_wp_plugin_updates($value) {

    if (isset($value->response['advanced-custom-fields-pro/acf.php'])) {
        unset($value->response['advanced-custom-fields-pro/acf.php']); // отключаем уведомление для плагина ACF
    }
    if (isset($value->response['revslider/revslider.php'])) {
        unset($value->response['revslider/revslider.php']); // отключаем уведомление для плагина Slider Revolution
    }
    if (isset($value->response['js_composer/js_composer.php'])) {
        unset($value->response['js_composer/js_composer.php']); // отключаем уведомление для плагина js_composer
    }
    if (isset($value->response['pofo-addons/pofo-addons.php'])) {
        unset($value->response['pofo-addons/pofo-addons.php']); // отключаем уведомление для плагина pofo-addons
    }
    return $value;
}
}
add_filter('site_transient_update_plugins', 'solass_wp_plugin_updates');
*/

// +++++++++++++++++++++ Отключить уведомления об обновлении неактивных плагинов
if ( esc_attr( get_option( 'solass_wp_notice_off_plugins', '' ) )) {
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Вимкнені сповіщення про оновлення не активних плагінів.', 'solass-wp').'</li>';
function solass_wp_update_active_plugins($value = '') {
    if ((isset($value->response)) && (count($value->response))) {
        $active_plugins = get_option('active_plugins');    
            foreach($value->response as $plugin_idx => $plugin_item) {
                if (!in_array($plugin_idx, $active_plugins))
                    unset($value->response[$plugin_idx]);
            }
        }
        else {
		 /*     !!! Тут нада разобраться, что это за чать кода !!!! она подвешивает систему.     
			  	foreach($value->response as $plugin_idx => $plugin_item) {
                unset($value->response);
            }   */       
        }
    return $value;
    }  
add_filter('site_transient_update_plugins', 'solass_wp_update_active_plugins');    // Hook new
//add_filter('transient_update_plugins', 'update_active_plugins');    // Hook for 2.8.+
//add_filter( 'option_update_plugins', 'update_active_plugins');    // Hook for 2.7.x
}


// ++++++++++++ Отключение сообщений обновления 
// для разных типов (Wordpress, Plugins, Themes) 
// в одном сниппете
function remove_core_updates() {
	global $wp_version;
	return(object) array('last_checked'=> time(),'version_checked'=> $wp_version,);
}
// ++++ отключение сообщений о обнолении системы Wordpress
if(get_option( 'solass_wp_hide_update', '' )) {
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Вимкнені повідомлення про оновлення WordPress.', 'solass-wp').'</li>';
add_filter('pre_site_transient_update_core','remove_core_updates'); 
}
// ++++ отключение сообщений о обнолении плагинов Plugins
if( get_option( 'solass_wp_hide_update_plugins', '') ) {
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Вимкнені повідомлення про оновлення ВСІХ ПЛАГІНІВ.', 'solass-wp').'</li>';
add_filter('pre_site_transient_update_plugins','remove_core_updates');
} 
// ++++ отключение сообщений о обнолении ТЕМ/шаблонов
if( get_option( 'solass_wp_hide_update_themes', '') ) {
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Вимкнені повідомлення про оновлення ВСІХ TEM/шаблонів дизайну.', 'solass-wp').'</li>';
add_filter('pre_site_transient_update_themes','remove_core_updates'); 
}
//if(current_user_can('administrator')) {  }

/*
// Скрывает сообщения WordPress Update (Сложній скрипт для блочного отключения)
// Функция скрытия сообщений о обновлении реализована проще и довольно удачно чуть выше. 
// Код оставлен для ознакомления и возможного использования.

if(get_option( 'solass_wp_hide_update', '' )) {
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Вимкнені повідомлення про оновлення Wordpress.', 'solass-wp').'</li>';
function solass_wp_hide_update() {
remove_action('admin_notices', 'update_nag', 3);
}
//add_action('admin_menu','solass_wp_hide_update');
}

// Скрываем уведомления о новой версии WordPress
if ( get_option( 'solass_wp_hide_update_athe', '' ) ) {
	// Общий счётчик обновлений в админ-баре
	add_action( 'admin_bar_menu', function ( $wp_adminbar ) {
		$wp_adminbar->remove_node( 'updates' );
	}, 999 );

	// "Обновление до X.X" в виджете "На виду" в Консоле
	add_action( 'admin_head-index.php', function () {
		?> <style>	#wp-version-message .button { display: none; } </style>	<?php
	} );

	add_action( 'admin_menu', function () {
		// Общий счётчик обновлений в админ-меню
		remove_submenu_page( 'index.php', 'update-core.php' );
		// "Доступен WordPress X.X" в Консоле - Для Single установки
		remove_action( 'admin_notices', 'update_nag', 3 );
		// "Доступен WordPress X.X" в Консоле - Для Multisite установки
		remove_action( 'network_admin_notices', 'update_nag', 3 );
		// "Скачать версию X.X" в футере
		remove_action( 'update_footer', 'core_update_footer' );

		// Счётчик плагинов для обновления в админ-меню
		$GLOBALS['menu'][65][0] = __( 'Plugins' );
	}, 999 );


}
*/

// +++++++++++++++++ Додаємо форми зображень для таксономій

if( get_option( 'solass_wp_tag_image', '' ) ) { 
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Включено додавання зображення для міток постів', 'solass-wp').'<br>'; 


/*------------------- Додавання фото для позначок (міток) записів ---------------------------*/

// Подключаем скрипты для медиа-загрузчика
function swp_add_media_img_uploader() {
    wp_enqueue_media();
}
add_action('admin_enqueue_scripts', 'swp_add_media_img_uploader');

// Добавляем поле для загрузки изображения в форму редактирования метки
function swp_add_image_upload_field($term) {
    $image_id = get_term_meta($term->term_id, 'term_image', true);
    $image_prew_id = get_term_meta($term->term_id, 'term_image_prew', true);
?>
<?php if ($vipolnyaem_kod) : ?>
    <tr class="form-field">
        <th scope="row" valign="top">
            <label for="term_image"><?php _e('Зображення', 'solass-wp'); ?></label>
        </th>
        <td>
            <input type="hidden" id="term_image" name="term_image" value="<?php echo esc_attr($image_id); ?>" />
            <div id="term-image-wrapper">
                <?php if ($image_id) : ?>
                    <?php echo wp_get_attachment_image($image_id, 'thumbnail'); ?>
                <?php endif; ?>
            </div>
            <p>
                <input type="button" class="button button-secondary" id="upload_term_image_button" value="<?php _e('Додати зображення', 'solass-wp'); ?>" />
                <input type="button" class="button button-secondary" id="remove_term_image_button" value="<?php _e('Видалити зображення', 'solass-wp'); ?>" />
            </p>
        </td>
    </tr> 
<?php endif; ?>
	<tr class="form-field">
		<th scope="row" valign="top">
            <label for="term_image"><?php _e('Зображення', 'solass-wp'); ?></label>
        </th>
	<td>
	<div style="display: flex" class="load_dell_images">
			<input type="hidden" name="term_image_prew" class="regular-text" value="<?php echo $image_prew_id; ?>" />
			<?php if( !empty($image_prew_id) ) { $style_attached_images = "display: block;"; } else { $style_attached_images = "display: none;"; }; ?>
			<div class="attached_images margin-5" style="<?php echo $style_attached_images; ?>">
			<div class="inner_images" style="width: 90px; height: 90px; overflow: hidden;"><img class="prew_load_img" rel="62" src="<?php echo $image_prew_id; ?>">
				
			</div>
			<a href="javascript:;" class="icon-remove-image"><i class="ico_del_image"></i></a>
			</div>
			<a class="add_images_button margin-5" style="width: 90px; height: 90px;" href="javascript:;" use-single="true" title="<?php echo esc_html__( 'Додати зображення', 'solass-wp'); ?>">
			<i class="ico_add_image v1"></i><?php echo esc_html__( 'Додати зображення', 'solass-wp'); ?></a>
	</div>
	</td></tr>
<?php if ($vipolnyaem_kod) : ?>
    <script>
        jQuery(document).ready(function($){
            // Загрузка изображения
            var frame;
            $('#upload_term_image_button').on('click', function(e){
                e.preventDefault();
                if (frame) {
                    frame.open();
                    return;
                }
                frame = wp.media({
                    title: '<?php _e('Select or Upload Image', 'text-domain'); ?>',
                    button: {
                        text: '<?php _e('Use this image', 'text-domain'); ?>'
                    },
                    multiple: false
                });
                frame.on('select', function() {
                    var attachment = frame.state().get('selection').first().toJSON();
                    $('#term_image').val(attachment.id);
                    $('#term-image-wrapper').html('<img src="'+attachment.sizes.thumbnail.url+'" alt="" style="max-width:100%;"/>');
                });
                frame.open();
            });

            // Удаление изображения
            $('#remove_term_image_button').on('click', function(e){
                e.preventDefault();
                $('#term_image').val('');
                $('#term-image-wrapper').html('');
            });
        });
    </script>
<?php endif; ?>
<?php
}
add_action('edit_tag_form_fields', 'swp_add_image_upload_field'); // Для редактирования меток
add_action('add_tag_form_fields', 'swp_add_image_upload_field'); // Для добавления меток

// Сохраняем данные при сохранении метки
function swp_save_term_image($term_id) {
/*    
	 if (isset($_POST['term_image'])) {
        update_term_meta($term_id, 'term_image', absint($_POST['term_image']));
    } 
*/
    if (isset($_POST['term_image_prew'])) {
        update_term_meta($term_id, 'term_image_prew', esc_url($_POST['term_image_prew']));
    }
}
add_action('edited_term', 'swp_save_term_image'); // Для сохранения изменений метки
add_action('create_term', 'swp_save_term_image'); // Для создания новой метки

/* ----------- Коды вывода изображений нужно ставить в код сайта ----------------- */
// --- ВАР.1 Спрощений код
/* 
$term_id = get_queried_object()->term_id; // Получаем текущий термин
$image_id = get_term_meta($term_id, 'term_image', true);
if ($image_id) {
    echo wp_get_attachment_image($image_id, 'full');
}
*/
// --- ВАР.2 Функція виводу зображення 
/* Использование кода в шаблоне
$term_id = get_queried_object()->term_id; // Получаем ID текущей метки
swp_display_term_image($term_id);
*/
function swp_display_term_image($term_id) {
    // Получаем ID изображения из метаданных термина
    $image_id = get_term_meta($term_id, 'term_image', true);
    // Если изображение существует, выводим его
    if ($image_id) {
        // Выводим изображение с использованием wp_get_attachment_image()
        echo wp_get_attachment_image($image_id, 'full'); // Используйте нужный размер изображения, например, 'thumbnail', 'medium', 'large', или 'full'
    } else {
        echo '<!-- No image available for this term -->';
    }
}
function swp_display_term_image_url($term_id) {
    // Получаем ID изображения из метаданных термина
    $image_id = get_term_meta($term_id, 'term_image_prew', true);
    // Если изображение существует, выводим его URL
    if ($image_id) { echo $image_id; } else { echo ''; }
}


// -------- Функция для добавления изображения к меткам на выводе ------------- //
function swp_add_image_to_term_link($term_links, $taxonomy) {
    foreach ($term_links as $key => $term_link) {
        // Получаем объект термина по ссылке
        $term_id = url_to_postid($term_link);
        if (!$term_id) {
            preg_match('/term-(\d+)/', $term_link, $matches);
            $term_id = isset($matches[1]) ? $matches[1] : 0;
        }
        if ($term_id) {
            // Получаем ID изображения из метаданных термина
            $image_id = get_term_meta($term_id, 'term_image', true);
            if ($image_id) {
                // Получаем HTML изображения 
                // Используйте нужный размер изображения, например, 'thumbnail', 'medium', 'large', или 'full'
                $image_html = wp_get_attachment_image($image_id, 'full', false, array('style' => 'display:inline-block; vertical-align:middle; margin-right:5px;'));
                // Добавляем изображение перед названием метки
                $term_links[$key] = str_replace('">', '">' . $image_html, $term_link);
            }
        }
    }
    return $term_links;
}
// ---------------- Эти функции необходимо дорабатывать
// Подключаем функцию к фильтру для меток
//add_filter('term_links-post_tag', 'swp_add_image_to_term_link', 10, 2); // Для меток (post_tag)

// Пример для других таксономий
// add_filter('term_links-category', 'swp_add_image_to_term_link', 10, 2); // Для категорий
//add_filter('term_links-your_taxonomy', 'swp_add_image_to_term_link', 10, 2); // Для пользовательских таксономий



}



// +++++++++++++++++ Отключаем скрипты ContactForm7 для страниц где нет форм 

require_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Смотрим файл плагинов
if (is_plugin_active('contact-form-7/wp-contact-form-7.php') ) { // Проверяем включен ли плагин ContactForm7

if( get_option( 'solass_wp_disable_cf7', '' ) ) {
$off_disable_cf7 = get_option( 'solass_wp_off_disable_cf7', '' );
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Відключені скрипти плагіну ContactForm7 для сторінок без поштових форм.', 'solass-wp').'<br>'; 
if ($off_disable_cf7) { $login_changes_functions = $login_changes_functions.__( 'Скрипти обов`язково виводяться на сторінках з ярликами: ', 'solass-wp').implode(", ", $off_disable_cf7);  }
$login_changes_functions = $login_changes_functions.'</li>'; 

function solass_wp_disable_cf7_assets() {
  global $post; 
$post_id = get_the_ID();
if (empty( $post ) && $post_id) {
$post = get_post($post_id);
}

  if (is_page(get_option( 'solass_wp_off_disable_cf7', '' )) && get_option( 'solass_wp_off_disable_cf7', '' )) { return; }
	//	echo "------------------------------".$post_id."<br>".$post->post_content."<br>";
  if ( function_exists( 'is_product' ) && is_product() ) { // echo "is_productis_productis_productis_productis_product";
    $product = wc_get_product();
    if ( has_shortcode( $product->get_short_description(), 'contact-form-7' ) || has_shortcode( $product->get_description(), 'contact-form-7' ) || strstr($product->get_description(), 'wpcf7') ) {
      return;
    }
  }
  if ( class_exists( 'Elementor\Plugin' ) && \Elementor\Plugin::$instance->db->is_built_with_elementor( get_the_ID() ) ) { // echo "ElementorElementorElementorElementorElementor";
    $elementor_data = get_post_meta( get_the_ID(), '_elementor_data', true );
    if ( strpos( $elementor_data, 'wpcf7' ) !== false ) {
      return;
    }
  	if ( !empty( $post ) && ( has_shortcode($post->post_content, 'contact-form-7') || strstr($post->post_content, 'wpcf7')  ) ) { // echo "ElementorpostpostpostElementorpostpost";
   	 return;
  	}
  }
  if ( !empty( $post ) && ( has_shortcode($post->post_content, 'contact-form-7') || strstr($post->post_content, 'wpcf7')  ) ) { //  echo "postpostpostpostpostpostpostpostpost";
    return;
  }
  wp_deregister_style( 'contact-form-7' );
  wp_deregister_script( 'contact-form-7' );
}
add_action( 'wp_enqueue_scripts', 'solass_wp_disable_cf7_assets' ); 

}

}


//---------------- Создание страниц опций для плагина ACF
//                   нужно будет занятся этой функцией
if( get_option( 'solass_wp_acf_options', '' ) ) {
//require_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Смотрим файл плагинов
//if (is_plugin_active('advanced-custom-fields/acf.php') || is_plugin_active('advanced-custom-fields-pro/acf.php') ) { // Проверяем включен ли плагин ACF 
if( function_exists('acf_add_options_page') ) {

	acf_add_options_page(array(
		'page_title' 	=> __( 'Налаштування ACF', 'solass-wp'),
		'menu_title'	=> __( 'Налаштування ACF', 'solass-wp'),
		'menu_slug' 	=> 'acf_pers_settings',
		'capability'	=> 'edit_posts',
        'post_id'		=> 'general_settings',
//  		'position'      => 5,
	));

/*	
	acf_add_options_sub_page(array(
		'page_title' 	=> "__( 'Заголовок сторінки', 'solass-wp')",
		'menu_title'	=> "__( 'Меню сторінки', 'solass-wp')",
		'parent_slug'	=> 'sett-ucastnik',
	));
*/
}	
//}
}


// ++++++++++++++++++++++++++ ПОИСК-ФИЛЬТР элементов таксономии по названиям в метабоксе админки
// Фильтр элементов таксономии для метабокса таксономий в админке.
// Позволяет удобно фильтровать (искать) элементы таксономии по назанию, когда их очень много
if( get_option( 'solass_wp_on_post_category_filter', true ) ) {
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Включений швидкий пошук по категоріям на сторінці редагування постів.', 'solass-wp'); 
add_action( 'admin_footer', 'solass_wp_admin_term_filter', 99 ); //admin_print_scripts
function solass_wp_admin_term_filter() {
	$screen = get_current_screen();
	if( 'post' !== $screen->base ) return; // только для страницы редактирования любой записи
	?>
	<script>
	jQuery(document).ready(function($){
		var $categoryDivs = $('.categorydiv');
		$categoryDivs.prepend('<input type="search" class="fc-search-field" placeholder="<?php echo __( 'фільтр...', 'solass-wp'); ?>" style="width:100%" />');
		$categoryDivs.on('keyup search', '.fc-search-field', function (event) {
			var searchTerm = event.target.value,
				$listItems = $(this).parent().find('.categorychecklist li');
			if( $.trim(searchTerm) ){
				$listItems.hide().filter(function () {
					return $(this).text().toLowerCase().indexOf(searchTerm.toLowerCase()) !== -1;
				}).show();
			}
			else {
				$listItems.show();
			}
		});
	});
	</script>
	<?php
}
}

// -------------- Произвольный виджет в консоли в админ-панели (на главной странице админки какое-то сообщение)
add_action('wp_dashboard_setup', 'my_custom_dashboard_widgets');
function my_custom_dashboard_widgets() {
	wp_add_dashboard_widget('custom_help_widget', 'Заметки темы', 'custom_dashboard_help');
}

function custom_dashboard_help() {
	echo '<p>Добро пожаловать в тему "Моя тема"! Тут некоторые заметки по теме.';
}


// ---------------- Добавляет в профиль поля: AIM, Yahoo IM, Jabber / Google Talk
//add_filter('user_contactmethods', 'add_contactmethod');
function add_contactmethod( $contactmethods ) {
	$contactmethods['twitter'] = 'Twitter';
	$contactmethods['facebook'] = 'Facebook';
	$contactmethods['this_var'] = 'You value';
	return $contactmethods;
}


// +++++++++++++++++ Создание промежуточных размеров миниатюр

if( get_option( 'solass_custom_prew_size', true ) ) {

function solass_wp_add_image_sizes() {
$prew_size_arrey = get_option( 'solass_custom_prew_size', '' ); 
if($prew_size_arrey){
foreach ( $prew_size_arrey as $key => $tab ) { 
	$tab['id'] = str_replace(" ", "_", $tab['id']);
	$tab['id'] = esc_attr( solass_wp_translit($tab['id']) ); 
	if (!empty($tab['cute'])) { $cute = true; } else { $cute = false; }
	if(isset($tab['close']) && $tab['id'] && empty($tab['hide'])) {
    add_image_size( $tab['id'], $tab['width'], $tab['height'], $cute ); // "custom-size" - название размера изображения, Ш350 и В'auto'. 'true' или по умолчанию - обрезает изображение 
	}
}
}
}
add_action( 'after_setup_theme', 'solass_wp_add_image_sizes', 999 ); //init

// Додати в медіапанелі новий розмір до спадного меню
function solass_wp_registr_image_sizes($sizes) { 
$addsizes = array();
$prew_size_arrey = get_option( 'solass_custom_prew_size', '' ); 
if($prew_size_arrey){
foreach ( $prew_size_arrey as $key => $tab ) { 
	$tab['id'] = str_replace(" ", "_", $tab['id']);
	$tab['id'] = esc_attr( solass_wp_translit($tab['id']) ); 
	if(!$tab['close'] && $tab['id'] && empty($tab['hide']) && $tab['name']) {
		$addsizes[$tab['id']] = __($tab['name'], 'solass_wp');
	}
}
}
/*	        $addsizes = array(
                $tab['id'] => __($tab['name'], 'solass_wp'),
                "solass_wp_shem" => __("W:350xH:auto", 'solass_wp'), 
                ); */
        $newsizes = array_merge($sizes, $addsizes);
        return $newsizes;
}
add_filter('image_size_names_choose', 'solass_wp_registr_image_sizes', 999);


$login_changes_functions = $login_changes_functions.'<li>'.__( 'Додані користувацькі розміри мініатюр.', 'solass-wp'); 
}

// Это устанавливает значение изображения по умолчанию при выборе из библиотеки
//set_post_thumbnail_size( 800, 400, true ); // Здесь "custom-size" - это название вашего пользовательского размера изображения.


// +++++++++++++++++++++++ включение возможности отображение шорткодов в виджетах
if( ! is_admin() ){ add_filter('widget_text', 'do_shortcode', 11); }


// +++++++++++++++++++++++++ Повідомлення про технічні роботи
if ( esc_attr( get_option( 'solass_wp_edit_themes', '' ) )) {
$login_changes_themes = __( 'На сайті включене повідомлення про проведення технічних робіт. По закінченню робіт обов`язково виключіть повідомлення натиснув на кнопку.', 'solass-wp');
	
function solass_wp_edit_themes(){
    if(!current_user_can('edit_themes') || !is_user_logged_in()){ 
		
	$html_edit_themes = '
			<div style="text-align: center;">
<svg height="80px" viewBox="0 0 448 448" width="80px" xmlns="http://www.w3.org/2000/svg"><path d="m278.160156 162c-1.304687-5.054688-3.3125-9.902344-5.960937-14.398438-1.855469-3.144531-1.351563-7.148437 1.234375-9.730468l12.796875-12.800782-11.308594-11.308593-12.800781 12.796875c-2.582032 2.585937-6.585938 3.089844-9.730469 1.234375-4.496094-2.648438-9.34375-4.65625-14.398437-5.960938-3.53125-.910156-6-4.097656-6-7.742187v-18.089844h-15.992188v18.097656c0 3.644532-2.46875 6.832032-6 7.742188-5.054688 1.304687-9.902344 3.3125-14.398438 5.960937-3.144531 1.855469-7.148437 1.351563-9.730468-1.234375l-12.800782-12.796875-11.308593 11.308594 12.796875 12.800781c2.585937 2.582032 3.089844 6.585938 1.234375 9.730469-2.648438 4.496094-4.65625 9.34375-5.960938 14.398437-.910156 3.53125-4.097656 6-7.742187 6h-18.089844v16h18.097656c3.644532 0 6.832032 2.46875 7.742188 6 1.304687 5.054688 3.3125 9.902344 5.960937 14.398438 1.855469 3.144531 1.351563 7.148438-1.234375 9.730469l-12.796875 12.800781 11.308594 11.308594 12.800781-12.796875c2.582032-2.582031 6.585938-3.089844 9.730469-1.234375 4.496094 2.648437 9.34375 4.65625 14.398437 5.960937 3.53125.910157 6 4.097657 6 7.746094v18.078125h16v-18.097656c0-3.644532 2.46875-6.832032 6-7.742188 5.054688-1.304687 9.902344-3.3125 14.398438-5.960937 3.144531-1.855469 7.148438-1.351563 9.730469 1.234375l12.800781 12.796875 11.308594-11.308594-12.796875-12.800781c-2.582031-2.582032-3.089844-6.585938-1.234375-9.730469 2.648437-4.496094 4.65625-9.34375 5.960937-14.398437.910157-3.53125 4.097657-6 7.746094-6h18.078125v-15.992188h-18.097656c-3.644532 0-6.832032-2.46875-7.742188-6zm-54.160156 54c-22.089844 0-40-17.910156-40-40s17.910156-40 40-40 40 17.910156 40 40c-.027344 22.082031-17.917969 39.972656-40 40zm0 0"/><path d="m128 440c0 4.417969 3.582031 8 8 8h176c4.417969 0 8-3.582031 8-8s-3.582031-8-8-8h-176c-4.417969 0-8 3.582031-8 8zm0 0"/><path d="m175.0625 368-6 48h109.875l-6-48zm0 0"/><path d="m448 304h-448v24c0 13.253906 10.746094 24 24 24h400c13.253906 0 24-10.746094 24-24zm-32 32h-16v-16h16zm0 0"/><path d="m248 176c0 13.253906-10.746094 24-24 24s-24-10.746094-24-24 10.746094-24 24-24 24 10.746094 24 24zm0 0"/><path d="m448 64h-448v224h448zm-376 192h-40v-16h40zm0-32h-40v-16h40zm0-80h-40v-16h40zm0-32h-40v-16h40zm48 128h-32v-16h32zm-19.3125-128h-12.6875v-16h16c2.121094 0 4.15625.84375 5.65625 2.34375l24 24-11.3125 11.3125zm219.3125 72c0 8.835938-7.164062 16-16 16h-12.175781c-.847657 2.375-1.8125 4.707031-2.894531 6.984375l8.605468 8.617187c6.246094 6.246094 6.246094 16.375 0 22.621094l-11.3125 11.3125c-6.246094 6.246094-16.375 6.246094-22.621094 0l-8.617187-8.605468c-2.277344 1.082031-4.609375 2.046874-6.984375 2.894531v12.175781c0 8.835938-7.164062 16-16 16h-16c-8.835938 0-16-7.164062-16-16v-12.175781c-2.375-.847657-4.707031-1.8125-6.984375-2.894531l-8.617187 8.605468c-6.246094 6.246094-16.375 6.246094-22.621094 0l-11.3125-11.3125c-6.246094-6.246094-6.246094-16.375 0-22.621094l8.605468-8.617187c-1.082031-2.277344-2.046874-4.609375-2.894531-6.984375h-12.175781c-8.835938 0-16-7.164062-16-16v-16c0-8.835938 7.164062-16 16-16h12.175781c.847657-2.375 1.8125-4.707031 2.894531-6.984375l-8.605468-8.617187c-6.246094-6.246094-6.246094-16.375 0-22.621094l11.3125-11.3125c6.246094-6.246094 16.375-6.246094 22.621094 0l8.617187 8.605468c2.277344-1.082031 4.609375-2.046874 6.984375-2.894531v-12.175781c0-8.835938 7.164062-16 16-16h16c8.835938 0 16 7.164062 16 16v12.175781c2.375.847657 4.707031 1.8125 6.984375 2.894531l8.617187-8.605468c6.246094-6.246094 16.375-6.246094 22.621094 0l11.3125 11.3125c6.246094 6.246094 6.246094 16.375 0 22.621094l-8.605468 8.617187c1.082031 2.277344 2.046874 4.609375 2.894531 6.984375h12.175781c8.835938 0 16 7.164062 16 16zm40 56h-32v-16h32zm0-128h-12.6875l-21.65625 21.65625-11.3125-11.3125 24-24c1.5-1.5 3.535156-2.34375 5.65625-2.34375h16zm56 144h-40v-16h40zm0-32h-40v-16h40zm0-80h-40v-16h40zm0-32h-40v-16h40zm0 0"/><path d="m448 24c0-13.253906-10.746094-24-24-24h-400c-13.253906 0-24 10.746094-24 24v24h448zm-400 8h-16v-16h16zm32 0h-16v-16h16zm32 0h-16v-16h16zm0 0"/></svg>
			<h3 style="text-transform: uppercase; margin-bottom: 0px">'.__( "Просимо вибачення!", "solass-wp").'</h3>
			<h2 style="text-transform: uppercase; margin-top: 0px">'.__( "Ведуться технічні роботи.", "solass-wp").'</h2>
			'.__( "Прохання завітати на сайт трохи згодом", "solass-wp").'
			</div>
			';
		
        wp_die($html_edit_themes, __( 'Ведуться технічні роботи', "solass-wp"), array('response' => '503'));
    }
}
add_action('get_header', 'solass_wp_edit_themes');
} else {
$login_changes_themes = __( 'Повідомлення про технічні роботи вимкнене. У випадку проведення технічних робіт натисніть на кнопку.', 'solass-wp');
}
/*
function my_widget_id_callback( $widget, $return, $instance ) {
    if ( !$return ) {
        printf( '<p>ID: %s</p>', $widget->id );
    }
    return $return;
}
function my_widget_id_form_callback( $widget, $return, $instance ) {
    add_filter( 'widget_form_callback', 'my_widget_id_callback', 10, 3 );
    return $return;
}
add_filter( 'widget_form_callback', 'my_widget_id_form_callback', 10, 3 );
*/

add_action( 'widget_controls', 'solass_wp_widget_controls', 10, 1 );
function solass_wp_widget_controls( $widget ) {
    // Получаем ID текущего виджета
    $widget_id = $widget->id;
    // Выводим ID виджета
    echo '<span style="float: right;">Widget ID: ' . $widget_id . '</span>';
}



// +++++++++++++++++ Включаем классические виджеты в WordPress
if ( esc_attr( get_option( 'solass_wp_old_widgets', '' ) )) { 
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Включений класичний показ віджетів', 'solass-wp').'</li>';
add_filter( 'gutenberg_use_widgets_block_editor', '__return_false' );
add_filter( 'use_widgets_block_editor', '__return_false' );
}


// ++++++++++ Добавление PHP-кода в текстовом (редактор) виджете WordPress
if ( get_option( 'solass_wp_php_in_widgets', '' ) ) {
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Додана можливість написання PHP коду у текстовому віджеті', 'solass-wp').'</li>';
function solass_wp_php_in_widgets($widget_content) {
if (strpos($widget_content, '<?') !== false || strpos($widget_content, '&lt;?') !== false) {
    $widget_content = preg_replace('/(<\?|\&lt;\?|\<php\?|\&lt;php\?)(.*?)(\?\&gt;|\?\>)/s', '<?php ${2} ?>', $widget_content);
/*	$function = create_function('', $widget_content);
    $widget_content = $function(); */
    ob_start();
    eval('?' . '>' . $widget_content);
    $widget_content = ob_get_contents();
    ob_end_clean();
}
return $widget_content;
}
add_filter('widget_text', 'solass_wp_php_in_widgets', 99);
}


// +++++++ Вивід функцій Хуків внизу сторінки ++++++++ // 
if ( esc_attr( get_option( 'solass_wp_hooks_list', '' ) )) { 
function solass_wp_hooks_list() { 
echo "<div class='hooks_list_a'><div class='visible_hooks'>".__( 'Переглянути список хуків сторінки', 'solass-wp' )."</div></div>"; 
echo "<div class='hooks_list main' style='display: none;'>";
echo '
<div class="hook_search_barr">
<form id="hook_search_Form" class="wpcf7">
<span><input type="text" id="hook_search_anchorInput" class="wpcf7-form-control" placeholder="Hook name"><input type="hidden" id="hook_search_old_anchor" value=""><span>
<button class="wpcf7-submit btn btn-primary" type="submit" style="margin-left: 20px;">'.__( "Search" ).'</button>
<span class="hooks_list_a close_hook_search dashicons dashicons-no-alt"></span><!--<span class="hooks_list_a close_hook_search">Х</span>-->
</form>
</div>';
//echo solass_wp_display_hook_functions('woocommerce_before_shop_loop'); // Выводим вверху список функций вызываемых определенным хуком
echo '<pre class="pre_style"><h5>'.__( 'Список всіх хуків сторінки', 'solass-wp' ).'</h5></pre>';
echo solass_wp_get_hooks_list(); // Выводим список всех хуков и их функций
echo "</div>
<style> 
pre { margin:0px; }
.hook_search_barr { 
position: fixed;
bottom: 0;
z-index: 1042;
/*animation: fixedTop 0.4s;*/
animation: fixedBottom 0.4s;
border-bottom: none;
border-top: 1px solid rgba(0,0,0,0.12);
box-shadow: 0 0 6px 1px rgba(0,0,0,0.1);
width: 100%;
}
.hook_search_barr {
transition: opacity 0.5s ease 0s;
/*margin-top: 32px;
z-index: 1039;*/
margin-left: 0px;
margin-right: 0px;
}
.close_hook_search {
background-color: rgba(0,0,0,0.3);
width: 35px;
height: 35px;
text-align: center;
/*padding: 3px 10px;*/
margin-left: 20px;
border-radius: 50%;
font-size: 24px;
vertical-align: middle; 
color: #fff;
cursor: pointer;
/*line-height: 35px; */
}
.close_hook_search::before {
vertical-align: middle;
}
#hook_search_Form #hook_search_anchorInput {
border: 1px solid rgba(0,0,0,0.15);
max-width: 300px;
width: 100%;
padding: 1em 2em;
background: #fff;
min-height: 55px; 
}
#hook_search_Form .btn {
min-height: 55px; 
}
</style>"; 
echo '
<script>
var tag2 = document.querySelector(".pre_style");
var tag1 = document.querySelector(".hook_search_barr");
var computedStyle = getComputedStyle(tag2); // Получение вычисленных стилей tag2
// Применение стилей tag2 к tag1
tag1.style.padding = computedStyle.padding;
tag1.style.background = computedStyle.background;

/* Шукає у списку Хук за його повною назвою */
document.getElementById("hook_search_Form").addEventListener("submit", function(event) {
  event.preventDefault(); // Предотвращаем отправку формы 
  var old_anchor = document.getElementById("hook_search_old_anchor").value; // Получаем старое значение хука
  var anchor = document.getElementById("hook_search_anchorInput").value; // Получаем значение из поля ввода
  if (anchor) {
	if(old_anchor) { 
	document.getElementById("hook_search_old_anchor").value = anchor;
	document.getElementById(old_anchor).style.background = "transparent"; 
	}
    var target = document.getElementById(anchor); // Находим элемент с указанным якорем
    if (target) {
	document.getElementById("hook_search_old_anchor").value = anchor;
	var windowHeight = window.innerHeight;
	target.style.background = "rgb(196, 255, 156)";
      window.scrollTo({
        top: target.offsetTop - windowHeight + 200,
        behavior: "smooth" // Плавная прокрутка
      });
    }
  }
});
</script>
';
}
add_action( 'wp_footer', 'solass_wp_hooks_list', 1 ); //get_header
}

//+++++++++++++++++++++ Отключаем панель инструментов во внешней части сайта
if ( esc_attr( get_option( 'on_admin_barr', '' ) )) {
add_action('after_setup_theme', function(){
	if ( ! is_admin() ) show_admin_bar( false );
});
// Отключаем админ бар во фронте
//add_filter( 'show_admin_bar', '__return_false' );
// Отключаем админ бар в админ панели
//remove_action( 'in_admin_header', 'wp_admin_bar_render', 0 );
	
$login_changes = $login_changes.'<li>'.__( 'Відключено показ адмін-панелі на сторінках сайту', 'solass-wp').'</li>';
}


// +++++++++++++++++++++++ Добавление произвольного меню в панель инструментов

if ( esc_attr( get_option( 'on_toolbar_menu', '' ) )) {

$menu_locations = get_nav_menu_locations(); 
$my_menu_object = wp_get_nav_menu_object( $menu_locations['toolbar'] );
if ( $my_menu_object ) { $menu_edit_url = admin_url( 'nav-menus.php?action=edit&menu=' . $my_menu_object->term_id ); } else { $menu_edit_url = admin_url( 'nav-menus.php'); }

$login_changes = $login_changes.'<li>'.__( 'Меню для панелі інструментів додане і включене для показу. ', 'solass-wp').'<a href="'.$menu_edit_url.'" target=_blank><strong>'.__( 'Сформуйте меню', 'solass-wp').'</strong> →</a></li>';

add_action( 'after_setup_theme', function(){
	register_nav_menu( 'toolbar', esc_attr( get_option( 'on_toolbar_menu', '' ) ) );
});

add_action( 'admin_bar_menu', 'solass_add_toolbar_menu', 999 );
function solass_add_toolbar_menu( $toolbar ){
	$locations = get_nav_menu_locations();
	$id_main_menu = "solass-toolbar-menu";
	$first_href = "#";

	if( ! isset($locations['toolbar']) ) return;

	$items = wp_get_nav_menu_items( $locations['toolbar'] );

	if( ! $items || !$id_main_menu ) return;
	
	foreach( $items as $item ){
		if ($first_href == "#" && $item->url) { $first_href = $item->url; }
		$args = array(
			'parent' => $item->menu_item_parent ? 'id-' . $item->menu_item_parent : 'id-' . $id_main_menu,//false, 
			'id'     => 'id-'. $item->ID,
			'title'  => $item->title,
			'href'   => $item->url,
			'meta'   => array(
				// 'html' - The html used for the node.
				// 'class' - The class attribute for the list item containing the link or text node.
				// 'rel' - The rel attribute.
				// 'onclick' - The onclick attribute for the link. This will only be set if the 'href' argument is present.
				// 'target' - The target attribute for the link. This will only be set if the 'href' argument is present.
				// 'title' - The title attribute. Will be set to the link or to a div containing a text node.
				// 'tabindex' - The tabindex attribute. Will be set to the link or to a div containing a text node.

				'class'  => implode(' ', $item->classes ),
				'title'  => esc_attr( $item->description ),
				'target' => $item->target,
			)
		);

		$toolbar->add_node( $args );
	}
	$args = array(
		'parent' => false,
		'id'    => 'id-' . $id_main_menu,
		'title' => __( esc_attr( get_option( 'on_toolbar_menu', '' ) ), 'solass-wp'),
		'href'  => $first_href,
		'meta'   => array(
				'class'  => 'my-solass-toolbar-menu',
			)
	);
	$toolbar->add_node( $args );
}
}


//+++++++++++++++++++++++++ Сворачивает ADMIN-BAR (Toolbar) into left-top corner.

if ( esc_attr( get_option( 'min_admin_barr', '' ) )) { 

  $login_changes = $login_changes.'<li>'.__( 'Мінімізовано адмін-тулбар на сторінках сайту.', 'solass-wp').'</li>';

 final class SOLASS_Collapse_Toolbar {
	public static function init(){ add_action( 'admin_bar_init', [ __CLASS__, 'hooks' ] );	}
	public static function hooks(){
		// remove html margin bumps
		remove_action( 'wp_head', '_admin_bar_bump_cb' );
		add_action( 'wp_head', [ __CLASS__, 'collapse_styles' ] );
	}
	public static function collapse_styles(){
		// do nothing for admin-panel.
		// Remove this if you want to collapse admin-bar in admin-panel too.
		if( is_admin() ){ return; }
		ob_start();
		?>
		<style id="solass_collapse_admin_bar">
			#wpadminbar{ background:none; float:left; width:auto; height:auto; bottom:0; min-width:0 !important; }
			#wpadminbar > *{ float:left !important; clear:both !important; }
			#wpadminbar .ab-top-menu li{ float:none !important; }
			#wpadminbar .ab-top-secondary{ float: none !important; }
			#wpadminbar .ab-top-menu>.menupop>.ab-sub-wrapper{ top:0; left:100%; white-space:nowrap; }
			#wpadminbar .quicklinks>ul>li>a{ padding-right:17px; }
			#wpadminbar .ab-top-secondary .menupop .ab-sub-wrapper{ left:100%; right:auto; }
			html{ margin-top:0!important; }
			#wpadminbar{ overflow:hidden; width:33px; height:30px; }
			#wpadminbar:hover{ overflow:visible; width:auto; height:auto; background:rgba(102,102,102,.7); }
			/* the color of the main icon */
			#wp-admin-bar-<?= is_multisite() ? 'my-sites' : 'site-name' ?> .ab-item:before{ color:#797c7d; }
			/* hide wp-logo */
			#wp-admin-bar-wp-logo{ display:none; }
			#wp-admin-bar-search{ display:none; } 
			/* edit for twentysixteen */
			body.admin-bar:before{ display:none; }
			/* for almin panel --- */
			@media screen and ( min-width: 782px ) {
				html.wp-toolbar{ padding-top:0 !important; }
				#wpadminbar:hover{ background:rgba(102,102,102,1); }
				#adminmenu{ margin-top:48px !important; }
			}
			/* Gutenberg */
			#wpwrap .edit-post-header{ top:0; }
			#wpwrap .edit-post-sidebar{ top:56px; }
		</style>
		<?php
		$styles = ob_get_clean();
		echo preg_replace( '/[\n\t]/', '', $styles ) ."\n";
	}
}

SOLASS_Collapse_Toolbar::init();

// Удаление базовых элементов (ссылок) из тулбара сайта
add_action( 'add_admin_bar_menus', function(){
	if( is_admin() ){
		return;
	}
	## доступно для удаления:
//	remove_action( 'admin_bar_menu', 'wp_admin_bar_my_account_menu', 0 );  // Внутренние ссылки меню профиля
	remove_action( 'admin_bar_menu', 'wp-admin-bar-search', 4 );      		// поиск
	remove_action( 'admin_bar_menu', 'wp_admin_bar_search_menu', 4 );      // поиск
	remove_action( 'admin_bar_menu', 'wp-admin-bar-top-secondary', 4 );      // поиск
	remove_action( 'admin_bar_menu', 'wp_admin_bar_my_account_item', 7 );  // Полностью меню профиля
	## Связанное с сайтом
//	remove_action( 'admin_bar_menu', 'wp_admin_bar_sidebar_toggle', 0 );   //
	remove_action( 'admin_bar_menu', 'wp_admin_bar_wp_menu', 10 );         // WordPress ссылки (WordPress лого)
	remove_action( 'admin_bar_menu', 'wp_admin_bar_my_sites_menu', 20 );   // мои сайты
//	remove_action( 'admin_bar_menu', 'wp_admin_bar_site_menu', 30 );       // сайты
	remove_action( 'admin_bar_menu', 'wp_admin_bar_customize_menu', 40 );  // настроить тему
	remove_action( 'admin_bar_menu', 'wp_admin_bar_updates_menu', 50 );    // обновления
	## Content related.
	if ( ! is_network_admin() && ! is_user_admin() ) {
		// комментарии
		remove_action( 'admin_bar_menu', 'wp_admin_bar_comments_menu', 60 );
		// добавить запись, страницу, медиафайл и т.д.
	//	remove_action( 'admin_bar_menu', 'wp_admin_bar_new_content_menu', 70 );
	}
	## редактировать
	remove_action( 'admin_bar_menu', 'wp_admin_bar_edit_menu', 80 );
	## вся дополнительная группа (поиск и аккаунт) расположена справа в меню
//	remove_action( 'admin_bar_menu', 'wp_admin_bar_add_secondary_groups', 200 );

	remove_action( 'admin_bar_menu', 'wp-admin-bar-wpseo-menu', 0 );
	remove_action( 'admin_bar_menu', 'wp-admin-bar-id_172', 0 );
	
});

}


//+++++++++++++++++ Добавляет миниатюры/фото-превью записи в списке таблицы записей в админке
//
add_action('init', 'solass_wp_add_post_thumbs_in_post_list_table', 20 );
if (!function_exists('solass_wp_add_post_thumbs_in_post_list_table')) { 	
	function solass_wp_add_post_thumbs_in_post_list_table(){
		global $ptype_names_string, $login_changes_functions;
		// проверим какие записи поддерживают миниатюры
		$supports = get_theme_support('post-thumbnails');
		
		// !!!!! указывает типы для которых нужна колонка отдельно !!!!!
		$ptype_names = array();
		$ptype_names_string = "";
		$spisok_post = "";
		$post_types = get_post_types(array( 'public' => true ));
		unset( $post_types[ 'attachment' ] );
		foreach ($post_types as $post_type) { 
		if(esc_attr( get_option( 'solass_wp_'.$post_type, '' ) )) { 
			$ptype_names[] = $post_type; 
			$ptype_names_string = $ptype_names_string.$post_type.", "; // $ptype_names_string = implode(", ", $ptype_names);  // пример: $ptype_names = array('post','page','service'); 
		} 
		}
		if ( $ptype_names_string ) { $login_changes_functions = $login_changes_functions.'<li>'.__( 'Включені мініатюри для списків: '.$ptype_names_string, 'solass-wp').'</li>'; }
		
		// Определяем типы записей автоматически
		if( ! isset($ptype_names) ){
			if( $supports === true ){
				$ptype_names = get_post_types(array( 'public'=>true ), 'names');
				$ptype_names = array_diff( $ptype_names, array('attachment') );
			}
			// для отдельных типов записей
			elseif( is_array($supports) ){
				$ptype_names = $supports[0];
			}
		}

		// добавляем фильтры для всех найденных типов записей
		foreach( $ptype_names as $ptype ){
			add_filter( "manage_{$ptype}_posts_columns", 'solass_wp_add_thumb_column' );
			add_action( "manage_{$ptype}_posts_custom_column", 'solass_wp_add_thumb_value', 10, 2 );
		}
	}

	// добавим колонку
	function solass_wp_add_thumb_column( $columns ){
		// подправим ширину колонки через css
		add_action('admin_notices', function(){
			echo '
			<style>
				.column-thumbnail{ width:80px; text-align:center; }
			</style>';
		});

		$num = 1; // после какой по счету колонки вставлять новые

		$new_columns = array( 'thumbnail' => __('Thumbnail') );

		return array_slice( $columns, 0, $num ) + $new_columns + array_slice( $columns, $num );
	}

	// заполним колонку
	function solass_wp_add_thumb_value( $colname, $post_id ){
		if( 'thumbnail' == $colname ){
			$width  = $height = 50;

			// миниатюра
			if( $thumbnail_id = get_post_meta( $post_id, '_thumbnail_id', true ) ){
				$thumb = wp_get_attachment_image( $thumbnail_id, array($width, $height), true );
			}
			// из галереи...
			elseif( $attachments = get_children( array(
				'post_parent'    => $post_id,
				'post_mime_type' => 'image',
				'post_type'      => 'attachment',
				'numberposts'    => 1,
				'order'          => 'DESC',
			) ) ){
				$attach = array_shift( $attachments );
				$thumb = wp_get_attachment_image( $attach->ID, array($width, $height), true );
			}

			echo empty($thumb) ? ' ' : $thumb;
		}
	}
}




// ++++++++++++++++++++ Создаем собственную форму фильтра записей по категориям

remove_action( 'restrict_manage_posts', 'solass_wp_true_taxonomy_filter' ); // Удаляем возможно включенные старые функции выпадающих меню

add_action( 'restrict_manage_posts', 'solass_wp_true_taxonomy_filter' ); 
if (!function_exists('solass_wp_true_taxonomy_filter')) { 	
function solass_wp_true_taxonomy_filter() {
	global $typenow, $pagenow; // тип поста
		$taxonomies = get_object_taxonomies( $typenow ); // замените 'post_type_name' на название нужного типа поста
		$taxes = $taxonomies; 

		$on_filter = "";
		$post_types = get_post_types(array( 'public' => true ));
		unset( $post_types[ 'attachment' ] ); unset( $post_types[ 'page' ] );
		foreach ($post_types as $post_type) { 
		if(esc_attr( get_option( 'solass_wp_filter_'.$post_type, '' ) ) && $typenow == $post_type ) { $on_filter = "ok"; } 
		}

		if ($on_filter) {
		foreach ($taxes as $tax) {
			$current_tax = isset( $_GET[$tax] ) ? $_GET[$tax] : '';
			$tax_obj = get_taxonomy($tax);
			$tax_name = mb_strtolower($tax_obj->labels->name);
			// функция mb_strtolower переводит в нижний регистр
			// она может не работать на некоторых хостингах, если что, убирайте её отсюда
			$terms = get_terms($tax);
			if(count($terms) > 0) {
				echo "<select name='$tax' id='$tax' class='postform'>";
				echo "<option value=''>".__( 'Всі ', 'solass-wp')." $tax_name</option>";
				foreach ($terms as $term) {
					echo '<option value='. $term->slug, $current_tax == $term->slug ? ' selected="selected"' : '','>' . $term->name .' (' . $term->count .')</option>'; 
				}
				echo "</select>";
			}
		}
}
}
}

// Выводим сообщение о включении кастомных фильтров
add_action( 'admin_enqueue_scripts', 'test_ptype_names_string' );

function test_ptype_names_string() {
	global $typenow, $login_changes_functions;
$ptype_names_string = ""; 
$post_types = get_post_types(array( 'public' => true )); //
unset( $post_types[ 'attachment' ] ); unset( $post_types[ 'page' ] );
foreach ($post_types as $post_type) { 
if(esc_attr( get_option( 'solass_wp_filter_'.$post_type, '' ) )) { 
$ptype_names_string = $ptype_names_string.$post_type.", "; 
} 
}
if ( $ptype_names_string ) { $login_changes_functions = $login_changes_functions.'<li>'.__( 'Включені фільтри для типів сторінок: '.$ptype_names_string, 'solass-wp').'</li>'; }
}

// Отключаем стандартные выпадающие вильтры для типов постов выбранных в плагине
if ( 'admin.php' === $pagenow && !empty( $_GET['page'] ) ) { $my_typenow = sanitize_text_field($_GET['page']); if(!$my_typenow) { $my_typenow = "admin"; }  } //&& isset( $_GET['page'] )
if ( 'edit.php' === $pagenow  && !empty( $_GET['post_type'] ) ) {  $my_typenow = sanitize_text_field($_GET['post_type']); if(!$my_typenow) { $my_typenow = "post"; } } // && isset( $_GET['post_type'] )
if ( 'post.php' === $pagenow && !empty( $_GET['post'] ) ) {  $my_typenow = sanitize_text_field($_GET['post']); if(!$my_typenow) { $my_typenow = "page"; } } // && isset( $_GET['post'] ) 
if ( 'edit-tags.php' === $pagenow && !empty( $_GET['taxonomy'] ) ) { $my_typenow = sanitize_text_field($_GET['taxonomy']); if(!$my_typenow) { $my_typenow = "category"; } } // && isset( $_GET['taxonomy'] )
$post_types = get_post_types(array( 'public' => true )); 
unset( $post_types[ 'attachment' ] ); unset( $post_types[ 'page' ] );
foreach ($post_types as $post_type) { if(esc_attr( get_option( 'solass_wp_filter_'.$post_type, '' ) )) { if ($my_typenow == $post_type) { add_filter( 'wp_dropdown_cats', '__return_false' ); } } }

// ++++++++++++++++++ Включається вивід помилок у коді сторінки - аналог WP_DEBUG що находиться у файлі wp-config.php
if( get_option( 'solass_wp_debug', false ) ) {
$login_changes_functions = $login_changes_functions.'<li class="no_func">'.__( 'На сайті виводяться помилки коду WP_DEBUG', 'solass-wp').'</li>';

add_action('init', 'solass_wp_debug_mode');
function solass_wp_debug_mode() {
    if ( ! defined( 'WP_DEBUG' ) ) {
        define('WP_DEBUG', true);
    }

    if ( WP_DEBUG && ! defined( 'WP_DEBUG_LOG' ) ) {
        define('WP_DEBUG_LOG', true);
    }

    if ( WP_DEBUG && ! defined( 'WP_DEBUG_DISPLAY' ) ) {
        define('WP_DEBUG_DISPLAY', true);
    }

    @ini_set('display_errors', 1);
    @ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
}

}

// ++++++++++++++++++ Включається вивід помилок у коді сторінки - аналог WP_DEBUG що находиться у файлі wp-config.php
if( get_option( 'solass_wp_min_php', false ) ) {
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Встановлені мінімальні параметри PHP', 'solass-wp').'</li>';

add_action('init', 'solass_wp_setting_min_php');
function solass_wp_setting_min_php() {
    // Максимальное время выполнения скрипта
    ini_set('max_execution_time', '300');
    // Время ожидания ввода/вывода данных
    ini_set('max_input_time', '300');
    // Максимальный размер загружаемого файла
    ini_set('upload_max_filesize', '128M');
    // Максимальный размер POST данных
    ini_set('post_max_size', '128M');
    // Установка максимального объема памяти
    ini_set('memory_limit', '256M');
    // Максимальное количество вложенных вызовов функций
    //ini_set('xdebug.max_nesting_level', 300);	
}

}


//------------------------------------------------------------------------------------------------------ //
//---------------------------------- !!! СТРУКТУРА, РАЗДЕЛЫ, ВИДЖЕТЫ ----------------------------------- //
//------------------------------------------------------------------------------------------------------ //

// +++++++++++++++++++  Добавление кастомных таксономий (рубрики и метки) +++++++++++++++ //

if ( get_option( 'swp_custom_taxonomy_arrey', '' ) ) {
$solass_wp_custom_sidebar_arrey = get_option( 'swp_custom_taxonomy_arrey', '' );
$login_changes_structure_plus = "";
foreach ( $solass_wp_custom_sidebar_arrey as $key => $testtab ) {
if (!empty($testtab['id']) && empty($testtab['close']) && empty($testtab['hide'])) { 
$login_changes_structure_plus = '<li>'.__( 'Додані користувацькі рубрики та мітки (таксономії)', 'solass-wp').'</li>';
}
}
$login_changes_structure = $login_changes_structure . $login_changes_structure_plus;

if ( !empty( $login_changes_structure_plus ) ) { add_action( 'init', 'solass_wp_custom_taxonomy' ); }

function solass_wp_custom_taxonomy() {
$solass_wp_custom_taxonomy_arrey = get_option( 'swp_custom_taxonomy_arrey', '' );
foreach ( $solass_wp_custom_taxonomy_arrey as $key => $tab ) {
if (!empty($tab['id']) && empty($tab['close']) && empty($tab['hide'])) { 
$tab['id'] = solass_wp_translit($tab['id']);
if(empty($tab['label'])) { $hierarchical = true; } else {  $hierarchical = false; }
if(empty($tab['name'])) { $tab['name'] = __( 'Categories' ); }

	$args = array(
		'labels' => array( 
			'name' => esc_html__( $tab['name'], 'solass-wp' ), 			'singular_name' => esc_html__( $tab['name'], 'solass-wp' ), 
			'menu_name' => esc_html__( $tab['name'], 'solass-wp' ), 	'name_admin_bar' => esc_html__( $tab['name'], 'solass-wp' ) 
		),
		'public'			 => true,
		'show_ui'			 => true, 
		'show_admin_column'  => true, // вывод колонки в списке
		'hierarchical' 		 => $hierarchical, // возможность подрубрик
	);
	register_taxonomy( $tab['id'], 'solass_aviatickets', $args );
}
}
}

}

// +++++++++++++++++++  Добавление кастомных типов постов (разделы страниц) +++++++++++++ //

if ( get_option( 'swp_custom_post_arrey', '' ) ) {
$solass_wp_custom_post_arrey = get_option( 'swp_custom_post_arrey', '' );
$login_changes_structure_plus = "";
foreach ( $solass_wp_custom_post_arrey as $key => $taxtab ) {
if (!empty($taxtab['id']) && empty($taxtab['close']) && empty($taxtab['hide'])) { 
//echo "--------------".$taxtab['name']."<br>";
$login_changes_structure_plus = '<li>'.__( 'Додані користувацькі типи постів (розділи)', 'solass-wp').'</li>';
} 
}
$login_changes_structure = $login_changes_structure . $login_changes_structure_plus;

if ( !empty( $login_changes_structure_plus ) ) { add_action( 'init', 'solass_wp_custom_post_type' ); }

function solass_wp_custom_post_type() {

$solass_wp_custom_post_arrey = get_option( 'swp_custom_post_arrey', '' );
$num_post = 0;
foreach ( $solass_wp_custom_post_arrey as $key => $tab ) {
if (!empty($tab['id']) && empty($tab['close']) && empty($tab['hide'])) {
$num_post = $num_post + 1; 
$tab['id'] = solass_wp_translit($tab['id']);
if(empty($tab['label'])) { $hierarchical = true; } else {  $hierarchical = false; }
if(empty($tab['name'])) { $tab['name'] = __( 'Posts' ).'-'.$num_post; }

    $labels = array(
        'name'               => $tab['name'],
        'singular_name'      => $tab['name'],
        'menu_name'          => $tab['name'],
        'name_admin_bar'     => $tab['name']/*,
        'add_new'            => 'Додати новий',
        'add_new_item'       => 'Додати новий My Custom Post Type',
        'new_item'           => 'Новий "Тестируем"',
        'edit_item'          => 'Редагувати Тестируем',
        'view_item'          => 'Переглянути Тестируем',
        'all_items'          => 'Всі Тестируем',
        'search_items'       => 'Шукати Тестируем',
        'parent_item_colon'  => 'Головний Тестируем:',
        'not_found'          => 'Тестируем не знайдено.',
        'not_found_in_trash' => 'Тестируем не знайдено в корзині.'*/
    );
	
	if( !empty($tab['icon']) ) { $args = array( 'menu_icon' => $tab['icon'] ); } else { $args = array(); }
	
    $args = $args + array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => null,
        'capability_type'    => 'post',
        'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt' ),//, 'author', 'comments'
//      'rewrite'            => array( 'slug' => 'solass_custom_post' ), //get_stylesheet_directory_uri() . '/icon.png'. Изображение должно быть 16х16.
//		'menu_icon'			 => $tab['icon'],
        'taxonomies'         => array( $tab['taxonomy'] ) // включение категорий/рубрик
    );

    register_post_type( $tab['id'], $args );
}
}

}
}


// +++++++++++++++++++  Включение установки форматов записей (video, image, quote, link...) +++++++++++++ //
// get_post_format() возвращает один из предопределённых форматов (например, video, image, quote, link, gallery, status).
if ( get_option( 'solass_wp_post_format', '' ) ) {
$login_changes_structure = $login_changes_structure.'<li>'.__( 'Включено вибір форматів записів', 'solass-wp').'</li>';

function swp_add_custom_post_formats() {
    add_theme_support('post-formats', array('standard', 'video', 'image', 'quote', 'link', 'gallery', 'status'));
}
add_action('after_setup_theme', 'swp_add_custom_post_formats');
}

// +++++++++++++++++ Информуємо про включення мега-меню 
if ( get_option( 'solass_wp_mega_menu', '' ) ) {
$login_changes_structure = $login_changes_structure.'<li>'.__( 'Включена можливість створення мега-меню', 'solass-wp').'</li>';
}

// +++++++++++++++++ Информуємо про включення мега-меню 
if ( !empty( get_option( 'solass_wp_array_post_gallery', [] ) ) ) {
$login_changes_structure = $login_changes_structure.'<li>'.__( 'Підключене адміністрування фотогалереї для деяких постів', 'solass-wp').'</li>';
}

// +++++++++++++++++ Включаем поддержку виджетов. 
// +++++++++++++++ Добавляем область для виджетов

if ( get_option( 'swp_custom_sidebar_arrey', '' ) ) {
$testtab = array(); $testtab['id'] = ""; $testtab['close'] = ""; $testtab['hide'] = "";
$solass_wp_custom_sidebar_arrey = get_option( 'swp_custom_sidebar_arrey', '' );
$login_changes_structure_plus = "";
foreach ( $solass_wp_custom_sidebar_arrey as $key => $testtab ) { 
//	print_r($testtab['id']);
if (!empty($testtab['id']) && !$testtab['close'] && empty($testtab['hide']) ) { 
$login_changes_structure_plus = '<li>'.__( 'Додані сайдбари для виводу віджетів', 'solass-wp').'</li>';
}
 $testtab['id'] = ""; $testtab['close'] = ""; $testtab['hide'] = "";
}
$login_changes_structure = $login_changes_structure . $login_changes_structure_plus;

function solass_wp_register_sidebars() {
$solass_wp_custom_sidebar_arrey = get_option( 'swp_custom_sidebar_arrey', '' );
$tab = array(); $sidebar_id = ""; $sidebar_name = ""; $sidebar_desc = ""; $sidebar_hook = ""; $sidebar_close = ""; $sidebar_number = 0;
foreach ( $solass_wp_custom_sidebar_arrey as $key => $tab ) {
$sidebar_number = $sidebar_number + 1;
if (!empty($tab['id']) && !$tab['close'] && empty($tab['hide'])) { 
$tab['id'] = solass_wp_translit($tab['id']);
if(!$tab['name']) { $tab['name'] = __( 'Сайдбар', 'solass-wp' ).'-'.$sidebar_number; }
if(!$tab['desc']) { $tab['desc'] = __( 'Перетягніть сюди віджет для заповнення сайдбару', 'solass-wp' ); }
//$tab['desc'] = $tab['desc'].'<strong>'.__( 'шорткод сайдбару:', 'solass-wp' ).' <code>[swp_widget id="'.$tab['id'].'"]</code></strong>';
	register_sidebar( array(
        'name' => $tab['name'],
        'id' => $tab['id'],
        'description' => $tab['desc'],
        'before_widget' => '<div id="%1$s" class="widget %2$s side_'.$tab['id'].'">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="widget-title title_'.$tab['id'].'">',
        'after_title' => '</h2>',
    ) );
}
} 
}
add_action( 'widgets_init', 'solass_wp_register_sidebars' ); 


$solass_wp_custom_sidebar_arrey = get_option( 'swp_custom_sidebar_arrey', '' );
$sidebar_number = 0; $sidebar_id = ""; $solass_wp_add_sidebar = "";
foreach ( $solass_wp_custom_sidebar_arrey as $key => $tab ) {
$sidebar_number = $sidebar_number + 1;
if (!empty($tab['id']) && !$tab['close'] && $tab['hook'] && !$tab['hide']) { 
$solass_wp_add_sidebar = '<li>'.__( 'Включений вивод віджетів по хукам', 'solass-wp').'</li>';
$sidebar_id = solass_wp_translit($tab['id']);
add_action( $tab['hook'], 'solass_wp_add_sidebar' ); 
}
}
$login_changes_structure = $login_changes_structure.$solass_wp_add_sidebar;

function solass_wp_add_sidebar() { 
global $sidebar_id;
    if ( is_active_sidebar( $sidebar_id ) ) { 
        echo '<div id="sidebar_'.$sidebar_id.'" class="sidebar_'.$sidebar_id.' solass_sidebar">';
        dynamic_sidebar( $sidebar_id );
        echo '</div>';
    }
}

}

// Выводим содержимое сайдбара в месте размещения шорткода [swp_widget id="id_sidebar"]
function solass_wp_widget_shortcode( $atts ) {
  // получаем значение атрибута из массива $atts
  $id_widget = $atts['id'];
  // код для вывода сайдбара 
    ob_start(); 
    if ( is_active_sidebar( $id_widget ) ) { 
        echo '<div id="sidebar_'.$id_widget.'" class="sidebar_'.$id_widget.' solass_sidebar">';
        dynamic_sidebar( $id_widget );
        echo '</div>';
    }
    $widget_content = ob_get_contents();
    ob_end_clean();
  return $widget_content;
}

// регистрируем шорткод сайдбаров для виджетов
function solass_wp_register_sidebar_shortcode() {
  add_shortcode( 'swp_widget', 'solass_wp_widget_shortcode' );
}
add_action( 'init', 'solass_wp_register_sidebar_shortcode' );
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Увімкнутий вивід сайдбарів за шорткодом <code style="white-space: nowrap;">[swp_widget id="id_sidebar"]</code>', 'solass-wp').'</li>';


// ----------- Выводим шорткод ID сайдбаров на странице виджетов [swp_widget id="id_sidebar"] ----------- //

function solass_wp_display_sidebar_id_in_widget_list($params) {
    global $wp_registered_sidebars;
	//print_r($wp_registered_sidebars); 
    if (is_array($params)) { $sidebar_id = $params[0]['id']; } else { $sidebar_id = $params; }
	echo '<div class="sidebar-description solass_shortcode" style="margin: 15px 7px">шорткод сайдбару: <code style="-webkit-user-select: all; user-select: all; font-weight: normal;">[swp_widget id="' . $sidebar_id . '"]</code></div>'; 
	// return $params;
}
if( is_admin() && get_option( 'swp_custom_display_sidebar_id', '' ) ){
add_filter('dynamic_sidebar_after', 'solass_wp_display_sidebar_id_in_widget_list');
$login_changes_functions = $login_changes_functions.'<li>'.__( 'На сторінці віджетів включені шорткоди сайдбарів.', 'solass-wp').'</li>';
}


// ++++++++++ End поддержка виджетов 




//------------------------------------------------------------------------------------------------------ //
//------------------------------ ШОРТКОД ЗАВАНТАЖЕННЯ ФАЙЛІВ НА СТОРІНКАХ САЙТУ ------------------------ //
//------------------------------------------------------------------------------------------------------ //
/*
function solass_wp_enqueue_upload_scripts() {
if (is_user_logged_in()) { 
	wp_register_script( 'upload-script', get_template_directory_uri() . '/upload-script.js', array('jquery'), null, true );
        wp_enqueue_script('upload-script');
        wp_localize_script('upload-script', 'uploadAjax', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('upload_file_nonce'),
        ));
    } 
}
add_action('wp_enqueue_scripts', 'solass_wp_enqueue_upload_scripts', 20);

function solass_wp_render_upload_interface() {
    if (is_user_logged_in()) {
        echo '<div id="file-upload-interface" style="border: 2px dashed #ccc; padding: 20px; text-align: center;">
                <div style="line-height: 1.3em; font-size: 80%; margin-bottom: 10px;">'.__( 'Перетащіть сюди файл або нажміть для завантаження', 'solass-wp').'</div>
                <input type="file" id="upload-file-input" style="display:none;">
                <button type="button" id="select-file-button">'.__( 'Вибрати файл', 'solass-wp').'</button> <br>
                    <input type="hidden" id="file-url" name="file_url">
              <a href="#" onclick="event.preventDefault(); document.getElementById(\'fotoform1\').value=\'\'; document.getElementById(\'fotoimg1\').src=\'\'; document.getElementById(\'fotoprew1\').src=\'\'; return false;">'.__( 'видалити', 'solass-wp').'</a>
              </div>';
    } else {
        echo '<p>'.__( 'Для завантаження файлів увійдіть у систему', 'solass-wp').'</p>';
    }
}
add_shortcode('swp_file_upload', 'solass_wp_render_upload_interface');

function solass_wp_handle_file_upload() {
    check_ajax_referer('upload_file_nonce', 'nonce');

    if (!is_user_logged_in()) {
        wp_send_json_error(array('message' => 'Ви не авторизовані'));
    }

    if (empty($_FILES['file'])) {
        wp_send_json_error(array('message' => 'Файл не вибраний'));
    }

    $file = $_FILES['file'];
    $uploaded_file = wp_handle_upload($file, array('test_form' => false));

    if (isset($uploaded_file['error'])) {
        wp_send_json_error(array('message' => $uploaded_file['error']));
    }

    // Опционально, добавляем файл в медиабиблиотеку
    $attachment_id = wp_insert_attachment(array(
        'post_mime_type' => $uploaded_file['type'],
        'post_title' => sanitize_file_name($uploaded_file['file']),
        'post_content' => '',
        'post_status' => 'inherit',
    ), $uploaded_file['file']);

    if (is_wp_error($attachment_id)) {
        wp_send_json_error(array('message' => 'Помилка завантаження файлу до медіабібліотеки'));
    }

    require_once(ABSPATH . 'wp-admin/includes/image.php');
    wp_update_attachment_metadata($attachment_id, wp_generate_attachment_metadata($attachment_id, $uploaded_file['file']));

    wp_send_json_success(array('url' => $uploaded_file['url']));
}
add_action('wp_ajax_upload_file', 'solass_wp_handle_file_upload');

*/


/*
// --------------------- Подгружаем файл подключения скриптов и стилей POFO ---------------------------- //

if (isset($value->response['pofo-addons/pofo-addons.php'])) { 
// проверяем есть ли файл плагина POFO и включаем что-то
}
require_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Смотрим файл плагинов
if (is_plugin_active('pofo-addons/pofo-addons.php')) { // Проверяем включен ли плагин POFO
// Проверяем есть ли файл подключения скриптов и стилей
if (file_exists(get_stylesheet_directory().'/my_function/pofo-js-css/js-css.php')) { 
require_once(get_stylesheet_directory()."/my_function/pofo-js-css/js-css.php"); 
} 
}

// ---------------- Подключаем файлы шорткодов ---------------- //

if (file_exists(get_stylesheet_directory().'/my_function/shortcode/shortcode.php')) {
require_once(get_stylesheet_directory()."/my_function/shortcode/shortcode.php"); 
} 
// ----------------------------------------------------------------------------------------------------
*/

/*

//  ------------------------ Функция визуализации Вариаций и изменение их последовательности 
//  ------------------------ согласно последовательности в карточке товара
//  ------------------------ Стандартная последовательность в теме сайта определяется 
//  ------------------------ из последовательности списка атрибутов
//
//  Product page: Variation controls - Code from "wc_dropdown_variation_attribute_options()" function in "../woocommerce/includes/wc-template-functions.php"
//
    function swp_nm_variation_attribute_options( $html, $args ) {
		global $nm_theme_options, $nm_globals;

if ( $nm_theme_options['product_custom_controls'] ) {

		$attr = nm_woocommerce_get_taxonomy_attribute( $args['attribute'] );
        $variation_type = ( $attr ) ? $attr->attribute_type : null;

        // Is this a custom variation-control attribute?
        if ( ! $variation_type || ! array_key_exists( $variation_type, $nm_globals['pa_variation_controls'] ) ) {
            return $html;
        }

        $options      = $args['options'];
        $product      = $args['product'];
        $attribute    = $args['attribute'];
        $name         = $args['name'] ? $args['name'] : 'attribute_' . sanitize_title( $attribute );

        if ( empty( $options ) && ! empty( $product ) && ! empty( $attribute ) ) {
            $attributes = $product->get_variation_attributes();
            $options    = $attributes[ $attribute ];
        }

        // Hide default select-box
        $html = '<div class="nm-select-hidden">' . $html . '</div>';

        $html .= '<ul class="nm-variation-control nm-variation-control-'. esc_attr( $variation_type ) .'">';

        if ( ! empty( $options ) ) {

$terms = wc_get_product_terms( $product->get_id(), $attribute, array( 'fields' => 'all' ) );

$variation_order = array();
// Получаем доступные вариации для этого продукта
$product_variations = $product->get_available_variations();
    // Перебираем вариации продукта
    foreach ( $product_variations as $variation ) {
        // Получаем атрибуты вариации
        $var_attributes = $variation['attributes'];
        // Проверяем, есть ли атрибут 'pa_color' у данной вариации
        if ( isset( $var_attributes['attribute_'.$attribute] ) ) {
            // Получаем значение атрибута 'pa_color' для данной вариации
            $color = $var_attributes['attribute_'.$attribute];
            // Добавляем значение атрибута 'pa_color' в массив порядка вариаций
            $variation_order[] = $color;
        }
    }

$order = $variation_order;
// Создаем временный массив для сортировки
$temp = array();
// Проходим по каждому элементу в порядке цветов
foreach ($order as $slug) {
    // Ищем объект WP_Term с соответствующим slug
    foreach ($terms as $term) {
        if ($term->slug === $slug) {
            // Если нашли, добавляем его во временный массив
            $temp[] = $term;
            break;
        }
    }
}
// Заменяем исходный массив отсортированным временным массивом
$terms = $temp;
// Теперь $terms содержит объекты WP_Term в нужном порядке
//echo " ------- varOrder: "; print_r($order); echo " <br>";
//echo " ------- terms-NEW: "; print_r($terms); echo " <br>";	

           switch ( $variation_type ) {
                // Control type: Color swatch
                case 'color' :

                    // Save data in global variable to avoid getting the "nm_pa_colors" option multiple times
                    if ( ! isset( $nm_globals['pa_colors'] ) ) {
                        $nm_globals['pa_colors'] = get_option( 'nm_pa_colors' );
                    }
					
                    foreach ( $terms as $term ) {
                        if ( in_array( $term->slug, $options, true ) ) {
                            $selected_class = ( $args['selected'] === $term->slug ) ? ' selected' : '';
                            $color = ( isset( $nm_globals['pa_colors'][$term->term_id] ) ) ? $nm_globals['pa_colors'][$term->term_id] : '#ccc';

                            $html .= '<li class="nm-variation-option' . $selected_class . '" data-value="' . esc_attr( $term->slug ) . '">';
                            $html .= '<i style="background:' . esc_attr( $color ) . ';" class="nm-pa-color nm-pa-color-' . esc_attr( strtolower( $term->slug ) ) . '"></i>';
                            $html .= '<span>' . esc_html( apply_filters( 'woocommerce_variation_option_name', $term->name ) ) . '</span>';
                            $html .= '</li>';
                        }
                    }
                    
                    break;
                // Control type: Image swatch
                case 'image' :
                    
                    foreach ( $terms as $term ) {
                        if ( in_array( $term->slug, $options, true ) ) {
                            $selected_class = ( $args['selected'] === $term->slug ) ? ' selected' : '';
                            $image_id = absint( get_term_meta( $term->term_id, 'nm_pa_image_thumbnail_id', true ) );
                            $image_url = ( $image_id ) ? wp_get_attachment_url( $image_id ) : '';
                            
                            $html .= '<li class="nm-variation-option'. $selected_class . '" data-value="' . esc_attr( $term->slug ) . '">';
                            $html .= '<div class="nm-pa-image-thumbnail-wrap"><img src="' . esc_url( $image_url ) . '" class="nm-pa-image-thumbnail"></div>';
                            $html .= '<span>' . esc_html( apply_filters( 'woocommerce_variation_option_name', $term->name ) ) . '</span>';
                            $html .= '</li>';
                        }
                    }
                    
                    break;
                // Control type: Label
                default :

                    foreach ( $terms as $term ) {
                        if ( in_array( $term->slug, $options, true ) ) {
                            $selected_class = ( $args['selected'] === $term->slug ) ? ' selected' : '';

                            $html .= '<li class="nm-variation-option'. $selected_class . '" data-value="' . esc_attr( $term->slug ) . '">';
                            $html .= '<span>' . esc_html( apply_filters( 'woocommerce_variation_option_name', $term->name ) ) . '</span>';
                            $html .= '</li>';
                        }
                    }
            }
        }

        $html .= '</ul>';

        return $html;
    }
}    
// Удаляем первую функцию nm_variation_attribute_options
//remove_filter( 'woocommerce_dropdown_variation_attribute_options_html', 'nm_variation_attribute_options', 10 );
add_filter( 'woocommerce_dropdown_variation_attribute_options_html', 'swp_nm_variation_attribute_options', 999, 2 );
------------------------------------ */


/* ----------------------------------

// Вывод кружочков с цветами вариаций на странице товара
//add_action('woocommerce_before_variations_form', 'swp_add_variations_form'); 
add_action( 'woocommerce_single_product_summary', 'swp_add_variations_form', 20 );

// Функция для вывода кружочков с цветами
function swp_add_variations_form($product) {
global $product, $nm_globals, $nm_theme_options;

$nm_form_class = ( $nm_theme_options['product_select_hide_labels'] ) ? ' nm-select-hide-labels' : '';
if ( $nm_theme_options['product_custom_controls'] ) {
    $nm_form_class .= ' nm-no-select';
    if ( $nm_theme_options['product_swatches_color_tooltip'] || $nm_theme_options['product_swatches_image_tooltip'] ) {
        $nm_form_class .= ' nm-variation-controls-tooltip';
        $nm_form_class .= ( $nm_theme_options['product_swatches_color_tooltip'] ) ? ' tooltip-color' : '';
        $nm_form_class .= ( $nm_theme_options['product_swatches_image_tooltip'] ) ? ' tooltip-image' : '';
    }
} else {
    $nm_form_class .= ( $nm_theme_options['product_custom_select'] ) ? ' nm-custom-select' : ' nm-default-select';
}

    // Получаем атрибуты товара
    $attributes = $product->get_attributes();
	if ( ! isset( $nm_globals['pa_colors'] ) ) {
    $nm_globals['pa_colors'] = get_option( 'nm_pa_colors' );
    }

    // Проверяем, есть ли атрибут "pa_color" с опциями
    if (isset($attributes['pa_color']) && ( $product && !$product->is_type( 'variable' ) ) &&  $nm_globals['pa_colors'] ) { // $product->is_type( 'grouped' ) || $product->is_type('woosg')
    $options = $attributes['pa_color']->get_options();
?>
<form id="nm-variations-form" class="variations_form cart<?php echo esc_attr( $nm_form_class ); ?>" method="post" enctype='multipart/form-data' data-product_id="<?php echo absint( $product->get_id() ); ?>" data-product_variations="<?php echo $variations_attr; ?>">
<table class="variations" cellspacing="0" role="presentation" style="margin: 0 0 30px 0">
<tbody><tr><th class="label"><label for="<?php echo esc_attr( get_taxonomy('pa_color')->labels->singular_name ); ?>"><?php echo wc_attribute_label( get_taxonomy('pa_color')->labels->singular_name ); // WPCS: XSS ok. ?></label>
<div class="woocommerce-breadcrumb" style="font-size: 0.9em"><?php echo esc_html__("Назву кольору вкажіть у додатковій інформації під час заповнення форми замовлення.", 'nm-framework' ); ?></div>
</th>
<td class="value">
<?php 
        echo '<ul class="nm-variation-control nm-variation-control-color cursor-default">';
        // Выводим кружочки с цветами
        foreach ($options as $option) { 
			$term = get_term_by('id', $option, 'pa_color'); // 'pa_color' - это таксономия атрибута, замените ее на свою
			if ($term && !is_wp_error($term)) { 
			$color = ( isset( $nm_globals['pa_colors'][$term->term_id] ) ) ? $nm_globals['pa_colors'][$term->term_id] : '#ccc';
    		$color_name = $term->name; // Получаем название цвета
    		$color_slug = $color; // Получаем слаг цвета

            echo '<li class="nm-variation-option" data-value="' . esc_attr($option) . '">';
            echo '<i style="background-color: ' . $color_slug . '"></i>';
            echo '<span>' . $color_name .'</span>';
            echo '</li>';
		}
        }
         echo '</ul>';
?>
</td></tr>
</tbody></table>
</form>
<?php 
    }
}
---------------------------------------------- */

/*---------- Функция добавления кнопки инструкции сборки по SKU продукта -----------------*/
/*-------------------------------------------
//add_action( 'woocommerce_single_product_summary', 'add_sku_pdf_link_after_description', 25 );
function add_sku_pdf_link_after_description() {
    global $product;
    // Получаем SKU продукта
    $sku = $product->get_sku();
	// Находим позицию последнего символа "-"
	$last_dash_position = strrpos($sku, '-');
	// Если "-" найдено, обрезаем строку до этой позиции
	if ($last_dash_position !== false) {
    $sku = substr($sku, 0, $last_dash_position);
	}
	
    // Получаем путь к папке uploads
    $upload_dir = wp_upload_dir();
    // Полный путь к PDF файлу
    $pdf_file_path = $upload_dir['basedir'] . '/sborka/' . $sku . '.pdf';
    // Проверяем, существует ли файл
    if ( file_exists( $pdf_file_path ) ) {
        // Выводим ссылку на PDF файл
        echo '
<!--	<p><a href="' . esc_url( $upload_dir['baseurl'] . '/sborka/' . $sku . '.pdf' ) . '" class="nm_btn nm_btn_md nm_btn_link" title="Завантажити схему збору" target="_blank">
		<span class="nm_btn_title">Завантажити схему збору</span><span class="nm_btn_bg" style="background-color:#919191;"></span>
		</a></p>
		<p><a href="' . esc_url( $upload_dir['baseurl'] . '/sborka/' . $sku . '.pdf' ) . '" class="nm_btn nm_btn_md nm_btn_filled" title="Завантажити схему збору" target="_blank">
		<span class="nm_btn_title">Завантажити схему збору</span><span class="nm_btn_bg" style="background-color:#919191;"></span>
		</a></p>-->
		<p><a href="' . esc_url( $upload_dir['baseurl'] . '/sborka/' . $sku . '.pdf' ) . '" class="nm_btn nm_btn_sm nm_btn_border" title="Завантажити схему збору" target="_blank">
		<span class="nm_btn_title">Завантажити схему збору</span><span class="nm_btn_bg" style="background-color-:#919191;"></span>
		</a></p>
				';
    }
}
------------------------------------------------*/

//-------------------------------------------------------------------------