<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Вихід, якщо доступ до нього прямий
}

// --------------------------------------------------------------------------------------------- //
//--------------------------------------- ЗАГРУЗКА SVG-файлов ---------------------------------- //
// --------------------------------------------------------------------------------------------- //

if( get_option( 'solass_wp_load_svg', '' ) ) { 
$login_changes_functions = $login_changes_functions.'<li>'.__( 'Увімкнена можливість додавання SVG-файлів.', 'solass-wp').'</li>';

# Добавляет SVG в список разрешенных для загрузки файлов.
add_filter( 'upload_mimes', 'solass_wp_svg_upload_allow' );
function solass_wp_svg_upload_allow( $mimes ) {
	$mimes['svg']  = 'image/svg+xml';
	return $mimes;
}


// --------- Загрузка SVG-файла в библиотеку с установкой атрибутов width и height 
//            также запускается функция очистки SVG-файла от вредоносных кодов

function my_add_attachment_handler($attachment_id) {
    // получаем данные о вложении
    $attachment = get_post($attachment_id);
    $mime_type = $attachment->post_mime_type;
	$error_log = "";

    // проверяем, что это SVG-файл
    if ($mime_type === 'image/svg+xml' || $mime_type === 'image/svg' || $mime_type === 'svg') {
    // получаем путь к файлу на сервере
    $file_path = get_attached_file($attachment_id);
    // получаем содержимое файла
    $file_content = file_get_contents($file_path);
    // проверяем, есть ли в содержимом файла атрибуты width и height
    $svg_content = str_replace(["\n", "\r", "\t"], '', $file_content);
    preg_match('/<svg[^>]*>/i', $svg_content, $matches);
		
if (!empty($matches)) {
            $svg_tag = $matches[0]; $svg_tag_old = $svg_tag;
			$attr_svg = array(); $attr_width = ""; $attr_height = "";

    // Ищем ширину и высоту изображения с помощью регулярных выражений

	// Проверяем width и height
    preg_match_all('/(width|height)="(\d+)"/', $svg_content, $matches);
	// Проверяем viewBox
    preg_match('/viewBox="([-\d.]+)\s([-\d.]+)\s([-\d.]+)\s([-\d.]+)"/', $svg_content, $viewbox);
    // Если ширина и высота найдены, устанавливаем их в атрибуты
    if ($matches[2][0] && $matches[2][1]) {
        $attr_width = $matches[2][0];
        $attr_height = $matches[2][1]; 
    }
    if ($viewbox[3] && $viewbox[4] && (!$attr_width || !$attr_height )) {
        // Если не найдены, ищем viewBox и устанавливаем его значения в атрибуты
            $attr_width = (int)$viewbox[3];
            $attr_height = (int)$viewbox[4];
	} elseif(!$attr_width || !$attr_height ) {
            $attr_width = "500";
            $attr_height = "auto";
	}

// Формируем тег SVG с параметрами width и height
if($attr_width && $attr_height) {

if (preg_match('/<svg[^>]*(width|height)=\"\d+\"[^>]*>/', $svg_tag)) { //'/(width|height)=\"\d+\"/i'
    // Атрибуты уже есть, заменяем их
	preg_match_all('/<svg[^>]*(width|height)=\"\d+\"[^>]*>/', $svg_content, $matches_svg);
    $svg_tag = str_replace($matches[0][0], 'width="'.$attr_width.'"', $matches_svg[0]);
	$svg_tag = str_replace($matches[0][1], ' height="'.$attr_height.'"', $svg_tag); 
	$svg_tag = $svg_tag[0];
} else {
    // Атрибутов нет, добавляем новые
    $svg_tag = str_replace('<svg', '<svg width="'.$attr_width.'" height="'.$attr_height.'"', $svg_tag);
}
} 
    // заменяем исходный тег svg на обновленный
    $file_content = str_replace($svg_tag_old, $svg_tag, $file_content); 

}
    // производим санитизацию SVG-кода
    $sanitized_content = solass_wp_sanitize_svg($file_content);

$error_log = $error_log."
-----------------------------------------------------------------------------
Sanitiser
------------------
".$sanitized_content."
------------------
";
        // записываем обновленное содержимое файла обратно на сервер
        $result = file_put_contents($file_path, $sanitized_content);
        if ($result === false) {
            error_log('Failed to update SVG file');
        }

        // обновляем метаданные вложения
        wp_update_attachment_metadata($attachment_id, array('file' => $file_path));
    }

//error_log($error_log);

}
add_action('add_attachment', 'my_add_attachment_handler');



# Устанавливаем при выводе значения атрибутов width и height прописанными в CSV-файле 
function solass_wp_set_svg_size($attr, $attachment, $size) {
if ($attachment->post_mime_type == 'image/svg+xml' || $attachment->post_mime_type == 'image/svg') {

    $svg_url = wp_get_attachment_url($attachment->ID);
	$svg_url = str_replace(site_url().'/', ABSPATH, $svg_url );
//    $response = wp_remote_get($svg_url);
//    $svg_content = wp_remote_retrieve_body($response); 
	$svg_content = file_get_contents($svg_url); 

	// Очистка SVG от небезопасных тегов и атрибутов
    $svg_content = solass_wp_sanitize_svg($svg_content);
    
    // Ищем ширину и высоту изображения с помощью регулярных выражений
    $pattern = '/(width|height)="(\d+)"/';
    preg_match_all($pattern, $svg_content, $matches);
    // Если ширина и высота найдены, устанавливаем их в атрибуты
    if (isset($matches[1][0]) && isset($matches[2][0])) {
        $attr['width'] = $matches[2][0];
        $attr['height'] = $matches[2][0];
    }
    else {
        // Если не найдены, ищем viewBox и устанавливаем его значения в атрибуты
        preg_match('/viewBox="([-\d.]+)\s([-\d.]+)\s([-\d.]+)\s([-\d.]+)"/', $svg_content, $viewbox);
        if (isset($viewbox[3]) && isset($viewbox[4])) {
            $attr['width'] = $viewbox[3];
            $attr['height'] = $viewbox[4];
        }
    }
/*	echo "<br> Test var: ------------------ <br>".$svg_url."<br>--------------------------- <br>".$svg_content.'<br>--------------------------- <br>';	print_r($attr); */
}
	return $attr;
}
add_filter('wp_get_attachment_image_attributes', 'solass_wp_set_svg_size', 10, 3);

/*
add_filter('wp_get_attachment_image_attributes', 'solass_wp_set_svg_size_wifth', 10, 3);
function solass_wp_set_svg_size_wifth($attr, $attachment, $size) {
    if ($attachment->post_mime_type == 'image/svg+xml') {
        // Замените значение атрибута width на желаемый размер
        $attr['width'] = '500px';
    }
    return $attr;
}
*/


# ----------------- Санитайзер 
# вызывается при загрузке svg-файлов на сервер
function solass_wp_sanitize_svg($svg) {
    // Список нежелательных атрибутов
    $unwanted_attrs = array(
        'onabort', 'onblur', 'onchange', 'onclick', 'ondblclick', 'onerror',
        'onfocus', 'onkeydown', 'onkeypress', 'onkeyup', 'onload', 'onmousedown',
        'onmousemove', 'onmouseout', 'onmouseover', 'onmouseup', 'onreset',
        'onresize', 'onscroll', 'onselect', 'onsubmit', 'onunload', 'script',
        'javascript'
    );
    // Удаление нежелательных атрибутов
    foreach ($unwanted_attrs as $attr) {
        $svg = str_replace($attr, '', $svg);
    }
    return $svg;
}


# Исправление MIME типа для SVG файлов.
add_filter( 'wp_check_filetype_and_ext', 'solass_wp_fix_svg_mime_type', 10, 5 );
function solass_wp_fix_svg_mime_type( $data, $file, $filename, $mimes, $real_mime = '' ){
	// WP 5.1 +
	if( version_compare( $GLOBALS['wp_version'], '5.1.0', '>=' ) ){ $dosvg = in_array( $real_mime, [ 'image/svg', 'image/svg+xml' ] ); }
	else { $dosvg = ( '.svg' === strtolower( substr( $filename, -4 ) ) ); }
	// mime тип был обнулен, поправим его
	// а также проверим право пользователя
	if( $dosvg ){
		// разрешим
		if( current_user_can('manage_options') ){ $data['ext']  = 'svg'; $data['type'] = 'image/svg+xml';	}
		// запретим
		else { $data['ext']  = false; $data['type'] = false; }
	}
	return $data;
}

# Формирует данные для отображения SVG как изображения в медиабиблиотеке.
add_filter( 'wp_prepare_attachment_for_js', 'solass_wp_show_svg_in_media_library' );
function solass_wp_show_svg_in_media_library( $response ) {
	if ( $response['mime'] === 'image/svg+xml' ) {
		// Без вывода названия файла
		$response['sizes'] = [
			'medium' => [
				'url' => $response['url'],
			],
			// при редактирования картинки
			'full' => [
				'url' => $response['url'],
			],
		];
	}
	return $response;
}




}