jQuery(document).ready(function ($) {
            var mediaFrame;

            // Добавление новых изображений
            $('#add-gallery-images').on('click', function () {
                if (mediaFrame) {
                    mediaFrame.open();
                    return;
                }

                mediaFrame = wp.media({
                    title: 'Виберіть зображення',
                    button: { text: 'Додати у галерею' },
                    multiple: true
                });

                mediaFrame.on('select', function () {
                    var images = mediaFrame.state().get('selection').map(function (attachment) {
                        attachment = attachment.toJSON();
                        return attachment.id;
                    });

                    images.forEach(function (imageId) {
                        var thumbnail = wp.media.attachment(imageId).attributes.sizes.thumbnail.url;
                        $('#gallery-images').append(`
                            <li data-id="${imageId}" class="gallery-photo" style="">
                                <img src="${thumbnail}" class="gallery-thumbnail" style="">
                                <span class="dashicons dashicons-dismiss remove-image" style=""></span>
                            </li>
                        `);
                    });

                    updateGalleryInput();

                    // Закрываем окно после добавления
                    mediaFrame.close();
                });

                mediaFrame.open();
            });

            // Удаление изображения
            $(document).on('click', '.remove-image', function () {
                $(this).closest('li').remove();
                updateGalleryInput();
            });

            // Изменение порядка изображений
            $('#gallery-images').sortable({
                update: function () {
                    updateGalleryInput();
                }
            });

            // Обновление скрытого поля
            function updateGalleryInput() {
                var ids = [];
                $('#gallery-images li').each(function () {
                    ids.push($(this).data('id'));
                });
                $('#gallery-input').val(ids.join(','));
            }
        });