<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Вихід, якщо доступ до нього прямий

// --------------------------------------------------------------------------------------------------------------- //
// ---------------------------- Добавляем поле для ввода ID страницы в настройках меню --------------------------- //
// --------------------------------------------------------------------------------------------------------------- //
if ( get_option( 'solass_wp_mega_menu', '' ) ) {

	
// Добавляем поля для флага "мегаменю" и выбора страницы
function solass_wp_add_mega_menu_fields($item_id, $item, $depth, $args) {
    $is_mega_menu = get_post_meta($item_id, '_is_mega_menu', true);
    $page_id = get_post_meta($item_id, '_menu_page_id', true);

    // Получаем все страницы для выпадающего списка
    $pages = get_posts(array(
        'post_type' => get_option( 'solass_wp_mega_menu', '' ), // Для страниц. Для записей замените на 'post'. Для постов включить сортировку по таксономиям
 /*       'tax_query' => array( // Фильтр по таксономии
            array(
                'taxonomy' => 'custom-taxonomy', // Укажите вашу таксономию
                'field'    => 'slug',
                'terms'    => 'desired-term', // Укажите нужный термин
            ),
        ), 
*/
        'posts_per_page' => -1, // Показываем все страницы
        'post_status' => array('draft','publish'), // Только опубликованные - 'publish'
        'orderby' => 'title', // Сортировка по названию
        'order' => 'ASC',
    ));
    ?>
    <p class="field-custom description description-wide">
        <label for="edit-menu-item-is-mega-menu-<?php echo $item_id; ?>">
            <input type="checkbox" id="edit-menu-item-is-mega-menu-<?php echo $item_id; ?>" name="menu-item-is-mega-menu[<?php echo $item_id; ?>]" value="1" <?php checked($is_mega_menu, '1'); ?> />
            <?php _e('Включити мегаменю'); ?>
        </label>
    </p>
    <p class="field-custom description description-wide">
        <label for="edit-menu-item-page-id-<?php echo $item_id; ?>">
            <?php echo __( 'Виберіть дизайн мега-меню з розділу', 'solass-wp'); ?> <a href="<?php echo admin_url('edit.php?post_type=' . get_option( 'solass_wp_mega_menu', '' ) ); ?>" target="_blank"><?php echo get_post_type_object(get_option( 'solass_wp_mega_menu', '' ))->labels->name; ?></a><br>
            <select id="edit-menu-item-page-id-<?php echo $item_id; ?>" class="widefat" name="menu-item-page-id[<?php echo $item_id; ?>]">
                <option value=""><?php echo __( 'Виберіть дизайн', 'solass-wp'); ?></option>
                <?php foreach ($pages as $page): ?>
                    <option value="<?php echo esc_attr($page->ID); ?>" <?php selected($page_id, $page->ID); ?>>
                        <?php echo esc_html($page->post_title); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </label>
    </p>
    <?php
}
add_action('wp_nav_menu_item_custom_fields', 'solass_wp_add_mega_menu_fields', 10, 4);

// Сохраняем параметры "мегаменю" и ID страницы
function solass_wp_save_mega_menu_fields($menu_id, $menu_item_db_id) {
    if (isset($_POST['menu-item-is-mega-menu'][$menu_item_db_id])) {
        update_post_meta($menu_item_db_id, '_is_mega_menu', '1');
    } else {
        delete_post_meta($menu_item_db_id, '_is_mega_menu');
    }

    if (isset($_POST['menu-item-page-id'][$menu_item_db_id])) {
        $page_id = sanitize_text_field($_POST['menu-item-page-id'][$menu_item_db_id]);
        update_post_meta($menu_item_db_id, '_menu_page_id', $page_id);
    } else {
        delete_post_meta($menu_item_db_id, '_menu_page_id');
    }
}
add_action('wp_update_nav_menu_item', 'solass_wp_save_mega_menu_fields', 10, 2);


function solass_wp_modify_mega_menu_output($items, $args) {
	// Сначала находим элементы, которые являются мегаменю
    $mega_menu_parents = [];
    foreach ($items as $item) {
        $is_mega_menu = get_post_meta($item->ID, '_is_mega_menu', true);
        $page_id = get_post_meta($item->ID, '_menu_page_id', true);
        if ($is_mega_menu && $page_id) {
            $mega_menu_parents[] = $item->ID; // Сохраняем ID пунктов с мегаменю
        }
    }
    // Убираем элементы, которые являются дочерними для мегаменю
    foreach ($items as $key => $item) {
        if (in_array($item->menu_item_parent, $mega_menu_parents)) {
            unset($items[$key]); // Удаляем дочерние элементы для мегаменю
        }
    }
	
    // Идем по всем пунктам меню
    foreach ($items as &$item) {
        // Проверяем, является ли пункт мегаменю
        $is_mega_menu = get_post_meta($item->ID, '_is_mega_menu', true);
        $page_id = get_post_meta($item->ID, '_menu_page_id', true);

            // Если это мегаменю
        if ($is_mega_menu && $page_id) {
            // Получаем контент страницы
            $page_content = get_post_field('post_content', $page_id);
			$formatted_content = $page_content;
            $formatted_content = apply_filters('the_content', $formatted_content);
            $formatted_content = do_shortcode($formatted_content);

            // Убираем стандартное подменю, если оно есть (очищаем дочерние элементы)
            $item->classes[] = 'mega-menu'; // Добавляем класс для мегаменю

            // Убираем детей (подменю) для этого пункта
            $item->children = [];

            // Добавляем контент мегаменю
            $item->mega_menu_content = '<ul class="sub-menu mega-menu-content"><li>' . $formatted_content . '</li></ul>';
        }
    }

    return $items;
}
add_filter('wp_nav_menu_objects', 'solass_wp_modify_mega_menu_output', 10, 2);

// Функция для добавления контента мегаменю в нужное место
function solass_wp_render_mega_menu($output, $item, $depth, $args) {
    // Проверяем, есть ли контент для мегаменю
    if (isset($item->mega_menu_content)) {
        // Добавляем контент мегаменю после основного элемента меню
        $output .= $item->mega_menu_content;
    }
	return $output;
}
add_filter('walker_nav_menu_start_el', 'solass_wp_render_mega_menu', 10, 4);


}