<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Вихід, якщо доступ до нього прямий
}

// --------------------- Функція увімкнення оновлення плагіну -------------------------- //

$huk_prioritet = swp_get_max_hook_priority('pre_set_site_transient_update_plugins');
add_action( 'pre_set_site_transient_update_plugins', 'solass_wp_display_update_message', 0 );
//add_action( 'site_transient_update_plugins', 'solass_wp_display_update_message' );
//add_action( 'init', 'solass_wp_display_update_message' ); // вызов для тестирования
function solass_wp_display_update_message($update_plugins) { 
	// Визначаємо ім'я плагіну
	$plugin_name = SOLASS_WP_PLUGIN_NAME; //dirname(plugin_basename(__FILE__));
	// слаг плагіна з основного файлу плагіна
	$plugin_slug = SOLASS_WP_PLUGIN_FILE; //plugin_basename( __FILE__ );
	// получаем данные всех плагинов и их параметров
	if( empty( $update_plugins ) ) { $update_plugins = get_site_transient( 'update_plugins' ); }
	
	//echo "--------------------------------------WP"; var_dump($update_plugins->checked[ $plugin_slug ]); echo "WP-------------------------------<br>";

	//Прерываем если не наш плагин 
	if ( empty( $update_plugins->checked[ $plugin_slug ] ) ) {  return $update_plugins; }
	if ( isset($update_plugins->no_update[ $plugin_slug ]->last_info) && ((int)($update_plugins->no_update[ $plugin_slug ]->last_info) + 60) > time() ) { return $update_plugins; }
	if ( isset($update_plugins->response[ $plugin_slug ]->last_info) && ((int)($update_plugins->response[ $plugin_slug ]->last_info) + 60) > time() ) { return $update_plugins; }

	// дані плагіна
	$plugin_url = WP_PLUGIN_DIR . '/' . $plugin_slug; //dirname(dirname(plugin_dir_path( __FILE__ ) ) )."/".$plugin_slug;
	$plugin_data = get_plugin_data( $plugin_url ); 

	// URL-адреса для перевірки оновлень 
	$remote_url = 'https://solass.com.ua/wp-content/uploads/shared-files/'.$plugin_name.'-version.php'; // URL удаленной папки
	$plagin_var = new stdClass(); 
	$args = new stdClass(); 
	$args->slug = $plugin_slug; 

	// Получаем данные о обновлении плагина
	$plagin_var = solass_wp_plugin_info_page( $plagin_var, 'plugin_information', $args );
    isset( $plagin_var->version ) ? $new_version = $plagin_var->version : $new_version = ''; // Новая версия плагина

    if ( version_compare( $plugin_data['Version'], $new_version, '<' ) ) {

      $message = __('Доступна нова версія плагіна! Будь ласка, оновіться до версії ', 'solass_wp') . $new_version;
        // Отмечаем плагин как требующий обновления
        $update_plugins = get_site_transient( 'update_plugins' );
        // Проверяем, что $update_plugins не равно false и является объектом
        if ( $update_plugins === false || !is_object( $update_plugins ) ) {
         // Если transient не существует или не является объектом, инициализируем его и response как новый объект
          $update_plugins = new stdClass(); $update_plugins->response = array();
        } elseif ( !isset($update_plugins->response) || !is_array($update_plugins->response) ) { $update_plugins->response = array(); }
        
        $update_plugins->response[ $plugin_slug ] = (object) array(
            'name' => $plugin_name,
            'slug' => $plugin_slug,
            'version' => $plugin_data['Version'],
            'new_version' => $plagin_var->version,
            'last_updated' => $plagin_var->last_updated,
            'download_link' => $plagin_var->download_link,
            'last_info' => time(),
            'package'     => $plagin_var->download_link,
			'icons'         => array(
				'1x' => $plagin_var->icons['low'],
				'2x' => $plagin_var->icons['high']
			),
        );
        set_site_transient( 'update_plugins', $update_plugins );
    } else { 

    // Удаляем сообщение плагина из списка требующих обновления
    if( empty( $update_plugins ) ) { $update_plugins = get_site_transient( 'update_plugins' ); }

    // Прерываем, если $update_plugins является false
    //if (!$update_plugins || !is_object($update_plugins)) { return $update_plugins;  }
    // Прерываем если не наш плагин
    //if (empty($update_plugins->checked[$plugin_slug])) { return $update_plugins; }
    //if (isset($update_plugins->no_update[$plugin_slug]->last_info) && ((int)($update_plugins->no_update[$plugin_slug]->last_info) + 60) > time()) {  return $update_plugins; }
    //if (isset($update_plugins->response[$plugin_slug]->last_info) && ((int)($update_plugins->response[$plugin_slug]->last_info) + 60) > time()) { return $update_plugins; }

		unset( $update_plugins->response[ $plugin_slug ] );
		isset( $plagin_var->last_updated ) ? $plagin_last_updated = $plagin_var->last_updated : $plagin_last_updated = '';
		isset( $plagin_var->download_link ) ? $plagin_download_link = $plagin_var->download_link : $plagin_download_link = '';
		isset( $plagin_var->icons['low'] ) ? $plagin_icons_low = $plagin_var->icons['low'] : $plagin_icons_low = '';
		isset( $plagin_var->icons['high'] ) ? $plagin_icons_high = $plagin_var->icons['high'] : $plagin_icons_high = '';
        $update_plugins->no_update[ $plugin_slug ] = (object) array(
            'name' => $plugin_name,
            'slug' => $plugin_slug,
            'version' => $plugin_data['Version'],
            'new_version' => $plugin_data['Version'],
            'last_updated' => $plagin_last_updated,
            'last_info' => time(),
            'download_link' => $plagin_download_link,
            'package'     => '',
			'icons'         => array(
				'1x' => $plagin_icons_low,
				'2x' => $plagin_icons_high
			),
        );
        set_site_transient( 'update_plugins', $update_plugins );
	}

return $update_plugins;

}

// -------- Функція отримання данних оновлення з серверу плагіна
add_filter( 'plugins_api', 'solass_wp_plugin_info_page', 20, 3);
/*
 * $res пусто на этом шаге
 * $action 'plugin_information'
 * $args stdClass Object ( [slug] => woocommerce [is_ssl] => [fields] => Array ( [banners] => 1 [reviews] => 1 [downloaded] => [active_installs] => 1 ) [per_page] => 24 [locale] => en_US )
 */
function solass_wp_plugin_info_page( $res, $action, $args ){
//print_r ($action);
//print_r ($args);
	// ничего не делать, если речь не идет о получении информации о плагине
	if( 'plugin_information' !== $action ) { return $res;  }
	// ничего не делать, если это не наш плагин
	if( SOLASS_WP_PLUGIN_FILE !== $args->slug ) { return $res; }
	// Визначаємо ім'я плагіну
	$plugin_name = SOLASS_WP_PLUGIN_NAME;
	$remote_url = 'https://solass.com.ua/wp-content/uploads/shared-files/'.$plugin_name.'-version.php'; // URL удаленной папки
	$ssl_url = ABSPATH  . WPINC . '/certificates/ca-bundle.crt'; 
	// Отключаем проверку SSL сертификатов	
	//add_filter('https_ssl_verify', '__return_false');
	//add_filter('https_local_ssl_verify', '__return_false');
	// ***-version.json это файл с фактической информацией о плагине на вашем сервере
	$remote = wp_remote_post( // wp_remote_get( 
		$remote_url, 
		array(
			'timeout' 			=> 45, 
			'body' 				=> null, // array('action'=>'version', 'action'=>'info') передаваемые параметры
//			'sslverify' 		=> false,
//			'sslcertificates' 	=> $ssl_url,
			'headers' => array(
				'Accept' => 'application/json'
			) 
		)
	);
	// Включаем обратноj проверку SSL сертификатов	
	//remove_filter('https_ssl_verify', '__return_false');
	//remove_filter('https_local_ssl_verify', '__return_false');

//	 print_r ($remote);
	// ничего не делать, если мы не получим правильный ответ от сервера
	if( 
		is_wp_error( $remote )
		|| 200 !== wp_remote_retrieve_response_code( $remote )
		|| empty( wp_remote_retrieve_body( $remote ) )
	) {
		return $res;	
	}

	$remote = json_decode( wp_remote_retrieve_body( $remote ) );
	
	$res = new stdClass();
	$res->name = $remote->name;
	$res->slug = $remote->slug;
	$res->author = $remote->author;
	$res->author_profile = $remote->author_profile;
	$res->version = $remote->version;
	if ( !empty( $remote->tested ) ) { $res->tested = $remote->tested; }
	$res->requires = $remote->requires;
	$res->requires_php = $remote->requires_php;
	$res->download_link = $remote->download_url;
	$res->trunk = $remote->download_url;
	$res->last_updated = $remote->last_updated;
	$res->sections = array(
		'description' => $remote->sections->description,
		'installation' => $remote->sections->installation,
		'changelog' => $remote->sections->changelog
		// you can add your custom sections (tabs) here
	);
	// если вам нужна вкладка со скриншотами, используйте следующий формат HTML для ее содержимого:
	// <ol><li><a href="IMG_URL" target="_blank"><img src="IMG_URL" alt="CAPTION" /></a><p>CAPTION</p></li></ol>
	if( ! empty( $remote->sections->screenshots ) ) {
		$res->sections[ 'screenshots' ] = $remote->sections->screenshots;
	}

	$res->banners = array(
		'low' => $remote->banners->low,
		'high' => $remote->banners->high
	);
	$res->icons = array(
		'low' => $remote->icons->low,
		'high' => $remote->icons->high
	);
	
	return $res;
}

function solass_wp_remote_post_test(){ 
	$remote = array();
	// Визначаємо ім'я плагіну
	$plugin_name = SOLASS_WP_PLUGIN_NAME;
	$remote_url = 'https://solass.com.ua/wp-content/uploads/shared-files/'.$plugin_name.'-version.php'; // URL удаленной папки
	$ssl_url = ABSPATH  . WPINC . '/certificates/ca-bundle.crt'; 
	$remote = wp_remote_post( // wp_remote_get( 
		$remote_url, 
		array(
			'timeout' 			=> 45, 
			'body' 				=> array('action'=>'version'), //null, // array('action'=>'version', 'action'=>'info') передаваемые параметры
			'headers' => array(
				'Accept' => 'application/json'
			) 
		)
	);
//	 print_r ($remote);
	// ничего не делать, если мы не получим правильный ответ от сервера
	if( 
		is_wp_error( $remote )
		|| 200 !== wp_remote_retrieve_response_code( $remote )
		|| empty( wp_remote_retrieve_body( $remote ) )
	) {	
		$send_info['test_error'] = 'yes';
		$send_info['version'] = '';
		$send_info['remote'] = $remote;
		return $send_info;	
	}
		$send_info['test_error'] = '';
		$send_info['version'] = $remote['body'];
		$send_info['remote'] = $remote;
		return $send_info;	
}



// ------------------------------------------------------------------------------------------------------------------------------ //
// ------------------------------------------------ Функція AJAX оновлення плагіну ---------------------------------------------- //
// ------------------------------------------------------------------------------------------------------------------------------ //

//  Для запуску виводу таблиці оновлення плагінів використовуйте функцію solass_wp_display_my_plugin_table...
/*      // Формуємо список плагінів
		$updates_plugins_arr = array(
        array(
            'name' => 'SOLASS Addons for WPBakery',
            'slug' => 'solass-addons',
            'server_version_url' => 'https://solass.com.ua/wp-content/uploads/shared-files/solass-addons-version.php',
        ),
        array(
            'name' => 'WPBakery',
            'slug' => 'js_composer',
            'server_version_url' => 'https://solass.com.ua/wp-content/uploads/shared-files/js_composer-version.php',
        ),
        array(
            'name' => 'Test-test',
            'slug' => 'te_test',
            'server_version_url' => 'https://solass.com.ua/wp-content/uploads/shared-files/test-version.php',
        ),
        // Можна додати інші необхідні для оновлення плагіни
    );
	// Запускаємо побудову таблиці списку плагінів для оновлення
	if ( function_exists('solass_wp_display_my_plugin_table') && !empty($updates_plugins_arr) ) { solass_wp_display_my_plugin_table($updates_plugins_arr); }
*/

/* ------------- Визначення кількості моїх плагінів для оновлення ---------------- */
function solass_wp_num_my_plugin_updates($updates_plugins_arr) {
    $plugin_data = solass_wp_check_my_plugin_versions($updates_plugins_arr);
	$num_my_plugin = array();
	$num_my_plugin['update'] = 0;
	$num_my_plugin['instal'] = 0;
	$num_my_plugin['activate'] = 0;
	$num_my_plugin['status'] = '';
    foreach ($plugin_data as $plugin) {
		$status_plagin = swp_status_plagin( $plugin['slug'] );
		$num_my_plugin['status'] = $status_plagin;
		if( $status_plagin ) { 
		if ($status_plagin == 2) { ( $plugin['update_needed'] ) ? $num_my_plugin['update'] = $num_my_plugin['update'] + 1 : $num_my_plugin['update'] = $num_my_plugin['update']; } else { $num_my_plugin['activate'] = $num_my_plugin['activate'] + 1; }
		} else { $num_my_plugin['instal'] = $num_my_plugin['instal'] + 1; }
    }
	 return $num_my_plugin;
}


/* ------------- Вивід таблиці плагінів ---------------- */
function solass_wp_display_my_plugin_table($updates_plugins_arr) { 
    $plugin_data = solass_wp_check_my_plugin_versions($updates_plugins_arr);

    echo '<style>.form-table .my-plugins-updates-table th, .form-table .my-plugins-updates-table td {padding: 8px 10px;} .form-table .my-plugins-updates-table .plugin-title{white-space: wrap;} .my-plugins-updates-table .dashicons-admin-plugins::before {font-size: 100% !important;}.button.solass-wp-update-plugin{min-width: 90px;text-align:center;}</style>';
    echo '<table class="my-plugins-updates-table wp-list-table widefat fixed striped table-view-list plugins" cellspacing="0">';
    echo '<thead><tr><td class="manage-column" style=" width: 40%">Плагін</td><td class="manage-column">Встановлена версія</td><td class="manage-column">Остання версія</td><td class="manage-column"></td></tr></thead>';
    echo '<tbody>';
    foreach ($plugin_data as $plugin) {
		if( !empty($plugin['plugin_icons_low']) && swp_file_exists_remote( $plugin['plugin_icons_low'] ) ) {
		$plagin_ico = '<img src="'.$plugin['plugin_icons_low'].'" width="45" height="45" class="updates-table-screenshot" style="max-height: 45px; max-width: 45px; ">'; 
		} else { $plagin_ico = '<span class="dashicons dashicons-admin-plugins" style="max-height: 45px; max-width: 45px; font-size: 45px;"></span>'; }
        echo '<tr>';
        echo '<td class="plugin-title align-left-center" style="margin: 0;">'.$plagin_ico.'<strong>' . esc_html($plugin['name']) . '</strong></td>';
        echo '<td>' . esc_html($plugin['installed_version']) . '</td>';
        echo '<td>' . esc_html($plugin['server_version']) . '</td>';
        echo '<td class="text-center"><div class="align-center-center" style="display: inline-flex;">';

		$status_plagin = swp_status_plagin( $plugin['slug'] );
		$update_info = ""; $text_info = "";
		if( $status_plagin ) { 
		if ($status_plagin == 2) { ( $plugin['update_needed'] ) ? $update_info = "Оновити" : $text_info = "Активовано"; } else { $text_info = '<span style="opacity: 0.4;">Не активовано</span>'; }
		} else { ( $plugin['server_version'] ) ? $update_info = "Встановити" : $text_info = '<span class="ne_ok">Не встановлено</span>'; }

        if ( $update_info ) { 
        $nonce = wp_create_nonce('swp_ajax_update_plugin_' . $plugin['slug']);
        echo '<a href="#" class="button solass-wp-update-plugin" data-plugin-slug="' . esc_attr($plugin['slug']) . '" data-nonce="' . esc_attr($nonce) . '" data-plugin-url="' . esc_html($plugin['download_url']) . '">'.$update_info.'</a>';
        } else {
            echo $text_info;
        }
        echo '</div></td>';
        echo '</tr>';
    }
    echo '</tbody>';
    echo '</table>';
}

/* ------------- Отримуємо дані плагінів ---------------- */
function solass_wp_check_my_plugin_versions($plugins) {
    $results = array();

    foreach ($plugins as $plugin) {
        //$installed_version = get_plugin_data(WP_PLUGIN_DIR . '/' . $plugin['slug'] . '/' . $plugin['slug'] . '.php')['Version'];
        //  $server_version = simplexml_load_file($plugin['server_version_url'])->version; // Для XML-файлів з даними
		$plugin_file = WP_PLUGIN_DIR . '/' . $plugin['slug'] . '/' . $plugin['slug'] . '.php';
		if (file_exists($plugin_file) && is_readable($plugin_file)) {
   		$plugin_data = get_plugin_data($plugin_file);
    	$installed_version = isset($plugin_data['Version']) ? $plugin_data['Version'] : '';
		} else {
    	$installed_version = ''; // или false/null
		}
        // Завантаження JSON даних з сервера SOLASS.com.ua
        $json_data = file_get_contents($plugin['server_version_url']);
        // Перетворення JSON в массив
        $plugin_data = json_decode($json_data, true);

        $plugin_name = !empty( $plugin_data['name']) ? $plugin_data['name'] : $plugin['name'];
        $server_version = !empty( $plugin_data['version']) ? $plugin_data['version'] : '';
        $download_url = !empty( $plugin_data['download_url']) ? $plugin_data['download_url'] : '';
        $results[] = array(
            'name' => $plugin_name,
            'slug' => $plugin['slug'],
            'installed_version' => $installed_version,
            'server_version' => $server_version,
            'download_url' => $download_url,
            'update_needed' => version_compare($installed_version, $server_version, '<'),
            'plugin_icons_low' => $plugin_data['icons']['low'],
        );
    }
    return $results;
}

/* ------------------- Запуск функції визиваємо у Ajax ----------------------- */
add_action('wp_ajax_swp_ajax_update_plugins', 'swp_ajax_update_plugin');

function swp_ajax_update_plugin() {
	// Проверка nonce
    $nonce = isset($_POST['nonce']) ? sanitize_text_field($_POST['nonce']) : '';
    $plugin_slug = isset($_POST['plugin_slug']) ? sanitize_text_field($_POST['plugin_slug']) : '';
    $plugin_url = isset($_POST['plugin_url']) ? esc_url_raw($_POST['plugin_url']) : '';

    if (!wp_verify_nonce($nonce, 'swp_ajax_update_plugin_' . $plugin_slug)) { wp_send_json_error('Запит не пройшов перевірку'); }
    if (empty($plugin_url)) { wp_send_json_error('Посилання на плагін відсутнє'); }

    // Логика обновления плагина
    // Здесь можно использовать wp_remote_get или другие функции для загрузки и установки плагина
    
    // Путь к папке плагина
    $plugin_dir = WP_PLUGIN_DIR . '/' . $plugin_slug;
    // Скачать архив с плагином
    $response = wp_remote_get($plugin_url, array('timeout' => 300));
    if (is_wp_error($response)) {  wp_send_json_error('Помилка завантаження плагіна - ' . $response->get_error_message());  }

    $body = wp_remote_retrieve_body($response);
    $temp_file = wp_tempnam($plugin_url);
    if (!$temp_file) { wp_send_json_error('Помилка створення тимчасового файлу'); }
    file_put_contents($temp_file, $body);

    // Распаковать архив
    if (!class_exists('WP_Filesystem_Direct')) {
        require_once(ABSPATH . 'wp-admin/includes/file.php');
    }
    WP_Filesystem();

    $unzip_result = unzip_file($temp_file, WP_PLUGIN_DIR);
    unlink($temp_file); // Удалить временный файл 
	
    if (is_wp_error($unzip_result)) { wp_send_json_error('Помилка розпакування - ' . $unzip_result->get_error_message());  }
    // Проверка успешности обновления
    if (is_dir($plugin_dir)) { wp_send_json_success('Плагін оновлено'); update_option('swp_new_plugin_updates', 'on');  } else {  wp_send_json_error('Плагін не вдалося оновити');  }    
 
}