<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Вихід, якщо доступ до нього прямий
}

// --------------------------------------------------------------------------------------------- //
// ------------------- Функция добавления/обновления правила в .htaccess ----------------------- //
// --------------------------------------------------------------------------------------------- //

// --------------- Додаємо мітку правил SOLASS WPSettings на початок файлу .htaccess
function solass_wp_htaccess_marker() {
$new_rules = "
# BEGIN SOLASS WPSettings
# Directives (lines) between `BEGIN SOLASS WPSettings` and `END SOLASS WPSettings`
# are created automatically and can only be changed through WordPress filters.
# Changes made manually between these markers will be overwritten.

# END SOLASS WPSettings

";
    // Отримайте вміст файлу .htaccess
    $htaccess_file = ABSPATH . '.htaccess';
    $htaccess_contents = file_get_contents($htaccess_file);
    // Перевірте, чи спеціальні правила вже існують у файлі .htaccess
    if (strpos($htaccess_contents, 'BEGIN SOLASS WPSettings') !== false && strpos($htaccess_contents, '# END SOLASS WPSettings') !== false) {
        return;
    }
    // Якщо спеціальні правила не існують, додайте їх на початок файлу .htaccess
    $new_htaccess_contents = $new_rules . $htaccess_contents;
    file_put_contents($htaccess_file, $new_htaccess_contents);
}

add_action('init', 'solass_wp_htaccess_marker');


// ----------------------------------------------------------------------------------------------- //
// -------------------------- Формування правил в файлі .htaccess -------------------------------- //
// ----------------------------------------------------------------------------------------------- //
// 

function solass_wp_add_htaccess() { 
global $wp_rewrite; //, $submenu, $typenow
// $my_typenow_screen = get_current_screen(); $my_typenow_submit = $my_typenow_screen->id; if (isset($_POST['submit'])) { }

// ---------- Массив страниц в которых производить записи. ------------------// 
// Если массив пустой, то производятся попытки записи на всех страницах плагина
$array_page = array('solass-wp-settings-safe', 'solass-wp-settings-htaccess'); 

$my_typenow = sanitize_key($_GET['page']);
$my_typenow = isset($my_typenow) ? $my_typenow : '';
$prev_page = $_SERVER['HTTP_REFERER'];
parse_str(parse_url($prev_page, PHP_URL_QUERY), $params);
$my_prev_typenow = $params['page'];

//if ( $my_typenow == $my_prev_typenow && ( in_array($my_typenow, $array_page) || empty($array_page) ) ) { // Если совпадают значения, значит повторное посещение или запись данных на странице 
if ( in_array($my_typenow, $array_page) ) { // Если совпадают значения, значит повторное посещение или запись данных на странице 

$Rulesstring = "";
$login_changes_htaccess = "";
if ( is_file(ABSPATH . '.htaccess') ) { // Проверяем существует ли файл .htaccess
$htaccess = ABSPATH . '.htaccess'; $lines = array(); $rules = "";
if ( esc_attr( get_option( 'solass_wp_login_url', '' ) ) ) { 
$Rulesstring = $Rulesstring.'';
}

if ( esc_attr( get_option( 'solass_wp_htaccess_redirect_page', '' ) ) || 
   	 esc_attr( get_option( 'solass_wp_htaccess_redirect', '' ) ) || 
     esc_attr( get_option( 'solass_wp_htaccess_www', '' ) ) || 
     esc_attr( get_option( 'solass_wp_htaccess_slesh', '' ) ) || 
     esc_attr( get_option( 'solass_wp_htaccess_index', '' ) ) || 
   	 esc_attr( get_option( 'solass_wp_htaccess_https', '' ) ) || 
	( esc_attr( get_option( 'solass_wp_custom_login', '' )) && esc_attr( get_option( 'solass_wp_login_url', '' ) ) )
   ) { 
$Rulesstring = $Rulesstring.'
############################################################################
#### '.esc_html__( 'Базовий .htaccess для веб-ресурсів (використовується SOLASS.com.ua)', 'solass-wp' ).'
############################################################################
   #  '.esc_html__( 'Директива включає редиректи', 'solass-wp' ).'
RewriteEngine On
   # '.esc_html__( 'Без директиви (.*) = /$1 буде /var/wwww/site/web/$1  з дерективою  = /$1', 'solass-wp' ).'
RewriteBase / 
   # '.esc_html__( 'Дозволяє перехід за символічними посиланнями', 'solass-wp' ).'
#Options +FollowSymLinks
';


if ( esc_attr( get_option( 'solass_wp_custom_login', '' )) && esc_attr( get_option( 'solass_wp_login_url', '' ) ) ) {
$site_url_litle = esc_attr( get_option( 'siteurl', '' ) );
$zamena_http = array('http://', 'https://');
$site_url_litle = str_ireplace($zamena_http, '', $site_url_litle);

$Rulesstring = $Rulesstring.'
############################################################################
####  '.esc_html__( 'Додаємо правила для зміни адреси входу у адмін-систему', 'solass-wp' ).'
############################################################################
';
$Rulesstring = $Rulesstring.'
# '.esc_html__( 'Обмеження входу у адмін-систему за допомогою ручного запиту', 'solass-wp' ).'
ErrorDocument 401 /'.$site_url_litle.'/index.php?error=404
ErrorDocument 403 /'.$site_url_litle.'/index.php?error=404
<IfModule mod_rewrite.c>
RewriteEngine on
RewriteCond %{REQUEST_METHOD} POST
RewriteCond %{HTTP_REFERER} !^http://(.*)?'.$site_url_litle.' [NC]
#RewriteCond %{REQUEST_URI} ^(.*)?wp-login\.php(.*)$ [OR]
RewriteCond %{REQUEST_URI} ^wp-login\.php$ [OR]
#RewriteCond %{REQUEST_URI} ^(.*)?wp-admin$
RewriteCond %{REQUEST_URI} ^wp-admin$
RewriteRule ^(.*)$ - [F]
</IfModule>
';

$Rulesstring = $Rulesstring.'
RewriteRule ^index\.php$ - [L]
RewriteBase /
RewriteRule ^'.esc_attr( get_option( 'solass_wp_login_url', '' ) ).'$ wp-login.php [QSA,L]
';
}

if ( esc_attr( get_option( 'solass_wp_htaccess_redirect_page', '' ) ) ) {
$login_changes_htaccess = $login_changes_htaccess.'<li>'.__( 'Включений редірект для сторінок сайту', 'solass-wp').'</li>';
$Rulesstring = $Rulesstring.'
############################################################################
####  '.esc_html__( '301 Редірект сторінок (зміна адреси сторінки)', 'solass-wp' ).'
############################################################################
#Redirect 301 /ru/text.php?pid=1 https://solass.com.ua/o-studii-dizayna-solass/
';
}

if ( esc_url( get_option( 'solass_wp_htaccess_redirect', '' ) ) ) {
$redirect_url = esc_url( get_option( 'solass_wp_htaccess_redirect', '' ) );
$zamena_var = array('http://', 'https://');
$redirect_url = str_ireplace($zamena_var, '', $redirect_url);
$redirect_url = str_ireplace('.', '\.', $redirect_url); 
$site_url = esc_attr( get_option( 'siteurl', '' ) );
if($redirect_url && $site_url) {
$login_changes_htaccess = $login_changes_htaccess.'<li>'.esc_html__( 'Сайт '.str_ireplace('\.', '.', $redirect_url).' перенаправлений на '.$site_url, 'solass-wp').'</li>';
$Rulesstring = $Rulesstring.'
############################################################################
####    '.esc_html__( '301 Редірект доменів старої адреси сайту', 'solass-wp' ).'
############################################################################
RewriteCond %{HTTP_HOST} ^'.$redirect_url.'
RewriteRule ^(.*)$ '.$site_url.'/$1 [R=301,L]
';
}
}

if ( esc_attr( get_option( 'solass_wp_htaccess_www', '' ) ) ) { 
$login_changes_htaccess = $login_changes_htaccess.'<li>'.__( 'Адреса сайту встановлена без використання WWW', 'solass-wp').'</li>';
$Rulesstring = $Rulesstring.'
############################################################################
#### '.esc_html__( 'Основне дзеркало сайту (Редірект з www на без www)', 'solass-wp' ).'
############################################################################
   # '.esc_html__( 'Перевіряємо, чи містить домен www (на початку URL)', 'solass-wp' ).'
RewriteCond %{HTTP_HOST} ^www\.(.*) [NC]
   # '.esc_html__( 'Перенаправляємо URL на домен без www', 'solass-wp' ).'
RewriteRule ^(.*)$ %{REQUEST_SCHEME}://%1/$1 [R=301,L]
';
// Для перевірки параметрів можна додати до URL: 
// ?_http_host=%{HTTP_HOST}gr1=%1&gr2=%2&scheme=%{REQUEST_SCHEME}&https=%{HTTPS}
/*
   # Редирект без www на www.
#RewriteCond %{HTTP_HOST} !^www\.(.*) [NC]
#RewriteRule ^(.*)$ https://www.%{HTTP_HOST}/$1 [R=301,L]
*/
}

if ( esc_attr( get_option( 'solass_wp_htaccess_https', '' ) ) ) { 
$login_changes_htaccess = $login_changes_htaccess.'<li>'.__( 'Перенаправлено протокол http на https', 'solass-wp').'</li>';
$Rulesstring = $Rulesstring.'
############################################################################
#### '.esc_html__( 'Перенаправляємо протокол http на https', 'solass-wp' ).'
############################################################################
RewriteCond %{HTTPS} =off
RewriteRule (.*) https://%{HTTP_HOST}%{REQUEST_URI} [QSA,L]
';
}
/*
   # Перенаправляем протокол https на http
#RewriteCond %{HTTPS} on
#RewriteRule ^.*$ http://%{SERVER_NAME}%{REQUEST_URI}
*/

if ( esc_attr( get_option( 'solass_wp_htaccess_slesh', '' ) ) ) { 
$login_changes_htaccess = $login_changes_htaccess.'<li>'.__( 'Проведені коррекції адрес сторінок з урахуванням слешів (/)', 'solass-wp').'</li>';
$Rulesstring = $Rulesstring.'
############################################################################
#### '.esc_html__( 'Прибираємо повторювані слеші (/) в URL', 'solass-wp' ).' 
############################################################################
   # '.esc_html__( 'Перевіряємо, чи повторюється слєш (//) більше двох разів', 'solass-wp' ).'
RewriteCond %{REQUEST_URI} ^(.*)/{2,}(.*)$
   # '.esc_html__( 'Виключаємо всі зайві сліші', 'solass-wp' ).'
RewriteRule . %1/%2 [R=301,L]

############################################################################
#### '.esc_html__( 'Забираємо слеши в кінці URL для статичних файлів (містить точку)', 'solass-wp' ).'  
############################################################################
   # '.esc_html__( 'Файл що містить крапку', 'solass-wp' ).'
RewriteCond %{REQUEST_URI} \..+$  
   # '.esc_html__( 'Це дирикторія', 'solass-wp' ).'
RewriteCond %{REQUEST_FILENAME} !-d   
   # '.esc_html__( 'Це файл', 'solass-wp' ).'
RewriteCond %{REQUEST_FILENAME} -f
   # '.esc_html__( 'В кінці URL є слеш', 'solass-wp' ).'
RewriteCond %{REQUEST_URI} ^(.+)/$      
   # '.esc_html__( 'Видалити слеш', 'solass-wp' ).'
RewriteRule ^(.+)/$ /$1 [R=301,L]     

############################################################################
#### '.esc_html__( 'Додаємо слеш(/), якщо його немає, і це не файл', 'solass-wp' ).'                    
############################################################################
   # '.esc_html__( 'Є слеш у кінці', 'solass-wp' ).'
RewriteCond %{REQUEST_URI} !(.*)/$
   # '.esc_html__( 'Не файл', 'solass-wp' ).'
RewriteCond %{REQUEST_FILENAME} !-f
   # '.esc_html__( 'В URL немає крапки (файл)', 'solass-wp' ).'
RewriteCond %{REQUEST_URI} !\..+$
   # '.esc_html__( 'Слеш без помилок у адмінці та JSON API', 'solass-wp' ).'
#RewriteCond %{REQUEST_URI} !^/wp-json
#RewriteCond %{REQUEST_URI} !^/wp-admin
#RewriteCond %{REQUEST_URI} !^/([_0-9a-zA-Z-]+)/wp-json
#RewriteCond %{REQUEST_URI} !^/([_0-9a-zA-Z-]+)/wp-admin
RewriteCond %{REQUEST_URI} !(.*)/wp-json
RewriteCond %{REQUEST_URI} !(.*)/wp-admin
RewriteCond %{REQUEST_URI} !(.*)/([_0-9a-zA-Z-]+)/wp-json
RewriteCond %{REQUEST_URI} !(.*)/([_0-9a-zA-Z-]+)/wp-admin

   # '.esc_html__( 'Додаємо слеш наприкінці', 'solass-wp' ).'
RewriteRule ^(.*)$ $1/ [L,R=301]
';
}

if ( esc_attr( get_option( 'solass_wp_htaccess_index', '' ) ) ) { 
$login_changes_htaccess = $login_changes_htaccess.'<li>'.__( 'Вивід index.php у адресі сторінок відключено', 'solass-wp').'</li>';
$Rulesstring = $Rulesstring.'
############################################################################
#### '.esc_html__( 'Відключаємо вивід index.php, якщо він є в кінці URL (чогось не спрацьовує)', 'solass-wp' ).'
############################################################################
   # '.esc_html__( 'Виявляємо GET запит у URL (не POST)', 'solass-wp' ).'
#RewriteCond %{REQUEST_METHOD} =GET
   # '.esc_html__( 'URL включає index.php у кінці', 'solass-wp' ).'
#RewriteCond %{REQUEST_URI} ^(.*)/index\.php$
   # '.esc_html__( 'Видалити index.php з URL', 'solass-wp' ).'
#RewriteRule ^(.*)$ %1/ [R=301,L]
';
}


}



/*
Код, запрещающий отслеживание HTTP заголовков:

RewriteEngine On
RewriteCond %{REQUEST_METHOD} ^TRACE
RewriteRule .* — [F]

Код, защищающий от SQL-инъекций – самый распространенный вид атак на WordPress сайты:

RewriteCond %{QUERY_STRING} (\<|%3C).*script.*(\>|%3E) [NC, OR]
RewriteCond %{QUERY_STRING} GLOBALS(=|\[|\%[0 — 9A-Z]{0, 2}) [OR]
RewriteCond %{QUERY_STRING} _REQUEST(=|\[|\%[0 — 9A-Z] {0,2})
RewriteRule ^(.*)$ index.php [F.L]

Код, который не даст просмотреть папки на вашем сервере, набрав их полный путь:

Options –Indexes

Например, набрав в браузере http://yourdomain.com/wp-includes, вы увидите всё содержимое папки «wp-includes», что, конечно же, не является безопасным. С этим кодом пользователи увидят ответ от сервера — 403 Forbidden.

Альтернативным методом скрытия подпапок, является создание пустого index.php файла в каждой директории. Таким образом, при открытии http://yourdomain.com/wp-includesбраузер отобразит пустую страницу.

Код, который защищает от использования XSS-инъекций и попытки модифицировать переменные GLOBALS и _REQUEST:

Options +FollowSymLinks
RewriteEngine On
RewriteCond %{QUERY_STRING} (\<|%3C).*script.*(\>|%3E) [NC,OR]
RewriteCond %{QUERY_STRING} GLOBALS(=|\[|\%[0-9A-Z]{0,2}) [OR]
RewriteCond %{QUERY_STRING} _REQUEST(=|\[|\%[0-9A-Z]{0,2})
RewriteRule ^(.*)$ index.php [F,L]

Для этой же цели можно использовать ряд WordPress плагинов, которые вы сможете найти здесь: wordpress.org/plugins/tags/xss

Код, который блокирует доступ к директории /wp-content:

Order deny,allow
Deny from all
<files ~ «.(xml|css|jpe?g|png|gif|js)$»>
Allow from all
</files>

Эта папка является одной из самых важных, поскольку содержит темы, плагины, изображения и прочий контент.

Код, защищающий от хотлинкинга:

RewriteEngine On
RewriteCond %{HTTP_REFERER} !^http://(.+\.)?yourdomain\.com/ [NC]
RewriteCond %{HTTP_REFERER} !^$
RewriteRule .*\.(jpe?g|gif|bmp|png)$ /images/nohotlink.jpg [L]

Хотлинкинг – это вставка изображения с вашего сервера на чужой сайт\блог. Трафик же при этом идет непосредственно на ваш сервер.

При помощи кода, указанного выше, вы можете заставить сервер проверить, откуда именно пришел запрос: если со страниц вашего веб-сайта, то сервер отдает изображение пользователю без проблем; если же с чужого веб-сайта – то показывает изображение с ошибкой.

*/




/*
#RewriteRule ^'.esc_attr( get_option( 'solass_wp_login_url', '' ) ).'/?$ wp-login.php
*/
/*
//function block_login_pages() {  }
    $htaccess_ = ABSPATH.'.htaccess';
    $rules = "# Block access to login pages\n";
    $rules .= "<Files wp-login.php>\n";
    $rules .= "Order Deny,Allow\n";
    $rules .= "Deny from All\n";
    $rules .= "Allow from 127.0.0.1\n";
    $rules .= "</Files>\n";

    if (file_exists($htaccess_) && $rules) {
        $content = file_get_contents($htaccess_);
        if (strpos($content, '# Block access to login pages') === false) {
            $content .= "\n".$rules;
            file_put_contents($htaccess_, $content);
        }
    } elseif (!$rules) { 
    if (file_exists($htaccess_)) {
        $content = file_get_contents($htaccess_);
        $content = str_replace("# Block access to login pages\n", "", $content);
        file_put_contents($htaccess_, $content);
    }
	}

*/

/*
RewriteBase /
RewriteRule ^'.esc_attr( get_option( 'solass_wp_login_url', '' ) ).'$ wp-login.php
<IfModule mod_rewrite.c>
RewriteEngine On
 
RewriteRule ^'.esc_attr( get_option( 'solass_wp_login_url', '' ) ).'/?$ /wp-login.php?bc3a56c44bc8932d51b [R,L]
 
RewriteCond %{HTTP_COOKIE} !^.*wordpress_logged_in_.*$
RewriteRule ^'.esc_attr( get_option( 'solass_wp_login_url', '' ) ).'/?$ /wp-login.php?bc3a56c44bc8932d51b&amp;redirect_to=/wp-admin/ [R,L]
 
RewriteRule ^'.esc_attr( get_option( 'solass_wp_login_url', '' ) ).'/?$ /wp-admin/?bc3a56c44bc8932d51b [R,L]
 
RewriteCond %{SCRIPT_FILENAME} !^(.*)admin-ajax\.php
RewriteCond %{HTTP_REFERER} !^(.*)%{SERVER_NAME}/wp-admin
RewriteCond %{HTTP_REFERER} !^(.*)%{SERVER_NAME}/wp-login\.php
RewriteCond %{HTTP_REFERER} !^(.*)%{SERVER_NAME}/adminka
RewriteCond %{QUERY_STRING} !^secretka
RewriteCond %{QUERY_STRING} !^action=logout
RewriteCond %{QUERY_STRING} !^action=rp
RewriteCond %{QUERY_STRING} !^action=postpass
RewriteCond %{HTTP_COOKIE} !^.*wordpress_logged_in_.*$
RewriteRule ^.*wp-admin/?|^.*wp-login\.php /not_found [R,L]
 
RewriteCond %{QUERY_STRING} ^loggedout=true
RewriteRule ^.*$ /wp-login.php?bc3a56c44bc8932d51b [R,L]
</IfModule>
*/

$lines = explode( "\n", $Rulesstring ); // розбиваем правила на массив строк

insert_with_markers($htaccess, "SOLASS WPSettings", $lines); // Добавляем правила в файл .htaccess (последний параметр false, если вверху )

$wp_rewrite->flush_rules(); // обновление правил перезаписи
}
}
	return $login_changes_htaccess;
}

/*
// -------- Проверка совпадения страницы на присутствие в меню базового плагина 
$my_typenow = sanitize_key($_GET['page']);
$my_typenow = isset($my_typenow) ? $my_typenow : '';
$sovpadenie_menu = "";
$links = array();
    if (isset($submenu[dirname(plugin_basename(__FILE__),2)])) {
        foreach ($submenu[dirname(plugin_basename(__FILE__),2)] as $key => $item) {
            $name = $item[0]; $slug = $item[2]; 
			if (!array_key_exists($slug, $links)) { // Проверяем, есть ли уже такой пункт в массиве
            if ($slug === $my_typenow) { $sovpadenie_menu = dirname(plugin_basename(__FILE__), 2);  }; $links[$slug] = $name;
            }
        }
    }
*/

