//const { __, _x, _n, _nx } = wp.i18n; // Выдает ошибку если такие же переменные встречаются в других плагинах. 
// Поэтому вызываем самозапускающуюся функцию с этими параметрами внутри
(function() {
const { __, _x, _n, _nx } = wp.i18n;

/* Функція вибору зображення з медіабібліотеки */

jQuery(document).ready(function($) {

	// Функція перевірки типу файлу по його URL та видачі ПРЕВЬЮ
	function swp_PREWgetCorrectFileUrl(fileUrl) {
    // Получаем расширение файла из URL
    const fileExtension = fileUrl.url.split('.').pop().toLowerCase(); 
    // Список допустимых расширений для изображений
    const imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'svg'];
    // Проверяем, является ли файл изображением
    if (imageExtensions.includes(fileExtension)) {
        return fileUrl.sizes.thumbnail.url; // Возвращаем превью изображения
    } else {
        // Возвращаем URL изображения документа, если файл не является изображением
        var origin = window.location.origin;
        return origin+'/wp-content/plugins/solass-wp-settings/images/ico-doc.svg';
    }
	}
	
	// Функція перевірки типу файлу по його URL та видачі ПРЕВЬЮ
	function swp_urlPREWgetCorrectFileUrl(fileUrl) {
    // Получаем расширение файла из URL
    const fileExt = fileUrl.split('.').pop().toLowerCase(); 
    // Список допустимых расширений для изображений
    const imageExt = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'svg'];
    // Проверяем, является ли файл изображением
    if (imageExt.includes(fileExt)) {
        return fileUrl; // Возвращаем исходный URL, если это изображение
    } else {
        // Возвращаем URL изображения документа, если файл не является изображением
        var origin = window.location.origin;
        return origin+'/wp-content/plugins/solass-wp-settings/images/ico-doc.svg';
    }
	}
	
	// Функції обробки даних форми завантаження файлу в "Додаткових параметрах товару"
	    var frame_file;
		var parentContainer;
            $('.swp_upload_file_button').on('click', function(e){
                e.preventDefault();
				parentContainer = $(this).parent();
                if (frame_file) {
                    frame_file.open();
                    return;
                }
                frame_file = wp.media({
            	title: __( 'Виберіть файл', 'solass-wp'), 
            	button: { text: __( 'Обрати файл', 'solass-wp') }, 
            	multiple: false
                });
                frame_file.on('select', function() { 
                    var attachment = frame_file.state().get('selection').first().toJSON();
                    //$('.prod_file_upload').val(attachment.url);
					parentContainer.find('.prod_file_upload').val(attachment.url);
					//fileUrl = attachment.sizes.thumbnail.url; 
					var fileUrl = swp_PREWgetCorrectFileUrl(attachment); //attachment.sizes.thumbnail.url
					
					//parentDivElement.find('.prew_load_img').attr("src", "");
					//parentDivElement.find('.attached_images').css('display','none');
					
                    parentContainer.find('.dell_upload_file').find('.swp_remove_file_button').css('display','inherit');
                    parentContainer.find('.dell_upload_file').find('.swp_upload_file_name').css('display','none');
                    parentContainer.find('.term-image-wrapper').find('img').attr("src", fileUrl);
					//.html('<img src="'+fileUrl+'" alt="" class="inner_images" style="overflow: hidden; vertical-align: middle;"/>');
                });
                frame_file.open();
            });

            // Видалення файлу
            $('.swp_remove_file_button').on('click', function(e){
                e.preventDefault();
     		    var origin_url = window.location.origin;
				var parentContainer_dell = $(this).parent();
				var start_prod_file_upload = parentContainer_dell.siblings('.start_prod_file_upload').val();
				//alert(start_prod_file_upload);
				//parentContainer_dell.find('.prod_file_upload').val('');
                //$(this).siblings('.prod_file_upload').val(''); //Елементи на одному рівні з активним елементом
                parentContainer_dell.siblings('.prod_file_upload').val('');
				if( start_prod_file_upload ) {  
				$(this).css('display','none'); 
				$(this).siblings('.swp_upload_file_name').css('display','inherit'); 
				} else { $(this).siblings('.swp_upload_file_name').css('display','none'); $(this).css('display','none'); }
                parentContainer_dell.siblings('.term-image-wrapper').find('img').attr("src", origin_url+'/wp-content/plugins/solass-wp-settings/images/ico-doc-dell.svg');
				//.html('<img src="'+origin_url+'/wp-content/plugins/solass-wp-settings/images/ico-doc-dell.svg" alt="" class="inner_images" style="width: 30px; height: 30px; overflow: hidden; vertical-align: middle;"/>');
             });

            // Відновлення файлу
            $('.swp_upload_file_name').on('click', function(e){
                e.preventDefault();
				var parentContainer_undo = $(this).parent();
				var start_prod_file_upload = parentContainer_undo.siblings('.start_prod_file_upload').val(); 
				var start_prod_file_upload_prew = parentContainer_undo.siblings('.start_prod_file_upload_prew').val(); 
				var prew_fileUrl = swp_urlPREWgetCorrectFileUrl(start_prod_file_upload_prew); 
				var parts = start_prod_file_upload.split('/');
				var prew_fileName = parts[parts.length - 1];
                parentContainer_undo.siblings('.prod_file_upload').val(start_prod_file_upload);
				if( start_prod_file_upload ) {  
				$(this).siblings('.swp_remove_file_button').css('display','inherit');
				$(this).css('display','none');
				} else { $(this).css('display','none'); }
                parentContainer_undo.siblings('.term-image-wrapper').find('img').attr("src", prew_fileUrl);
				//.html('<img src="'+prew_fileUrl+'" class="inner_images" style="overflow: hidden; vertical-align: middle;"/>');
             });



});

/*------------ Скрипт завантаження файла для зареєстрованих користувачів -----------*/
(function($) {
jQuery(window).on('load', function () {

	// Функція перевірки типу файлу по його URL та видачі ПРЕВЬЮ
	function swp_urlPREWgetCorrectFileUrl(fileUrl) {
    // Получаем расширение файла из URL
    const fileExt = fileUrl.split('.').pop().toLowerCase(); 
    // Список допустимых расширений для изображений
    const imageExt = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'svg'];
    // Проверяем, является ли файл изображением
    if (imageExt.includes(fileExt)) {
        return fileUrl; // Возвращаем исходный URL, если это изображение
    } else {
        // Возвращаем URL изображения документа, если файл не является изображением
        var origin = window.location.origin;
        return origin+'/wp-content/plugins/solass-wp-settings/images/ico-doc.svg';
    }
	}


    // Обработать перетаскивание файла
    $('.file-upload-interface').on('dragover', function (e) {
        e.preventDefault();
        e.stopPropagation();
        //$(this).css('background-color', 'rgba(0, 0, 0, 0.05)');
		$(this).addClass('dragover_on'); // Добавить
	});

    $('.file-upload-interface').on('dragleave', function (e) {
        e.preventDefault();
        e.stopPropagation();
        //$(this).css('background-color', 'transparent');
		$(this).removeClass('dragover_on'); // Удалить
    });

    $('.file-upload-interface').on('drop', function (e) {
        e.preventDefault();
        e.stopPropagation();
        //$(this).css('background-color', 'transparent');
		$(this).removeClass('dragover_on'); // Удалить
		var swp_fileInput = $(this).find('.upload-file-input');
        var files = e.originalEvent.dataTransfer.files;
        if (files.length > 0) {
            swp_fileInput[0].files = files;
            swp_SLMhandleFileUpload(files[0],$(this));
        }
    });
	
	
	$('.del_drag_file').on('click', function(e){
                e.preventDefault();
				var parentContainer = $(this).parent().parent();
                parentContainer.find('.file-url').val('');
                parentContainer.css('background','linear-gradient(rgba(256, 256, 256, 0.8), rgba(256, 256, 256, 0.8)), transparent center');
                parentContainer.css('background-size','cover');
	});
	
	$('.select-file-button').on('click', function(e){
                e.preventDefault();
				var frame_file;
				var parentContainer = $(this).parent().parent();
                if (frame_file) {
                    frame_file.open();
                    return;
                }
                frame_file = wp.media({
            	title: __( 'Виберіть файл', 'solass-wp'), 
            	button: { text: __( 'Обрати файл', 'solass-wp') }, 
            	multiple: false
                });
                frame_file.on('select', function() { 
                    var attachment = frame_file.state().get('selection').first().toJSON();
					parentContainer.find('.file-url').val(attachment.url);
					var fileUrl = swp_urlPREWgetCorrectFileUrl(attachment.url); //attachment.sizes.thumbnail.url
                    parentContainer.css('background','linear-gradient(rgba(256, 256, 256, 0.8), rgba(256, 256, 256, 0.8)), url('+fileUrl+') center');
                    parentContainer.css('background-size','cover');

                });
                frame_file.open();
    });

	
    // Загрузить файл
    function swp_SLMhandleFileUpload(file,activeElement) {
        var formData = new FormData();
        formData.append('file', file);
        formData.append('action', 'drag_upload_file');
        formData.append('nonce', uploadAjax.nonce);

        $.ajax({
            url: uploadAjax.ajax_url,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function (response) {
                if (response.success) { 
					var fileUrl = swp_urlPREWgetCorrectFileUrl(response.data.url);
                    activeElement.find('.file-url').val(response.data.url);
                    activeElement.css('background','linear-gradient(rgba(256, 256, 256, 0.8), rgba(256, 256, 256, 0.8)), url('+fileUrl+') center');
                    activeElement.css('background-size','cover');
					//activeElement.siblings('.prew-foto-img').attr("src",response.data.url);
                    activeElement.find('.upload-button').prop('disabled', false);
                } else {
                  alert(response.data.message);
                }
            },
            	error: function () {
                alert('Помилка завантаження.');
            },
        });
    }

});

})(jQuery);


// Конец самозапускающейся функции
})()