<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Вихід, якщо доступ до нього прямий
}

//@ini_set ('max_execution_time', '200') ;


// --------------------------------------------------------------------------------------------- //
// --------------------- Додавання власного меню плагіну у адмін тулбар ------------------------ //
// --------------------------------------------------------------------------------------------- //
// --------------------------- Добавляет ссылку в админ бар ------------------------------------ //

if( !get_option( 'solass_wp_menu_off', '' ) ) {
if (!function_exists('solass_wp_admin_bar_menu')) { 
function solass_wp_admin_bar_menu( $wp_admin_bar ) {
	$wp_admin_bar->add_menu( array(
		'id'    => 'admin_bar_menu_solass_wp_settings',
		'title' => '<div class="solass-logo svg alfa"><span class="solass_wp_bar_menu">'.__( 'S/WPs', 'solass-wp').'</span></div>',
		'href'  => admin_url('admin.php?page=solass-wp-settings'),
	) );
	// дочерние ссылки
    global $submenu;
$current_page_menu = sanitize_key(isset($_GET['page']));
$current_page_menu = isset($current_page_menu) ? $current_page_menu : '';
    $links = array();
    if (isset($submenu[dirname(plugin_basename(__FILE__),2)])) {
        foreach ($submenu[dirname(plugin_basename(__FILE__),2)] as $key => $item) {
            $url = admin_url( 'admin.php?page=' . $item[2] ); $name = $item[0]; $slug = $item[2];
            // Проверяем, есть ли уже такой пункт в массиве
            if (!array_key_exists($slug, $links)) {
			$wp_admin_bar->add_menu( array(
			'parent' => 'admin_bar_menu_solass_wp_settings', // параметр id из первой ссылки
			'id'     => 'admin_bar_menu_'.$slug, // свой id, чтобы можно было добавить дочерние ссылки
			'title'  => __( $name, 'solass-wp'),
			'href'   => $url,
			) );
            }
        }
    }
// Додаємо меню редагування плагіну
/*	$wp_admin_bar->add_menu( array(
		'parent' => 'admin_bar_menu_solass_wp_settings', // параметр id из первой ссылки
		'id'     => 'admin_bar_menu_solass_wp_editor', // свой id, чтобы можно было добавить дочерние ссылки
		'title'  => __( 'Редагування плагіну', 'solass-wp'),
		'href'   => admin_url('plugin-editor.php?file=solass-wp-settings%2Fsolass-wp-settings.php&amp;plugin=solass-wp-settings%2Fsolass-wp-settings.php'),
	) ); */
}
add_action( 'admin_bar_menu', 'solass_wp_admin_bar_menu', 300 );
}
}


// --------------------------------------------------------------------------------------------- //
// ------------------------------ ФУНКЦІЇ ПЛАГІНУ SOLASS WPSetting ----------------------------- //
// --------------------------------------------------------------------------------------------- //

// -------- Функція визначення вже назначеного пріоритету для хуку ------- //
if (!function_exists('swp_get_max_hook_priority')) {
function swp_get_max_hook_priority($hook) {
    global $wp_filter;
    if (!isset($wp_filter[$hook])) {
        return 0; // Если нет фильтров для данного хука, возвращаем 0
    }
    $max_priority = 0;
    foreach ($wp_filter[$hook]->callbacks as $priority => $callbacks) {
        if ($priority > $max_priority) {
            $max_priority = $priority;
        }
    }
    return $max_priority + 10;
}
}

/* -------------------- Функція перевірки віддалено існування файлу ---------------------- */
function swp_file_exists_remote($url) {
    $headers = @get_headers($url);
    // Проверяем первый заголовок (HTTP-код ответа)
    if ($headers && strpos($headers[0], '200') !== false) { return true;  } else {  return false;  }
}

// Функция для приведения к массиву
function solass_wp_sanitize_array($input) {
    // Если не массив, делаем его массивом
    if (!is_array($input)) { return []; }
    // Очищаем значения массива
    return array_map('sanitize_text_field', $input);
}



// ---------- Функція отримання контенту сторінки 
// з виконанням шорткодів та мовною версією Polylang
if (!function_exists('swp_echo_content_page')) {
function swp_echo_content_page($page_id = '') {
if (!empty($page_id) && get_post($page_id)) {
// Якщо не обробляється шорткод WPBakery - явно ініціалізуємо його до рендеру
if (class_exists('WPBMap')) { WPBMap::addAllMappedShortcodes(); }
// Підключаємо список активних плагінів
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
// Перевіряємо чи активний плагін Polylang
if ( is_plugin_active('polylang/polylang.php') ) {
    $translated_page_id = pll_get_post($page_id);
} else { $translated_page_id = $page_id; }
    // Отримуємо пост по ID
    $page = get_post($translated_page_id);
	$content = '';
    if ($page) {
        // отримуємо контент сторінки
        $content = $page->post_content;
        // Виконуємо шорткоди та фільтри
        $content = apply_filters('the_content', $content);
        $content = do_shortcode($content);
    }
        return $content;
}
}
}

// ---------- Функція отримання контенту сторінки 
// -------з шорткодами WPBakery і підключенням стилів
function solass_wpb_post_content( $post_obj ) {
    if ( ! $post_obj instanceof WP_Post ) {
        return;
    }
    global $post;
    $old_post = $post;
    $post = $post_obj;
    setup_postdata( $post );
    // Виводимо стилі WPBakery самостійно
    if ( did_action( 'wp_head' ) ) {
        $vc_css = get_post_meta( $post_obj->ID, '_wpb_post_custom_css', true );
        $shortcodes_css = get_post_meta( $post_obj->ID, '_wpb_shortcodes_custom_css', true );
        if ( $vc_css || $shortcodes_css ) {
            echo '<style>' . $vc_css . $shortcodes_css . '</style>';
        }
    }

    the_content();

    wp_reset_postdata();
    $post = $old_post;
}


// -------- Функція визначення статусу плагіна (встановлений, активований...) ------- //
function swp_status_plagin($p_slug) {
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
$plugin_slug = $p_slug; 
$plugin_path = WP_PLUGIN_DIR . '/' . $plugin_slug;

if (is_dir($plugin_path)) {
    $all_plugins = get_plugins();
    $plugin_active = false;
    foreach ($all_plugins as $plugin_file => $plugin_data) {
        if (strpos($plugin_file, $plugin_slug . '/') === 0) {
            // Плагин активирован
            if (is_plugin_active($plugin_file)) {
                $plugin_active = true;
            }
            break;
        }
    }
    if ($plugin_active) { return 2; } else {  return 1; } // Плагин установлен и активирован = 2
	
} else { return 0; } // Плагин не установлен 
}
// ------------- Функція формує іконку превью по URL файла ---------------- //
function solass_wp_get_correct_prew_file_url($file_url) {
    $site_url = get_site_url();
    // Определите тип MIME файла
    $file_info = wp_check_filetype($file_url);
    // Список допустимых MIME-типов для изображений
    $image_mime_types = array('image/jpeg', 'image/png', 'image/gif', 'image/webp', 'image/svg+xml');
    // Проверка, является ли файл изображением
    if (in_array($file_info['type'], $image_mime_types)) { 
		return wp_get_attachment_image_src(attachment_url_to_postid($file_url), 'thumbnail')[0];
    } elseif( empty($file_url) ) { 
		return $site_url . '/wp-content/plugins/solass-wp-settings/images/ico-doc-dell.svg'; 
	} else {
        // Получаем URL документа по умолчанию	https://ваш сайт/wp-includes/images/media/document.svg
        $default_document_url = $site_url . '/wp-content/plugins/solass-wp-settings/images/ico-doc.svg'; //'/wp-includes/images/media/document.svg' - стандартна Wordpress іконка
        return $default_document_url; 
    }
}

/* Функція додавання до візуального редактору у адмінці персональних стилів */
if (!function_exists('solass_plugin_add_editor_style')) { 
function solass_plugin_add_editor_style($mce_css) {
global $mce_css;
if ( ! empty( $mce_css ) ) $mce_css .= ',';
$mce_css .= $mce_css; //get_template_directory_uri() . '/dynamic-css.php';
return $mce_css;
}
}

// Функции для добавления стилей напрямую в редактор
function swp_active_editor_custom_styles($editor_id, $custom_styles) {
    add_filter('tiny_mce_before_init', function($settings) use ($editor_id, $custom_styles) {
        return solass_wp_editor_custom_styles($settings, $editor_id, $custom_styles);
    });
}
function solass_wp_editor_custom_styles($settings, $editor_id, $custom_styles) { 
	$current_editor_id = isset($settings['selector']) ? $settings['selector'] : '';
	if ($current_editor_id == "#".$editor_id) {
    // Добавляем стили в параметр content_style
    if (isset($settings['content_style'])) { $settings['content_style'] .= ' ' . $custom_styles; } else { $settings['content_style'] = $custom_styles; }
	}
    return $settings;
}

/* Функція створення мовного перекладу json з файлів перекладів po */
if (!function_exists('convert_po_to_json')) { 
function convert_po_to_json($po_file_path, $json_file_path) {
    if (file_exists($po_file_path)) {
        $po = new \Gettext\Translations();
        $po->loadPO($po_file_path);
        $translations = array();
        foreach ($po as $original => $translation) {
            $translations[$original] = $translation->getTranslation();
        }
        $json = json_encode($translations);
        file_put_contents($json_file_path, $json);
    }
}
}
// Приклад виклику функції конвертації
// convert_po_to_json('/path/to/messages.po', '/path/to/messages.json');

/* Функція виводу підменю розділу */
if (!function_exists('solass_wp_zakladka_admin_menu')) { 
function solass_wp_zakladka_admin_menu() {
    global $submenu;//, $plugin_name
$current_page_menu = sanitize_key($_GET['page']);
$current_page_menu = isset($current_page_menu) ? $current_page_menu : '';
    $links = array();

    if (isset($submenu[dirname(plugin_basename(__FILE__),2)])) {
        foreach ($submenu[dirname(plugin_basename(__FILE__),2)] as $key => $item) {
            $url = admin_url( 'admin.php?page=' . $item[2] ); $name = $item[0]; $slug = $item[2];
            // Проверяем, есть ли уже такой пункт в массиве
            if (!array_key_exists($slug, $links)) {
                $active = ($slug === $current_page_menu) ? 'nav-tab-active' : '';
                $links[$slug] = '<a class="nav-tab ' . esc_attr($active) . '" href="' . esc_url($url) . '">' . wp_kses_post($name) . '</a>';
            }
        }
        echo '<div class="nav-tab-wrapper">';
        echo implode('', $links);
        echo '</div>';
    }
}
}

// ----------------------- Функція визначення чи є браузер сучасним, чи ні --------------------- //

function solass_wp_ModernBrowser() {
    $ua = $_SERVER['HTTP_USER_AGENT'];
    $isModern = true;
    if (preg_match('/(MSIE|Trident|Edge)/i', $ua)) {
        // Если браузер Internet Explorer, Microsoft Edge или используется Trident rendering engine, то он считается старым
        $isModern = false;
    } elseif (preg_match('/(Chrome|Firefox|Safari)/i', $ua)) {
        // Если браузер Chrome, Firefox или Safari, то проверяем его версию
        preg_match('/(Chrome|Firefox|Safari)\/(\d+)/i', $ua, $matches);
        $browser = strtolower($matches[1]);
        $version = $matches[2];
        switch ($browser) {
            case 'chrome':
                $isModern = ($version >= 60);
                break;
            case 'firefox':
                $isModern = ($version >= 55);
                break;
            case 'safari':
                $isModern = ($version >= 10);
                break;
        }
    }
    return $isModern;
}



// --------------- Функція Конвертації кольорів у різні палітри ---------------- //

function solass_wp_convert_color($input = '', $to = 'hex') {
    $input = trim(strtolower($input));
    $r = $g = $b = 0;

    // RGBA или RGB
    if (preg_match('/rgba?\s*\(\s*(\d+)[,\s]+(\d+)[,\s]+(\d+)/', $input, $m)) {
        $r = (int)$m[1];
        $g = (int)$m[2];
        $b = (int)$m[3];
    }
    // HEX (3 или 6 символов)
    elseif (preg_match('/^#?([a-f0-9]{3}|[a-f0-9]{6})$/i', $input, $m)) {
        $hex = ltrim($m[1], '#');
        if (strlen($hex) === 3) {
            $r = hexdec(str_repeat($hex[0], 2));
            $g = hexdec(str_repeat($hex[1], 2));
            $b = hexdec(str_repeat($hex[2], 2));
        } else {
            $r = hexdec(substr($hex, 0, 2));
            $g = hexdec(substr($hex, 2, 2));
            $b = hexdec(substr($hex, 4, 2));
        }
    } else {
        return false; // Неизвестный формат
    }

    // Возвращаем нужный формат
    switch (strtolower($to)) {
        case 'hex':
            return sprintf("#%02x%02x%02x", $r, $g, $b);
        case 'rgb':
            return "rgb($r, $g, $b)";
        case 'rgba':
            return "rgba($r, $g, $b, 1)";
        default:
            return false;
    }
}



// --------------- Функція транслітерації та заміни спецсимволів на "_" ---------------- //

function solass_wp_translit($str) {
  $translit_table = array(
    'а'=>'a', 'б'=>'b', 'в'=>'v', 'г'=>'g', 'д'=>'d',
    'е'=>'e', 'ё'=>'e', 'ж'=>'zh', 'з'=>'z', 'и'=>'i',
    'й'=>'y', 'к'=>'k', 'л'=>'l', 'м'=>'m', 'н'=>'n',
    'о'=>'o', 'п'=>'p', 'р'=>'r', 'с'=>'s', 'т'=>'t',
    'у'=>'u', 'ф'=>'f', 'х'=>'h', 'ц'=>'ts', 'ч'=>'ch',
    'ш'=>'sh', 'щ'=>'sch', 'ъ'=>'', 'ы'=>'y', 'ь'=>'',
    'э'=>'e', 'є'=>'e', 'ю'=>'yu', 'я'=>'ya', '`'=>'', 
	 'і'=>'i', 'ї'=>'ii'
  );
  // Транслитерация строки
  $str = strtr(mb_strtolower($str), $translit_table);
  // Удаление спецсимволов
  $str = preg_replace('/[^a-z0-9]+/', '_', $str);
  // Удаление начального и конечного дефисов
  $str = trim($str, '-');
  return $str;
}


// ---------------------------- Функция вывода списка иконок dashicons ---------------------------- //

function solass_wp_icon_dashicons() {
    $dashicons_path = ABSPATH . wp_styles()->registered['dashicons']->src; 
    $dashicons_css = file_get_contents($dashicons_path);
	// Получаем массив всех иконок dashicons
    preg_match_all('/\.(dashicons-[^\s:]+):before/', $dashicons_css, $matches);
	$dashicons = isset($matches[1]) ? $matches[1] : array();
	// Выводим HTML-код для каждой иконки
	foreach ( $dashicons as $dashicon ) {
    echo '<span class="dashicons '.esc_attr( $dashicon ).'" var="'.esc_attr( $dashicon ).'" title="'.str_replace('dashicons-', '', esc_attr( $dashicon )).'"></span>';
	}

    return $dashicons;
}



// ----------------- Обрабатываем AJAX-запрос на поиск страниц ----------------------- //

// $data = json_decode($jsonString, true); //обработчик jSon массивов в привычные для php
// $myArray = unserialize($serializedArray); //обработчик serialized массивов в привычные для php

function solass_wp_search_page_callback() {
    $query = sanitize_text_field( $_POST['query'] );
	$post_type = isset($_POST['post_type']) ? sanitize_text_field($_POST['post_type']) : '';
	$taxonomy = isset($_POST['taxonomy']) ? sanitize_text_field($_POST['taxonomy']) : '';

if ( $post_type && $post_type != "active_plugins" ) { 
		$args = array( 'post_type' => $post_type, 's' => $query, ); // 'post_status' => 'publish', 'posts_per_page' => -1 
		$search_query = new WP_Query( $args ); 
		
	if ( $search_query->have_posts() ) {
        while ( $search_query->have_posts() ) {
            $search_query->the_post();
            $post_id = get_the_ID();
            $post_title = get_the_title();
            $post_slug = get_post_field( 'post_name', $post_id );
			
			echo '<li class="solass_wp_select_results_options" id="" aria-selected="false" post_id="'.$post_id.'" title="'.$post_title.'" post_slug="'.$post_slug.'">'.$post_title.' (ID:'.$post_id.')</li>';
        }
    } 
} 

if ( $post_type == "active_plugins" ) { 
	$plugins = get_plugins();
		foreach ($plugins as $plugin_file => $plugin_data) {
    		$plugin_path = plugin_basename( $plugin_file );
			echo '<li class="solass_wp_select_results_options" id="" aria-selected="false" post_id="'.$plugin_path.'" title="'.$plugin_data['Name'].'" post_slug="">' . $plugin_data['Name'] . '</li>';
		}
} 

if ( $taxonomy && !$post_type ) { 
		$args = array( 'taxonomy' => $taxonomy, 'search' => $query, 'hide_empty' => false  );  
		$search_query = get_terms( $args );
	if ( $search_query ) {
		foreach($search_query as $term) {
            $post_id = $term->term_id;
            $post_title = $term->name;
            $post_slug = $term->slug;
			$post_count = $term->count;
			
			echo '<li class="solass_wp_select_results_options" id="" aria-selected="false" post_id="'.$post_id.'" title="'.$post_title.'" post_slug="'.$post_slug.'">'.$post_title.' ('.$post_count.')</li>';
    	}
	}
} 
//  Поисковая фраза
//	echo '<li class="solass_wp_select_results_options" id="" role="treeitem" aria-selected="false" post_id="'.$query.'" title="'.$query.'" post_slug="'.$query.'" new_key="'.$query.'">'.$query.'</li>';

    wp_reset_postdata();

    wp_die();

}
add_action( 'wp_ajax_search_taxonomy', 'solass_wp_search_page_callback' );
add_action( 'wp_ajax_search_page', 'solass_wp_search_page_callback' );
add_action( 'wp_ajax_nopriv_search_taxonomy', 'solass_wp_search_page_callback' );
add_action( 'wp_ajax_nopriv_search_page', 'solass_wp_search_page_callback' );


// ------------- Функция получения параметров страницы, записи или таксономии --------- //
// ------------------------------------------------------------------------------------ //
function solass_wp_get_page_by_id($entity_type, $entity_id) {
    $page_info = null;
	$page_info = get_post($entity_id);
	$taxonomies = get_taxonomies();

	if ($page_info && $page_info->post_type == 'page') { 
		    $page_info->my_title = $page_info->post_title;
    		$page_info->my_slug = $page_info->post_name;
	} elseif (in_array($entity_type, $taxonomies)) {
		   $page_info = null;
		   $page_info = get_term($entity_id, $entity_type);
		   $page_info->my_title = $page_info->name; // Получаем заголовок категории
		   $page_info->my_slug = $page_info->slug; // Получаем слаг категории 
    } elseif ($entity_type == "key" && $entity_id ) { 
		   if (!is_object($page_info)) { $page_info = new stdClass(); }
		   // $page_info = null;
		   $page_info->id = $entity_id;
		   $page_info->my_title = $entity_id;
		   $page_info->my_slug = $entity_id;
	} elseif ( $page_info ) { 
		    $page_info->my_title = $page_info->post_title;
    		$page_info->my_slug = $page_info->post_name;
	}
  return $page_info;

}

// --------- Функция проверяет входит ли часть строки из массива в строку
function solass_wp_array_in_string($words, $string) { foreach ($words as $word) { if (stripos($string, $word) !== false) { return true; }  }  return false; }

// --------- Функция проверяет входит ли часть строки в значения из массива
function solass_wp_string_in_array($string, $words) { foreach ($words as $word) { if (stripos($word, $string) !== false) { return true; }  }  return false; }



// --------------------------------------------------------------------------------------------- //
// ---- Функция виводу списку мов плагіну Рolylang, визначення активної мови та наповнення ----- //
// --------------------------------------------------------------------------------------------- //

function solass_wp_polylang_active_lang($test_var) {
require_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Смотрим файл плагинов и Проверяем включен ли плагин Polylang 
if (is_plugin_active('polylang/polylang.php') ) {
echo '<div class="polylang_active_lang">';
if (function_exists('pll_the_languages')) {
$languages = pll_the_languages(array(
            'dropdown' => 0,             // Не использовать выпадающий список
            'show_names' => 0,           // Не показывать названия языков
            'display_names_as' => 'slug',// Показывать слаги языков (или использовать 'name' для полных названий)
            'show_flags' => 1,           // Показать флажки
            'hide_if_empty' => 0,        // Показать языки, даже если они не используются
            'force_home' => 0,           // Не форсировать ссылку на домашнюю страницу
            'echo' => 0,                 // Возвращать вместо вывода
            'raw' => 1                   // Возвращать массив, а не строку
        ));
//print_r($languages);
        if (!empty($languages)) {
            foreach ($languages as $lang) { 
				$a_class = ( $lang['slug'] == SOLASS_WP_CURRENT_LANG ) ? "lang_active " : ""; 
				if ( $lang['slug'] == pll_default_language() ) { $lang_slug = ""; } else {  $lang_slug = "_".$lang['slug']; }
				if( !get_option( $test_var.$lang_slug, '' ) ) { $a_class = $a_class."lang_off "; }
				//$a_class = $a_class . get_option( $test_var.'_'.$lang['slug'], '' ) ? "" : "lang_off ";
				$current_url = (is_ssl() ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; 
				$current_url = remove_query_arg('lang', $current_url);
				$url_lang = add_query_arg('lang', $lang['slug'], $current_url);
                echo '<a href="' . esc_url($url_lang) . '" class="'. $a_class .'" title="'.$lang['name'].'" alt="'.$lang['name'].'">'; //esc_url($lang['url'])
                echo $lang['flag'];
                echo '</a>';
            }
        }
}
echo '</div>';
}
}


// --------------------------------------------------------------------------------------------- //
// ------------------------- Функция вывода административных сообщений ------------------------- //
// --------------------------------------------------------------------------------------------- //

// Функция удаления НА СТРАНИЦАХ ПЛАГИНА всех сообщений вызваных по событию 'admin_notices'
add_action( 'admin_head', 'solass_wp_disable_plugin_pages_notices' );
function solass_wp_disable_plugin_pages_notices() {
//проверка на частичное вхождение перечня фраз в полное название страницы
$solass_wp_name_admin_page = get_current_screen();
$solass_wp_admin_pages_for_notice = array( 'solass-wp-settings', 'custom-form', 'solass-wp' );
$remove_all_actions = "";
//solass_wp_admin_notice($solass_wp_notice_args = array('type' => 'n', 'close' => '1', 'text' => '----------- '.$solass_wp_name_admin_page_base.' ------ '.$remove_all_actions) );
if( solass_wp_array_in_string( $solass_wp_admin_pages_for_notice, $solass_wp_name_admin_page->base ) ) {
remove_all_actions( 'admin_notices' );
}
/*
//проверка на точное совпадение названий из массива с полным названием страницы
$solass_wp_name_admin_page = get_current_screen();
$solass_wp_admin_pages_for_notice = array( 'toplevel_page_solass-wp-settings', 'toplevel_page_custom-form', 'solass-wpset_page_solass-wp-settings-functions', 'solass-wpset_page_solass-wp-settings-woo', 'solass-wpset_page_solass-wp-settings-seo', 'solass-wpset_page_solass-wp-settings-safe' );
if( array_search( $solass_wp_admin_pages_for_notice, $solass_wp_name_admin_page->base ) ) { 
//remove_all_actions( 'admin_notices' );
}
*/	
}


// ------------------ Функция вывода сообщений
function solass_wp_admin_notice($solass_wp_notice_args) {
$current_page = sanitize_key($_GET['page']); 
($solass_wp_notice_args["close"]) ? $solass_wp_notice_args["close"] = "is-dismissible" : $solass_wp_notice_args["close"] = "";
(!$solass_wp_notice_args["type"]) ? $solass_wp_notice_args["type"] = "notice-info" : $solass_wp_notice_args["type"] = $solass_wp_notice_args["type"];
($solass_wp_notice_args["text"] == "\n") ? $solass_wp_notice_args["text"] = "" : $solass_wp_notice_args["text"] = $solass_wp_notice_args["text"];
// Если хотим на определенных страницах
$solass_wp_admin_pages_for_notice = $solass_wp_notice_args["pages"] ?? '';
//$solass_wp_admin_pages_for_notice = array( 'toplevel_page_solass-wp-settings', 'solass-wpset_page_solass-wp-settings-functions', 'solass-wpset_page_custom-form' );
$solass_wp_name_admin_page = get_current_screen();
$solass_wp_name_admin_page_base = $solass_wp_name_admin_page->base;
if (
!$solass_wp_admin_pages_for_notice || 
$solass_wp_notice_args["text"] == "info" || 
($solass_wp_admin_pages_for_notice && (in_array( $current_page, $solass_wp_admin_pages_for_notice ) || in_array( $solass_wp_name_admin_page->base, $solass_wp_admin_pages_for_notice) ) ) ) { 
if($current_page){ $current_page = "(page=".$current_page.")"; }
if($solass_wp_notice_args["text"] == "info") { echo '<div class="notice notice-info is-dismissible"><p>Information: We are currently on the <strong>'.$solass_wp_name_admin_page_base.'</strong> admin page '.$current_page.'</p></div>'; } elseif ($solass_wp_notice_args["text"] != "info") {
echo '<div class="notice '.$solass_wp_notice_args["type"].' '.$solass_wp_notice_args["close"].'"><p>'.$solass_wp_notice_args["text"].'</p></div>';
} 
}
}
// Вызываем функцию сообщений о названии страницы админки (для технического пользования)
// вызываем по событию 'all_admin_notices', чтоб обойти удаление всех сообщений по 'admin_notices'
add_action( 'all_admin_notices', function(){
//solass_wp_admin_notice($solass_wp_notice_args = array('type' => 'n', 'close' => '1', 'text' => 'info'/*, 'pages' => array('toplevel_page_solass-wp-settings', 'solass-wp-settings-seo', 'toplevel_page_custom-form')*/)); //type = notice-success, notice-error, notice-warning, notice-info, 
}); 



// --------------------------------------------------------------------------------------------- //
// --------- Проверяем и записываем файл CSS стилей пользователя в файл custom_swps.css -------- //
// --------------------------------------------------------------------------------------------- //

function solass_wp_css_editor_save() {
	$plugin_dir = plugin_dir_path(__FILE__); 
	$uploads_dir_var = wp_upload_dir();
	$upload_dir = $uploads_dir_var['basedir'];
	$plugin_upload_dir = $upload_dir.'/solass-wp-uploads';
	$upload_dir_css_file = $plugin_upload_dir.'/custom_swps.css';
    $previous_css_file = $plugin_dir.'previous_custom_swps.txt'; 
//	$plugin_dir_css_file = $plugin_dir.'custom_swps.css'; 
//  $css_file_root = $_SERVER['DOCUMENT_ROOT'] .'/'.'custom_swps.css'; 
//	$htaccess_notice['text'] = "";

    // Проверяем, была ли отправлена форма
    //if (isset($_POST['solass_wp_css_code_file'])) { }

    $css_file_save = esc_attr($_POST['solass_wp_css_type']);
    $new_css_content = esc_textarea( strip_tags( $_POST['solass_wp_css_code'] ) );
	$css_content = file_get_contents($upload_dir_css_file);

	if ($new_css_content != $css_content) {
		// Проверяем и создаем папку в uploads/solass-wp-uploads
		if (!is_dir($plugin_upload_dir)) {
		// Создаем новую папку с правами доступа 0755
 		mkdir($plugin_upload_dir, 0755);
		}
        // Создаем резервную копию текущего файла previous_custom_swps.txt
        if (file_exists($upload_dir_css_file)) {
            $css_old_content = file_get_contents($upload_dir_css_file);
            file_put_contents($previous_css_file, $css_old_content);
        }
        // Сохраняем новое содержимое файла custom_swps.css
        //if ($css_file_save) { } 
            file_put_contents($upload_dir_css_file, $new_css_content);
			if (isset($_POST['solass_wp_css_type']) == "file") { 
			//Системное сообщение если включен вывод файла type = notice-success, notice-error, notice-warning, notice-info,
			$css_notice['type'] = 'notice-success'; $css_notice['close'] = '1'; $css_notice['text'] = esc_html__( 'Файл персональних стилів CSS успішно оновлено!', 'solass-wp' ); 
			}
	}

if( !empty( $css_notice ) && $css_notice['text'] != ""){
update_option('solass_wp_css_notice', $css_notice, 'no'); //$htaccess_editor_notice 
} else { $css_notice = ""; }

return $css_notice;
}


// --------------------------------------------------------------------------------------------- //
// ------- Проверяем и записываем файлы из баз данных в папку uploads/solass-wp-uploads -------- //
// --------------------------------------------------------------------------------------------- //

function solass_wp_uploads_file($file_save_name = "", $text_var = "") {
	if (!empty($file_save_name)) {
	$plugin_dir = plugin_dir_path(__FILE__); 
	$uploads_dir_var = wp_upload_dir();
	$upload_dir = $uploads_dir_var['basedir'];
	$plugin_upload_dir = $upload_dir.'/solass-wp-uploads';
	$upload_dir_file = $plugin_upload_dir.'/'.$file_save_name;
	$uploads_file_content = file_get_contents($upload_dir_file);
	// Записуємо файл, якщо передається ім'я змінної контенту
	if(!empty($text_var)) {
    	$new_uploads_file_content = esc_textarea( strip_tags( $_POST[$text_var] ) );
		
	if ($new_uploads_file_content != $uploads_file_content) {
		if (!is_dir($plugin_upload_dir)) {
		// Создаем новую папку с правами доступа 0755
 		mkdir($plugin_upload_dir, 0755);
		}
        // Сохраняем новое содержимое файла custom_swps.css
        file_put_contents($upload_dir_file, $new_uploads_file_content);
		$uploads_file_content = $new_uploads_file_content;
	}
	}
// Вертаємо контент файлу
return $uploads_file_content;
}
}



// --------------------------------------------------------------------------------------------- //
// --------------------- Проверяем и записываем содержимое файла .htaccess --------------------- //
// --------------------------------------------------------------------------------------------- //

function solass_wp_htaccess_editor_save() {
	$plugin_dir = plugin_dir_path(__FILE__);
    $htaccess_file = $_SERVER['DOCUMENT_ROOT'] .'/'.'.htaccess'; 
    $previous_htaccess_file = $plugin_dir.'previous_htaccess.txt'; 
//	$htaccess_notice['text'] = "";

    // Проверяем, была ли отправлена форма
    if (isset($_POST['save_solass_wp_base_htaccess'])) { 
        $new_htaccess_content = $_POST['solass_wp_htaccess_content'];
		$htaccess_content = file_get_contents($htaccess_file);
		if ($new_htaccess_content != $htaccess_content) {

        // Проверяем правильность нового содержимого файла .htaccess
        $valid_htaccess = true;
        if (function_exists('apache_get_modules')) {
            $modules = implode(' ', apache_get_modules());
            if (strpos($modules, 'mod_rewrite') === false) { 
				//Системное сообщение type = notice-success, notice-error, notice-warning, notice-info,
				$htaccess_notice['type'] = 'notice-warning'; $htaccess_notice['close'] = '1'; $htaccess_notice['text'] = 'Модуль Apache mod_rewrite не встановлений або не увімкнений';
                $valid_htaccess = false;
            }
        }

        if ($valid_htaccess) {
			$test_htaccess_file = $plugin_dir . '.htaccess.test';
			file_put_contents($test_htaccess_file, $new_htaccess_content); /* "<?php\n" . . "\n?>" */ 
			ob_start();
			include($plugin_dir.'test_htaccess.php');
			$output = ob_get_contents();
			ob_end_clean();
			if (strpos($output, 'Syntax OK') === false) {
    			//Системное сообщение type = notice-success, notice-error, notice-warning, notice-info,
    			$htaccess_notice['type'] = 'notice-error'; $htaccess_notice['close'] = '1'; $htaccess_notice['text'] = 'Помилка у файлі .htaccess: <br>'.$output;
    			$valid_htaccess_test = false;
			}
			unlink($test_htaccess_file);
        } 
		if ( !$valid_htaccess_test ) {
			$valid_htaccess_test = solass_wp_test_htaccess_file('.htaccess.test');
			if(!$valid_htaccess_test) { 
			//Системное сообщение type = notice-success, notice-error, notice-warning, notice-info,
			$htaccess_notice['type'] = 'notice-error'; $htaccess_notice['close'] = '1'; $htaccess_notice['text'] = 'Помилка у файлі .htaccess: <br>'.$output; 
			}
		}
        // Создаем резервную копию текущего файла .htaccess
        if (file_exists($htaccess_file)) {
            $htaccess_content = file_get_contents($htaccess_file);
            file_put_contents($previous_htaccess_file, $htaccess_content);
        }
        
        // Сохраняем новое содержимое файла .htaccess
        if ($valid_htaccess_test) {
            file_put_contents($htaccess_file, $new_htaccess_content);
			//Системное сообщение type = notice-success, notice-error, notice-warning, notice-info,
			$htaccess_notice['type'] = 'notice-success'; $htaccess_notice['close'] = '1'; $htaccess_notice['text'] = esc_html__( 'Файл параметрів .htaccess успішно збережено!', 'solass-wp' ); 
//			solass_wp_admin_notice($solass_wp_notice_args = array('type' => 'notice-success', 'close' => '1', 'text' => 'Файл данных .htaccess успешно сохранен')); 
        } 
    }
}
	
if($htaccess_notice && $htaccess_notice['text'] != ""){
update_option('solass_wp_htaccess_notice', $htaccess_notice, 'no'); //$htaccess_editor_notice 
}
	
return $htaccess_notice;
}


function solass_wp_test_htaccess_file($htaccess_file) {
    // Добавляем заглушку, чтобы PHP не ругался на отсутствие тега PHP в файле .htaccess
    $content = "<?php\n" . file_get_contents($htaccess_file) . "\n?>";
    // Создаем временный файл для проверки синтаксиса
    $temp_file = tempnam(sys_get_temp_dir(), 'htaccess_test_');
    file_put_contents($temp_file, $content);
    // Проверяем синтаксис файла
    ob_start();
    include($temp_file);
    $output = ob_get_contents();
    ob_end_clean();
    // Удаляем временный файл
    unlink($temp_file);
    
    return strpos($output, 'Parse error') === false;
}


function solass_wp_htaccess_editor() {
	$plugin_dir = plugin_dir_path(__FILE__);
    $htaccess_file = $_SERVER['DOCUMENT_ROOT'] .'/'.'.htaccess'; 
    $previous_htaccess_file = $plugin_dir.'previous_htaccess.txt'; 

    // Загружаем текущее содержимое файла .htaccess
    $htaccess_content = ''; $last_modified = '';
    if (file_exists($htaccess_file)) { 
	$timezone_string = get_option('timezone_string');
	if ( $timezone_string ) { date_default_timezone_set( $timezone_string ); } // устанавливаем часовой пояс
	$last_modified = filemtime($htaccess_file);
	$htaccess_editor_var['date'] = date('Y-m-d H:i:s', $last_modified);
    $htaccess_content = htmlspecialchars(file_get_contents($htaccess_file)); //htmlentities
	$htaccess_editor_var['content'] = $htaccess_content;
    }
    
    // Загружаем предыдущее содержимое файла .htaccess
    $previous_htaccess_content = '';  $last_modified = '';
    if (file_exists($previous_htaccess_file)) {
	$timezone_string = get_option('timezone_string');
	if ( $timezone_string ) { date_default_timezone_set( $timezone_string ); } // устанавливаем часовой пояс
	$last_modified = filemtime($previous_htaccess_file);
	$htaccess_editor_var['previous_date'] = date('Y-m-d H:i:s', $last_modified);
    $previous_htaccess_content = file_get_contents($previous_htaccess_file);
	$htaccess_editor_var['previous'] = $previous_htaccess_content;
    }

return $htaccess_editor_var;
}



// --------------------------------------------------------------------------------------------- //
// ------------------------------ ВІДЖЕТ ПЛАГІНУ SOLASS WPSetting ------------------------------ //
// -----------------------в консоли в админ-панели на головній сторінці ------------------------ //
// ------ на главной странице админки блок в который можно поставить любой код плагина ----------//


add_action('wp_dashboard_setup', 'solass_wp_dashboard_widgets');
function solass_wp_dashboard_widgets() {
	wp_add_dashboard_widget('solass_wp_help_widget', 'SOLASS WPSettings', 'solass_wp_dashboard_help');
}

function solass_wp_dashboard_help() {
global $login_changes_themes; 
echo '<h3 class="text-center">Повідом відвідувачів про технічні роботи</h3>';
?>
<form method="post" action="options.php">
      <?php
        settings_fields( 'solass-wp-settings-tech' );
        do_settings_sections( 'solass-wp-settings-tech' );
      ?>
<table class="form-table" border=0>
		 <tr>
		<td style="" class="mob-width-100">
			<div class="text-center"><label class="checkbox_button button_design" for="solass_wp_edit_themes"><input type="checkbox" name="solass_wp_edit_themes" id="solass_wp_edit_themes" <?php if(esc_attr( get_option( 'solass_wp_edit_themes', '' ) )) echo 'checked="checked"'; ?>><div class="tech_work"><span class="off_button_text nowrap-"><?php echo esc_html__( 'Увімкнути техроботи', 'solass-wp'); ?></span><span class="on_button_text nowrap-"><?php echo esc_html__( 'Вимкнути техроботи', 'solass-wp'); ?></span></div></label>
			<div class="margin-top-15 text-center"><small><?php echo $login_changes_themes; ?></small></div>
<?php 
if( get_option( 'solass_wp_debug', false ) ) {  //&& defined( 'WP_DEBUG' ) ?>
<div class="ssl-info- margin-width-12 ssl-error-" style="padding: 12px;"><div class="text-info">
<span class="dashicons dashicons-warning" style="font-size: 30px; color: #a00;"></span><div><h4 style="font-size: 16px; margin-top: 10px"><?php echo esc_html__( 'Увімкнутий режим налагодження зі сповіщеннями про помилки коду - WP_DEBUG', 'solass-wp'); ?></h4>
<a href="/wp-admin/admin.php?page=solass-wp-settings-functions#solass_wp_debug"><span class="nowrap- nowrap- button button-primary-"><?php echo esc_html__( 'Вимкнути WP_DEBUG', 'solass-wp'); ?></span></a></div>
</div></div>
<?php } ?>
			</div>

		</td>
        </tr>
</table>
<div class="display-none"><?php submit_button(); ?></div>
</form>
<?php 			
$ca_file = ABSPATH  . WPINC . '/certificates/ca-bundle.crt'; 
$cert = file_get_contents($ca_file);
$ssl_context = stream_context_create(['ssl' => [
    'verify_peer' => true,
    'cafile' => $ca_file,
]]);
$resource = openssl_x509_read($cert);
$result = openssl_x509_checkpurpose($resource, X509_PURPOSE_ANY);
//$result = openssl_x509_checkpurpose($resource, X509_PURPOSE_ANY, [], null, null, $ssl_context); Для версий PHP > 7.4 
$result_load = solass_wp_remote_post_test(); //отправляем тестовый запрос на сервер 
//print_r($result_load);
if (!$result_load['test_error'] && !esc_attr( get_option( 'solass_wp_ssl_off', false ) ) ) { //$result === true && // print_r($result_load); echo 'Сертификат актуален.';
} else { //print_r($result_load); echo " ---------------------- ".$result_load['body']; 
?>
<div class="border-top-light margin-width-12"></div>
<?php  if(esc_attr( get_option( 'solass_wp_ssl_off', false ) ) ) { ?>
<div class="ssl-info margin-width-12 ssl-error" style="padding: 12px;">
<div class="text-info">
<span class="dashicons dashicons-warning" style="font-size: 30px; color: #a00;"></span><div><h4 style="font-size: 18px; margin-top: 10px"><?php echo esc_html__( 'Вимкнена перевірка SSL-сертифікату Wordpress.', 'solass-wp'); ?></h4>
<?php echo esc_html__( 'Ви вимкнули перевірку SSL-сертифікату WordPress. Рекомендуємо не використовувати цю функцію тривалий час. Вимикайте перевірку на період тестових робіт, або оновлення плагінів з віддалених серверів.', 'solass-wp'); ?> <br><em><?php echo esc_html__( '!!! УВАГА !!! Використовуйте відключення на короткий час.', 'solass-wp'); ?></em> <br><br>
<a href="/wp-admin/admin.php?page=solass-wp-settings-safe#ssl_off"><span class="nowrap- nowrap- button button-primary"><?php echo esc_html__( 'Увімкнути перевірку SSL-сертифікату', 'solass-wp'); ?></span></a></div>
</div>
</div>
<?php  } else { ?>
<div class="ssl-info margin-width-12 ssl-error ssl-error-info" style="padding: 12px;">
<div class="text-info-info">
<span class="dashicons dashicons-info" style="font-size: 30px; color: #dfbb66;"></span><div><h4 style="font-size: 18px; margin-top: 10px"><?php echo esc_html__( 'SSL-сертифікат Wordpress прострочений або не актуальний.', 'solass-wp'); ?></h4>
<?php echo esc_html__( 'Застарілий сертифікат може викликати помилку при передачі або обміні даними з віддаленими серверами/іншими сайтами. Ви можете оновити файл сертифіката за адресою: ', 'solass-wp'); ?><strong><?php echo WPINC . '/certificates/ca-bundle.crt'; ?></strong> <?php echo esc_html__( 'Також тимчасово відключити перевірку сертифікату завдяки функції плагіну.', 'solass-wp'); ?> <br><em><?php echo esc_html__( '!!! УВАГА !!! Використовуйте відключення на короткий час.', 'solass-wp'); ?></em> <br><br>
<a href="/wp-admin/admin.php?page=solass-wp-settings-safe#ssl_off"><span class="nowrap- nowrap- button button-primary-"><?php echo esc_html__( 'Вимкнути перевірку SSL-сертифікату', 'solass-wp'); ?></span></a></div>
</div>
</div>
<?php } ?>
<!--
<div class="ssl-info margin-width-12 ssl-error" style="padding: 12px;">
<div class="text-info">
<span class="dashicons dashicons-warning" style="font-size: 30px; color: #a00;"></span><div><h4 style="font-size: 18px; margin-top: 10px"><?php echo esc_html__( 'SSL-сертифікат Wordpress прострочений або не актуальний.', 'solass-wp'); ?></h4>
<?php echo esc_html__( 'Застарілий сертифікат може викликати помилку при передачі або отриманні даних. Ви можете оновити файл сертифіката за адресою: ', 'solass-wp'); ?><strong><?php echo WPINC . '/certificates/ca-bundle.crt'; ?></strong> <?php echo esc_html__( 'або тимчасово відключити перевірку сертифікату завдяки функції плагіну.', 'solass-wp'); ?> <em><?php echo esc_html__( '!!! УВАГА !!! Використовуйте відключення на короткий час.', 'solass-wp'); ?></em> <br><br>
<a href="/wp-admin/admin.php?page=solass-wp-settings-safe#ssl_off"><span class="nowrap- nowrap- button button-primary-"><?php echo esc_html__( 'Вимкнути перевірку SSL-сертифікату', 'solass-wp'); ?></span></a></div>
</div>
</div>-->
<?php 
} 
if (PHP_VERSION_ID < 80000) { 
	openssl_x509_free($resource); // до PHP 8.3  
} 
?>
<div class="border-top-light margin-width-12"></div><br>
<?php echo '<strong>Дякуємо вам що ви використовуєте наш плагін "SOLASS WPSettings"! </strong><br><br>
	Тут буде виводитись інформація про функціонування плагіну, та важливі повідомлення про його роботу.'; 
?>
<div class="border-top-light margin-top-15"></div>
<p class="button-container">
<a class="button button-primary" href="admin.php?page=<?php echo dirname(plugin_basename(__FILE__),2);; ?>" rel="noopener"><?php echo esc_html__( 'Перейти до налаштувань плагіну SOLASS WPSettings', 'solass-wp'); ?><!--<span class="screen-reader-text"><?php echo esc_html__( '(відкривається у новій вкладці)', 'solass-wp'); ?></span> <span aria-hidden="true" class="dashicons dashicons-external"></span>--></a></p>
<?php

}



/* --------------------------------------------------------------------------------
 * Выводит перечень функций вызываемых хуком на странице.
  $hook  Название хука, список фукнций которого нужно вывести.
 * --------------------------------------------------------------------------------
*/
function solass_wp_display_hook_functions($hook) {
    global $wp_filter;
    // Проверяем, есть ли функции, привязанные к указанному хуку
    if (isset($wp_filter[$hook]) && $wp_filter[$hook]) {
        echo '<h5>Функции, вызываемые при хуке ' . $hook . ':</h5>';
        // Перебираем функции, привязанные к хуку
        foreach ($wp_filter[$hook] as $priority => $callbacks) {
            foreach ($callbacks as $callback) {
                // Выводим название функции
                if (is_string($callback['function'])) {
                    echo $callback['function'] . '<br>';
                } elseif (is_object($callback['function'][0])) {
                    // Если функция является методом класса, выводим имя класса и метода
                    echo get_class($callback['function'][0]) . '->' . $callback['function'][1] . '<br>';
                }
            }
        }
    } else { echo '<h5>Нет функций, привязанных к хуку ' . $hook . '</h5>';  }
}

/* --------------------------------------------------------------------------------
 * Выводит на экран список всех хуков WordPress и функций к ним прикрепленных.
   @param string $hook_name  Название хука, список фукнций которого нужно вывести.
 * --------------------------------------------------------------------------------
*/
function solass_wp_get_hooks_list( string $hook_name = '' ): string {
	global $wp_filter;
	$wp_hooks = $wp_filter;
	// для версии 4.4 - переделаем в массив
	if( is_object( reset( $wp_hooks ) ) ){
		foreach( $wp_hooks as & $object ){
			$object = $object->callbacks;
		}
		unset( $object );
	}
	$hooks = [];
	if( $hook_name ){
		$hooks[ $hook_name ] = $wp_hooks[ $hook_name ] ?? null;
		if( ! is_array( $hooks[ $hook_name ] ) ){
			return "Nothing found for the '$hook_name' hook";
		}
	}
	else{
		$hooks = $wp_hooks;
		ksort( $wp_hooks );
	}
	$output = '';
	foreach( $hooks as $name => $hook_data ){
		ksort( $hook_data );
		$output .= "\n<a name='$name'></a>Hook\t<strong id='$name'>$name</strong>\n";
		$output .= "<small>";
		foreach( $hook_data as $priority => $hooksdata ){
			$output .= $priority;
			foreach( $hooksdata as $key => $hdata ){
				$func = $hdata['function'];
				if( is_array( $func ) ){
					if( is_object( $func[0] ) ){
						$func_name = get_class( $func[0] ) . '->' . $func[1];
					}
					else {
						$func_name = $func[0] . '::' . $func[1];
					}
				}
				elseif( $func instanceof Closure ){
					$func_name = "Closure_$key";
				}
				else {
					$func_name = $key;
				}
				$output .= "\t$func_name()\n";
			}
		}
		$output .= "</small>";
	}
	return sprintf( '<%1$s>%2$s</%1$s>', 'pre', $output );
}


// ----------------------------------------------------------------------------------------------- //
// ------------------------------ Создаем собственные формы мета-полей --------------------------- //
// ---------------------------------- (все настройки в этих файлах) ------------------------------ //
// --- На основе этого кода можно создавать свои поля данных для определенных типов страниц ------ //
//
/*
if (file_exists(__DIR__ . '/my_metabox/create_function.php')) {
//Подключаем файл функции создания собственных мета-полей в админке
require_once("my_metabox/create_function.php"); 
//Подключаем файл функций вывода/чтения данных на страницах сайта создаваемых мета-полей
if (file_exists(__DIR__ . '/my_metabox/read_metabox.php')) {
require_once("my_metabox/read_metabox.php"); }
//Подключаем файл данных создаваемых форм (!!!массивы данных создаваемых полей!!!)
if (file_exists(__DIR__ . '/my_metabox/build_metabox.php')) {
require_once("my_metabox/build_metabox.php"); 
} 
}
*/

