<?php 
// --------------------------------------------------------------------------------- //
//----------------- Код виводу блоку галереї на сторінках постів ------------------- //
// --------------------------------------------------------------------------------- //
if ( ! defined( 'ABSPATH' ) ) { exit; } // Вихід, якщо доступ до нього прямий

// ---------------------- Подключаємо стилі та  JavaScript -------------------//
// Підключення стилів та скриптіів для сторінок адмінки
add_action('admin_enqueue_scripts', 'solass_wp_gallery_admin_styles_scripts');
function solass_wp_gallery_admin_styles_scripts($hook_suffix) {
	$post_types_array = get_option( 'solass_wp_array_post_gallery', [] );
	//if( !empty(SOLASS_NO_GALLERY) && !empty(in_array($post_type, SOLASS_NO_GALLERY) ) ) { $color_post_type = "opacity: 0.4;"; $disabled_post_type = " disabled"; } else {  $color_post_type = "";  $disabled_post_type = "";  }
	if(!empty($post_types_array[get_current_screen()->post_type])) {	//Ограничиваем подключение постами плагина
    // Проверяем, что находимся на нужной странице редактирования поста
    if ($hook_suffix === 'post.php' || $hook_suffix === 'post-new.php') {
        wp_enqueue_media();
        wp_enqueue_script( 'solass-wp-gallery-script', plugin_dir_url(__FILE__) . 'gallery.js', ['jquery'], '1.0', true );
        wp_enqueue_style( 'solass-wp-gallery-style',  plugin_dir_url(__FILE__) . 'admin-gallery.css',  [], '1.0.0' );
    }
	}
}
// Стилі та скріпти підключаються у футері на сторінках сайту, 
// якщо на сторінці використовується шорткод виводу галереї
add_action('wp_footer', function() {
    global $solass_gallery_active;
    if ($solass_gallery_active) { // $solass_gallery_active = true у коді шорткоду 
        wp_enqueue_style('solass-site-gallery-style', plugin_dir_url(__FILE__) . 'solass-site-gallery.css', array(), '1.0.0');
        //wp_enqueue_script('solass-site-gallery-script', plugin_dir_url(__FILE__) . 'solass-site-gallery.js', array('jquery'), '1.0.0', true);
    }
});


// ---------------------- Добавляем метабокс (контент на странице редактирования) -------------------//

add_action('add_meta_boxes', 'solass_wp_add_gallery_meta_box');
function solass_wp_add_gallery_meta_box() {
	$post_types_array = array_diff( array_keys((array) get_option('solass_wp_array_post_gallery', [])), defined('SOLASS_NO_GALLERY') ? SOLASS_NO_GALLERY : [] );
	if (empty($post_types_array) || !$post_types_array[0] ) { return; } // Проверяем, есть ли вообще типы записей
    foreach ($post_types_array as $post_type) {
	if(!empty($post_type)) {
    add_meta_box(
        'gallery_metabox', 					//Уникальное, не повторяющееся ID метабокса
        'Галерея', 							//Название метабокса 
        'solass_wp_render_gallary_metabox',	// Функция запускающая отрисовку контента метабокса
        $post_type, 					    // 'leaflet' или 'post' или другой тип записи или массив ['post', 'page', 'custom_type'] где выводится метабокс
        'side', 							//'normal' — Основная область контента. 'side' — Боковая панель. 'advanced' — Под основным редактором.
        'default' 							//'high' — Высокий приоритет. 'low' — Низкий приоритет. 'default' — По умолчанию.
    );
}
}

// Ставимо метабокс відразу після панелі "Головне зображення"
$user_id = get_current_user_id(); // Получаем ID текущего пользователя 
$meta_key = 'meta-box-order_' . get_current_screen()->post_type; // текущий тип записи
$meta_box_order = get_user_meta($user_id, $meta_key, true) ?? []; // Получаем метаданные
// Проверяем, есть ли 'gallery_metabox' в любом из элементов массива
$found = false;
if(!empty($meta_box_order)) { 
foreach ($meta_box_order as $key => $value) { if (is_string($value) && strpos($value, 'gallery_metabox') !== false) { $found = true; break; } }
}
if ( !$found ) {
//print_r($meta_box_order);
add_action('admin_footer', function() {
echo "
    <script>
        jQuery(document).ready(function($) {
            var metabox = $('#gallery_metabox'); // ID вашого метабокса
            var publishBox = $('#postimagediv'); // ID метабокса 'Головне зображення'
            if (metabox.length && publishBox.length) {
                metabox.insertAfter(publishBox); // Перемістить ваш метабокс після 'Опублікувати'
            }
        });
    </script>
";
});

}
}

function solass_wp_render_gallary_metabox($post) {
    // Получаем галерею из мета-поля
    $gallery = get_post_meta($post->ID, '_gallery', true) ?: [];
    
    // Нонсы для защиты
    wp_nonce_field('save_gallery_metabox', 'gallery_metabox_nonce'); 
	
    // Готовим aria-label заранее, чтобы не вставлять логики в HTML
    $aria = esc_html__(
        'Для досягнення найкращих результатів завантажуйте файли у форматі JPEG або PNG розміром не меньше 1200px за більшою стороною. Максимальний розмір файлу, що завантажується: ' .
        ini_get('upload_max_filesize') .
        'В. Шорткод для виводу на сторінці: [solass_gallery]',
        'solass-wp'
    );
    // HTML вывода галереи
    echo '
    <div id="gallery-wrapper">
        <ul id="gallery-images" class="gallery-images" style="list-style: none; margin: 0; padding: 0; margin-top: 10px; display: flex; ">';
            foreach ($gallery as $image_id) : 
            echo '  <li data-id="'.esc_attr($image_id).'" class="gallery-photo" style="">
                    '.wp_get_attachment_image($image_id, 'thumbnail', false, ['style' => '', 'class' => 'gallery-thumbnail']).'
                    <span class="dashicons dashicons-dismiss remove-image" style=""></span>
                </li>';
            endforeach;
        echo '</ul>
		<p class="add_listovka_images hide-if-no-js">
			<a href="#" id="add-gallery-images" >'.esc_html__( 'Додати зображення галереї', 'solass-wp').'</a><span class="solass-swp-help" tabindex="0" aria-label="'.esc_attr($aria).'"><span></span></span>
		</p>
    </div>
    <input type="hidden" id="gallery-input" name="gallery" value="'.esc_attr(implode(',', $gallery)).'">';

}


// ----------------- Шорткод виводу галереї на сторінках сайту ------------------------------- //
// Шорткод: [solass_gallery post_id="номер ID посту" size="розмір зображень"]
add_shortcode('solass_gallery', 'solass_wp_render_gallery');
function solass_wp_render_gallery($options) {
    global $solass_gallery_active;
	// Задаем дефолтные значения атрибутов шорткода "solass_file_upload"
    $options = shortcode_atts( array( 'post_id' => get_the_ID(), 'size' => 'full', ), $options, 'solass_gallery' );
	
	$gallery = get_post_meta($options['post_id'], '_gallery', true);
if (!empty($gallery)) { 
	$solass_gallery_active = true; // оповещаем о запуске шорткода
	ob_start(); // Начинаем буферизацию
    echo '<div id="post_gallery_'.$options['post_id'].'" class="swp_post_gallery">';
    foreach ($gallery as $image_id) {
        echo '<div class="swp_post_gallery_prew">'.wp_get_attachment_image($image_id, $options['size']).'</div>';
    }
    echo '</div>';
	return ob_get_clean(); // Возвращаем собранный HTML
}
	return ''; // Если галерея пуста, возвращаем пустую строку
}

// Додаєм кнопку додавання шорткоду у текстовому редакторі 
add_action('admin_enqueue_scripts', 'solass_wp_gallery_admin_buttons');
function solass_wp_gallery_admin_buttons($hook_suffix) {
$post_types_array = get_option( 'solass_wp_array_post_gallery', [] );
if(!empty($post_types_array[get_current_screen()->post_type])) {	//Ограничиваем подключение постами плагина
add_filter( 'mce_external_plugins', 'solass_wp_add_tinymce_plugin' );
function solass_wp_add_tinymce_plugin( $plugins ) {
    $plugins['solass_wp_shortcode_button'] = plugin_dir_url(__FILE__) . 'gallery_button.js'; // Подключаем JS-файл
    return $plugins;
}
add_filter( 'mce_buttons', 'solass_wp_add_tinymce_button' );
function solass_wp_add_tinymce_button( $buttons ) {
    array_push( $buttons, 'solass_wp_shortcode_button' ); // Добавляем кнопку в редактор
    return $buttons;
}
}
}


/*
// ---------------------- Вывод на страницах сайта -------------------//

$gallery = get_post_meta(get_the_ID(), '_gallery', true);
if (!empty($gallery)) {
    echo '<div class="gallery">';
    foreach ($gallery as $image_id) {
        echo wp_get_attachment_image($image_id, 'large');
    }
    echo '</div>';
}
*/


// ---------------------- Зберігаємо дані галереї -------------------//

add_action('save_post', 'solass_wp_save_gallery_meta_box');
function solass_wp_save_gallery_meta_box($post_id) {
    if (!isset($_POST['gallery_metabox_nonce']) || !wp_verify_nonce($_POST['gallery_metabox_nonce'], 'save_gallery_metabox')) { return; }
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) { return; }
    if (!current_user_can('edit_post', $post_id)) { return; }
	// Определяем, нужно ли обрабатывать этот пост
    $allowed_post_types = array_diff( array_keys((array) get_option('solass_wp_array_post_gallery', [])), defined('SOLASS_NO_GALLERY') ? SOLASS_NO_GALLERY : [] );
    if (!in_array(get_post_type($post_id), $allowed_post_types)) { return; }

    if (isset($_POST['gallery'])) {
        $gallery = array_filter(array_map('intval', explode(',', $_POST['gallery'])));
        update_post_meta($post_id, '_gallery', $gallery);
    } else {
        delete_post_meta($post_id, '_gallery');
    }
}