<?php
if ( ! defined( 'ABSPATH' ) ) { exit; } // Вихід, якщо доступ до нього прямий

// --------------------------------------------------------------------------------------------------------------- //
// ---------------------------- Добавляем поле для ввода ID страницы в настройках меню --------------------------- //
// --------------------------------------------------------------------------------------------------------------- //
if ( get_option( 'solass_wp_mega_menu', '' ) ) {

	
// Добавляем поля для флага "мегаменю" и выбора страницы
function solass_wp_add_mega_menu_fields($item_id, $item, $depth, $args) {
    $is_mega_menu = get_post_meta($item_id, '_is_mega_menu', true);
    $width = get_post_meta($item_id, '_menu_width', true);
    $page_id = get_post_meta($item_id, '_menu_page_id', true);

    // Получаем все страницы для выпадающего списка
    $pages = get_posts(array(
        'post_type' => get_option( 'solass_wp_mega_menu', '' ), // Для страниц. Для записей замените на 'post'. Для постов включить сортировку по таксономиям
 /*       'tax_query' => array( // Фильтр по таксономии
            array(
                'taxonomy' => 'custom-taxonomy', // Укажите вашу таксономию
                'field'    => 'slug',
                'terms'    => 'desired-term', // Укажите нужный термин
            ),
        ), 
*/
        'posts_per_page' => -1, // Показываем все страницы
        'post_status' => array('draft','publish'), // Только опубликованные - 'publish'
        'orderby' => 'title', // Сортировка по названию
        'order' => 'ASC',
    ));
    ?>
    <p class="field-custom description description-wide">
        <label for="edit-menu-item-is-mega-menu-<?php echo $item_id; ?>">
            <input type="checkbox" id="edit-menu-item-is-mega-menu-<?php echo $item_id; ?>" name="menu-item-is-mega-menu[<?php echo $item_id; ?>]" value="1" <?php checked($is_mega_menu, '1'); ?> />
            <?php _e('Включити мегаменю'); ?>
        </label>
    </p>
    <p class="field-custom description description-wide">
        <label for="edit-menu-item-width-<?php echo $item_id; ?>">
			<?php echo __( 'Ширина Мега-Меню (px)', 'solass-wp'); ?><br>
            <input type="text" id="edit-menu-item-width-<?php echo $item_id; ?>" name="menu-item-width[<?php echo $item_id; ?>]" value="<?php echo $width; ?>" />
        </label>
    </p>
    <p class="field-custom description description-wide">
        <label for="edit-menu-item-page-id-<?php echo $item_id; ?>">
            <?php echo __( 'Виберіть дизайн мега-меню з розділу', 'solass-wp'); ?> <a href="<?php echo admin_url('edit.php?post_type=' . get_option( 'solass_wp_mega_menu', '' ) ); ?>" target="_blank"><?php echo get_post_type_object(get_option( 'solass_wp_mega_menu', '' ))->labels->name; ?></a><br>
            <select id="edit-menu-item-page-id-<?php echo $item_id; ?>" class="widefat" name="menu-item-page-id[<?php echo $item_id; ?>]">
                <option value=""><?php echo __( 'Виберіть дизайн', 'solass-wp'); ?></option>
                <?php foreach ($pages as $page): ?>
                    <option value="<?php echo esc_attr($page->ID); ?>" <?php selected($page_id, $page->ID); ?>>
                        <?php echo esc_html($page->post_title); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </label>
    </p>
    <?php
}
add_action('wp_nav_menu_item_custom_fields', 'solass_wp_add_mega_menu_fields', 10, 4);

// Сохраняем параметры "мегаменю" и ID страницы
function solass_wp_save_mega_menu_fields($menu_id, $menu_item_db_id) {
    if (isset($_POST['menu-item-is-mega-menu'][$menu_item_db_id])) {
        update_post_meta($menu_item_db_id, '_is_mega_menu', '1');
    } else {
        delete_post_meta($menu_item_db_id, '_is_mega_menu');
    }

    if (isset($_POST['menu-item-width'][$menu_item_db_id])) { 
        $width = sanitize_text_field($_POST['menu-item-width'][$menu_item_db_id]);
		$width = preg_replace('/\D/', '', $width);
        update_post_meta($menu_item_db_id, '_menu_width', $width);
    } else {
        delete_post_meta($menu_item_db_id, '_menu_width');
    }

    if (isset($_POST['menu-item-page-id'][$menu_item_db_id])) {
        $page_id = sanitize_text_field($_POST['menu-item-page-id'][$menu_item_db_id]);
        update_post_meta($menu_item_db_id, '_menu_page_id', $page_id);
    } else {
        delete_post_meta($menu_item_db_id, '_menu_page_id');
    }
}
add_action('wp_update_nav_menu_item', 'solass_wp_save_mega_menu_fields', 10, 2);


// Формирование Мега-Меню для вывода (Новая версия) 

function solass_wp_modify_mega_menu_output($items, $args) {
    // Защита от повторных входов
    if ( ! empty( $GLOBALS['solass_processing_mega_menu'] ) ) {
        return $items;
    }

    $GLOBALS['solass_processing_mega_menu'] = true;

	foreach ($items as &$item) { 
		$old_item_id = '';
		$menu_width = ""; $page_id = "";
        $is_mega_menu = get_post_meta($item->ID, '_is_mega_menu', true);
        $page_id = 		get_post_meta($item->ID, '_menu_page_id', true);
        $menu_width = 	get_post_meta($item->ID, '_menu_width', true); 
		$class_content = (!empty($menu_width)) ? 'mega-menu-center' : '';
		$style_content = (!empty($menu_width)) ? ' style="width: 100vw !important; max-width: ' . $menu_width . 'px;"' : '';
		$style_inner = 	 (!empty($menu_width)) ? ' style="width: 100%;"' : '';

        if ($is_mega_menu && $page_id) { 
			if(!empty($menu_width)) { solass_wp_center_mega_menu(); } //Підключаємо скрипт центрування		
			
            $cache_key = 'mega_menu_content_' . $page_id;
            $output = wp_cache_get($cache_key);

            if ($output === false || $old_item_id != $item->ID ) { 
				$old_item_id = $item->ID;
                $page_content = get_post_field('post_content', $page_id);
                // apply_filters и do_shortcode — безопасно, глобал блокирует рекурсию
                $formatted_content = apply_filters('the_content', do_shortcode($page_content));

                $vc_css = get_post_meta($page_id, '_wpb_post_custom_css', true);
                $shortcodes_css = get_post_meta($page_id, '_wpb_shortcodes_custom_css', true);
                $post_style = ($vc_css || $shortcodes_css)
                    ? '<style>' . $vc_css . $shortcodes_css . '</style>'
                    : '';

                $output = $post_style . '
				<ul class="sub-menu mega-menu-content ' . $class_content . '" ' . $style_content . '>
				<div class="mega-menu-inner" ' . $style_inner . '>' . $formatted_content . '</div>
				</ul>';

                wp_cache_set($cache_key, $output, '', HOUR_IN_SECONDS);
            }

            $item->classes[] = 'solass-mega-menu';
            $item->mega_menu_content = $output;
        }
    }

    unset($GLOBALS['solass_processing_mega_menu']); // сбрасываем флаг
    return $items;
}

add_filter('wp_nav_menu_objects', 'solass_wp_modify_mega_menu_output', 10, 2);



// Функція центрування меню на сторінці
function solass_wp_center_mega_menu() {
add_action('wp_footer', function() {
if (!wp_script_is('solass-mega-menu-center', 'enqueued')) {
        ?>
        <script id="solass-mega-menu-center">
        (function() {
            // Проверка, чтобы не запустилось дважды
            if (window.solassMegaMenuCenterInit) return;
            window.solassMegaMenuCenterInit = true;

            function centerMegaMenus() {
				    const menus = document.querySelectorAll('.mega-menu-center');
				    const windowWidth = window.innerWidth;
				    const scrollX = window.scrollX;

				    menus.forEach(menu => {
				    if (!menu || menu.offsetWidth === 0) return;

                    menu.style.setProperty('left', '0px', 'important');
				    const inner = menu; //.querySelector('.mega-menu-inner');
				    const innerWidth = inner.offsetWidth;
				    const rect = menu.getBoundingClientRect();
                    const leftPos = rect.left + window.scrollX;

                    // Центрируем UL (или div.mega-menu-inner, если надо именно его)
                    const left = ((windowWidth - innerWidth) / 2) - rect.left; 
                    const left_scroll = ((windowWidth - innerWidth) / 2) - leftPos; 
					const left0 = -1 * rect.left;

                    // Применяем позицию
                    //menu.style.setProperty('left', left0 + 'px', 'important');
                    menu.style.setProperty('left', left + 'px', 'important');
                    menu.style.setProperty('left', left_scroll + 'px', 'important');
                    menu.style.setProperty('position', 'absolute', 'important');
                    menu.style.setProperty('right', 'auto', 'important');
				    });
            }

            // Центрирование при загрузке и изменениях окна
            window.addEventListener('load', centerMegaMenus);
            window.addEventListener('resize', centerMegaMenus);
            //window.addEventListener('scroll', centerMegaMenus);
            
			document.addEventListener('mouseenter', (e) => {
			  if (e.target.classList.contains('menu-item') && !e.target.closest('.sub-menu')) {
			    centerMegaMenus();
			  }
			}, true);

            // Небольшая задержка на случай анимаций тем
            setTimeout(centerMegaMenus, 1000);
        })();
        </script>
        <?php
    }
});
}
	
	
// Функция для добавления контента мегаменю в нужное место
function solass_wp_render_mega_menu($output, $item, $depth, $args) {
    // Проверяем, есть ли контент для мегаменю
    if (isset($item->mega_menu_content)) {
        // Добавляем контент мегаменю после основного элемента меню
        $output .= $item->mega_menu_content;
    }
	return $output;
}
add_filter('walker_nav_menu_start_el', 'solass_wp_render_mega_menu', 10, 4);


}