<?php
/*
Plugin Name: SOLASS WPSettings
Plugin URI: https://solass.com.ua/solass-wp-settings/
Description: Плагін персональних налаштувань захисту, оформлення та ін. для системи адмініструвань WordPress.
Version: 1.2.8.3
Author: Design Studio SOLASS
Author URI: https://solass.com.ua/
License: GPL2
Text Domain: solass-wp
Domain Path: /languages
Language: uk
Update URI: https://solass.com.ua/shared-files/37635/
*/
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Вихід, якщо доступ до нього прямий
}

// -------------------------------------- Глобальні параметри плагіну ------------------------------------------------------ //
add_action('plugins_loaded', function() { 
global $plugin_version;
$plugin_version = get_plugin_data(__FILE__)['Version'];					// для використання на сторінках адміністратора
define( 'SOLASS_WP_PLUGIN_VER', get_plugin_data(__FILE__)['Version'] );	// визначаємо версію плагіна 
});
$plugin_file = plugin_basename(__FILE__);								// файл плагіна для довідки
$plugin_name = dirname(plugin_basename(__FILE__));						// ім'я плагіну
define( 'SOLASS_WP_PLUGIN_FILE', $plugin_file );						// визначте головний файл плагіну
define( 'SOLASS_WP_PLUGIN_NAME', $plugin_name );						// визначте ім'я плагіну
define( 'SOLASS_WP_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );			// визначте абсолютний шлях плагіна для включень
define( 'SOLASS_WP_PLUGIN_URL', plugin_dir_url( __FILE__ ) );			// визначте URL-адресу плагіна для використання в черзі 
$plugins_name['solass-wp-settings'] = $plugin_name; 

define( 'SOLASS_PLUGINS', ['solass-addons','solass-listovka','custom-form'] );	// перелік плагінів розроблених студією SOLASS 
define( 'SOLASS_NO_GALLERY', ['leaflet','rc_blocks','wp_mapit_map'] );			// типи постів для яких заблоковано підключення функції Gallery 

$solass_base_plugin_url = "solass-wp-settings/solass-wp-settings.php";	// Вказуємо шлях до головного плагіну SOLASS WPSettings щоб підключити до нього цей плагін
$main_page_slug = 'solass-wp-settings';									// Вказуємо слаг головного плагіну
//define( 'SOLASS_MAIN_PLUGINS_SLAG', $main_page_slug );				// визначте ім'я головного плагіну
//define( 'SOLASS_MAIN_PLUGINS_URL', $solass_base_plugin_url );			// визначте шлях до головного плагіну

// --------------------- Включення мультимовності опцій/значень на основі плагіну Polylang -------------------------- //
add_action( 'init', 'solass_wp_current_language' ); 
function solass_wp_current_language() { 
require_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Смотрим файл плагинов и Проверяем включен ли плагин Polylang 
$solass_wp_current_lang = "";
$solass_wp_polylang_lang = "";
if (is_plugin_active('polylang/polylang.php') ) { 
$solass_wp_current_lang = empty( pll_current_language() ) ? pll_default_language() : pll_current_language(); 
if ( !empty( pll_current_language() ) && ( pll_current_language() != pll_default_language() ) ) { 
$solass_wp_polylang_lang = "_".pll_current_language(); 
}
}
define( 'SOLASS_WP_POLYLANG_LANG', $solass_wp_polylang_lang );		// визначаэмо префікс МОВИ сайту ("_ua") 
define( 'SOLASS_WP_CURRENT_LANG', $solass_wp_current_lang );		// визначаэмо МОВУ сайту 
// solass_wp_polylang_active_lang('solass_wp_admin_footer_text');  // Функція виводу мов та присутності інформації. До змінної додається .SOLASS_WP_POLYLANG_LANG
}

// --- Запобігає помилці раннього запиту перекладу 
// -------- до завантаження файлу перекладу
if (!isset($GLOBALS['l10n']['solass-wp'])) {
    $GLOBALS['l10n']['solass-wp'] = new MO();
}
// Функція реєстрації файлів перекладів плагіну
if (!function_exists('solass_wp_load_textdomain')) {
function solass_wp_load_textdomain() {
	global $plugin_name, $plugins_name;
	unload_textdomain('solass-wp'); // видаляємо якщо був завантажений
    load_textdomain('solass-wp', false, dirname(plugin_basename(__FILE__)) . '/languages'); 
}
}
add_action('plugins_loaded', 'solass_wp_load_textdomain', 0);
//add_action('init', 'solass_wp_load_textdomain', 0);


// --------------------- Головні параметри налаштування плагіну -------------------------- //
$on_plugin = get_option('on_plugin', ''); 	  			// параметр увімкнення свого оформлення випадаючої форми

$javascript_for_page = "";
/*
$javascript_for_page = $javascript_for_page."
// Прописуємо JavaScript функцію, або код який можемо запустити на сторінці 
// vashaVozmozhnayaFuction('".$custom_form_select_class."', '".$custom_form_select_form_class."'); ";
*/

// -------------- Підключаємо для ЛИЦЯ сайту файли стилів та скриптів плагіну --------------- //
function solass_wp_enqueue_scripts() {
global $on_plugin, $javascript_for_page, $plugin_name, $plugins_name; 
// Підключаємо стилі
  wp_enqueue_style( dirname(plugin_basename(__FILE__)), SOLASS_WP_PLUGIN_URL . 'css/solass-wp-settings.css', array() , get_plugin_data(__FILE__)['Version'] ); 
// Підключаємо скрипти
  wp_enqueue_script( dirname(plugin_basename(__FILE__)), SOLASS_WP_PLUGIN_URL . 'js/solass-wp-settings.js', array( 'jquery' ), get_plugin_data(__FILE__)['Version'], true );
if ( !empty($on_plugin) && $on_plugin === 'on' ) {
  wp_enqueue_script( dirname(plugin_basename(__FILE__)), SOLASS_WP_PLUGIN_URL . 'js/[name_vashego_scripta].js', array( 'jquery' ), get_plugin_data(__FILE__)['Version'], true );
// Додаємо вставку скрипта у код сторінки після завантаженого файлу.
  wp_add_inline_script( dirname(plugin_basename(__FILE__)), $javascript_for_page ); 
}
}
add_action( 'wp_enqueue_scripts', 'solass_wp_enqueue_scripts' );

// ------------------------------- Підключення модулів плагіну ------------------------------ //
// 

include( SOLASS_WP_PLUGIN_PATH . 'functions/functions.php' );				// підключаємо файл функцій плагіна 
include( SOLASS_WP_PLUGIN_PATH . 'functions/plugins_update.php' );			// підключаємо файл функції оновлення плагіну 
include( SOLASS_WP_PLUGIN_PATH . 'admin/register-settings.php' );			// підключаємо файл реєстрації данних/змінних плагіну
include( SOLASS_WP_PLUGIN_PATH . 'admin/admin-page.php' );					// підключаємо файл виводу сторінки плагіну "Дизайн елементів"
include( SOLASS_WP_PLUGIN_PATH . 'admin/admin-page-functions.php' );		// підключаємо файл виводу сторінки плагіну "Функціонал"
include( SOLASS_WP_PLUGIN_PATH . 'admin/admin-page-structure.php' );		// підключаємо файл виводу сторінки плагіну "Структура"
include( SOLASS_WP_PLUGIN_PATH . 'admin/admin-page-htaccess.php' );			// підключаємо файл виводу сторінки плагіну "htaccess"
include( SOLASS_WP_PLUGIN_PATH . 'admin/admin-page-woo.php' );				// підключаємо файл виводу сторінки плагіну "WooCommerce"
include( SOLASS_WP_PLUGIN_PATH . 'admin/admin-page-css.php' );				// підключаємо файл виводу сторінки плагіну "CSS"
include( SOLASS_WP_PLUGIN_PATH . 'admin/admin-page-seo.php' );				// підключаємо файл виводу сторінки плагіну "SEO"
include( SOLASS_WP_PLUGIN_PATH . 'admin/admin-page-safe.php' );				// підключаємо файл виводу сторінки плагіну "Безпека"
include( SOLASS_WP_PLUGIN_PATH . 'admin/admin-page-plugins.php' );			// підключаємо файл виводу сторінки плагіну "Рекомендовані плагіни"
include( SOLASS_WP_PLUGIN_PATH . 'css/page-style.php' );					// підключаємо файл виводу стилів в коді сторінок сайту
include( SOLASS_WP_PLUGIN_PATH . 'functions/editor-css.php' );				// підключаємо файл функції заміни TEXTAREA на CSS-редактор
include( SOLASS_WP_PLUGIN_PATH . 'functions/admin_settings_svg.php' );		// підключаємо файл функцій завантаження та виводу файлів SVG
include( SOLASS_WP_PLUGIN_PATH . 'functions/admin_settings_htaccess.php' );	// підключаємо файл функцій формування файлу .htaccess

include( SOLASS_WP_PLUGIN_PATH . 'functions/admin_settings.php' );			// підключаємо файл функцій для налаштувань системи WordPress 
include( SOLASS_WP_PLUGIN_PATH . 'functions/gallery/gallery.php' );			// підключаємо файл функції мета-боксу галереї 
include( SOLASS_WP_PLUGIN_PATH . 'functions/mega-menu.php' );				// підключаємо файл функції мега-меню 
//include( SOLASS_WP_PLUGIN_PATH . 'functions/f_loader/file_loader.php' );	// підключаємо файл функції мета-боксу галереї 


// --------- Запускаємо конвертор мовних перекладів для javaScript ---------------- //
if (file_exists(SOLASS_WP_PLUGIN_PATH . 'languages/'.dirname(plugin_basename(__FILE__)).'-js.po')) { 
convert_po_to_json(SOLASS_WP_PLUGIN_PATH . 'languages/'.dirname(plugin_basename(__FILE__)).'-js.po', SOLASS_ADDONS_PLUGIN_PATH . 'languages/'.dirname(plugin_basename(__FILE__)).'-js.json');
}

// -------------------- Підключення модулів плагіну в залежності від налаштувань плагіну ------------- //
if ( !empty($custom_form_options['vasha_var']) && $custom_form_options['vasha_var'] === 'on' ) {
// Код підключень або налаштувань в залежності від параметрів плагіну

}

// --------------------- МЕНЮ ПЛАГІНА та реєстрація сторінок налаштувань плагіна ----------------------------- //
if (!function_exists('solass_wp_options_page')) { }
function solass_wp_options_page() {
	global $plugin_name, $solass_base_plugin, $plugins_name;
$solass_base_plugin = add_menu_page( 
	esc_html__( 'Элементи оформлення WordPress', 'solass-wp'), // Заголовок страницы
    esc_html__( 'SOLASS WPSet', 'solass-wp'), // Название пункта меню
    'manage_options', // Разрешение на просмотр страницы... publish_pages - редакторам, publish_posts - авторам 
    dirname(plugin_basename(__FILE__)), // Уникальный идентификатор страницы
    'solass_wp_page_building', // Функция отображения страницы
    SOLASS_WP_PLUGIN_URL.'images/solass-ico-color.svg' // url-путь к иконке плагина
); //page_title, menu_title, capability, menu_slug, function, icon_url, position 

add_submenu_page(dirname(plugin_basename(__FILE__)), esc_html__( 'Дизайн елементів оформлення WordPress', 'solass-wp'), esc_html__( 'Дизайн элементів', 'solass-wp'), 'manage_options', dirname(plugin_basename(__FILE__)), 'solass_wp_page_building' );
add_submenu_page(dirname(plugin_basename(__FILE__)), esc_html__( 'Налаштування функціональних елементів', 'solass-wp'), esc_html__( 'Функціонал', 'solass-wp'), 'manage_options', dirname(plugin_basename(__FILE__)).'-functions', 'solass_wp_page_building_functions' );
add_submenu_page(dirname(plugin_basename(__FILE__)), esc_html__( 'Структура сайту, сайдбари та сторінки опцій', 'solass-wp'), esc_html__( 'Структура', 'solass-wp'), 'manage_options', dirname(plugin_basename(__FILE__)).'-structure', 'solass_wp_page_building_structure' );
add_submenu_page(dirname(plugin_basename(__FILE__)), esc_html__( 'Налаштування WooCommerce', 'solass-wp'), esc_html__( 'WooCommerce', 'solass-wp'), 'manage_options', dirname(plugin_basename(__FILE__)).'-woo', 'solass_wp_page_building_woo' );
add_submenu_page(dirname(plugin_basename(__FILE__)), esc_html__( 'Налаштування CSS', 'solass-wp'), esc_html__( 'CSS', 'solass-wp'), 'manage_options', dirname(plugin_basename(__FILE__)).'-css', 'solass_wp_page_building_css' );
add_submenu_page(dirname(plugin_basename(__FILE__)), esc_html__( 'SEO налаштування', 'solass-wp'), esc_html__( 'SEO налаштування', 'solass-wp'), 'manage_options', dirname(plugin_basename(__FILE__)).'-seo', 'solass_wp_page_building_seo' );
add_submenu_page(dirname(plugin_basename(__FILE__)), esc_html__( 'Налаштування правил у файлі .htaccess', 'solass-wp'), esc_html__( '.htaccess', 'solass-wp'), 'manage_options', dirname(plugin_basename(__FILE__)).'-htaccess', 'solass_wp_page_building_htaccess' );
add_submenu_page(dirname(plugin_basename(__FILE__)), esc_html__( 'Безпека сайту', 'solass-wp'), esc_html__( 'Безпека сайту', 'solass-wp'), 'manage_options', dirname(plugin_basename(__FILE__)).'-safe', 'solass_wp_page_building_safe' );
add_submenu_page(dirname(plugin_basename(__FILE__)), esc_html__( 'Плагіни', 'solass-wp'), esc_html__( 'Плагіни', 'solass-wp'), 'manage_options', dirname(plugin_basename(__FILE__)).'-plugins', 'solass_wp_plugins_updates_page' );

/*
  add_options_page( // add_menu_page - використовується для головного меню
    esc_html__( 'Персональні налаштування WordPress', 'solass-wp'), // Заголовок страницы
    esc_html__( 'SOLASS WPSettings', 'solass-wp'), // Название пункта меню
    'manage_options', // Разрешение на просмотр страницы
    'solass-wp-settings', // Уникальный идентификатор страницы
    'solass_wp_page_building' // Функция отображения страницы
  );
*/
}
add_action( 'admin_menu', 'solass_wp_options_page', 1);		// Ставимо приоритет для виконання функції створення сторінки плагіну та додавання її у головне меню
//add_action('init', 'solass_wp_options_page', 1);		


// --------------------- Додаємо файл стилів CSS та файл скриптів ДО АДМІНКИ ПЛАГІНУ WordPress ------------------//
$solass_wp_admin_script = "";
function solass_wp_admin_style() {
global $solass_wp_admin_script, $plugin_name, $plugins_name;
      wp_enqueue_script( 'wp-codemirror' ); // Загрузить библиотеку wp-codemirror
	  wp_enqueue_style( dirname(plugin_basename(__FILE__)).'-admin-styles', SOLASS_WP_PLUGIN_URL . 'admin/admin_style.css', array(), get_plugin_data(__FILE__)['Version']); 
	  wp_enqueue_script( dirname(plugin_basename(__FILE__)).'-admin-script', SOLASS_WP_PLUGIN_URL . 'admin/admin_js.js', array( 'jquery', 'wp-theme-plugin-editor' ), get_plugin_data(__FILE__)['Version'],  true ); 
	  // Підключаємо візуальну форму вибору кольору
	  wp_enqueue_style( 'wp-color-picker' );
	  wp_enqueue_script( 'wp-color-picker' ); 
	  // Подключаем расширение alpha-picker.js
	  wp_enqueue_script( 'wp-color-picker-alpha', SOLASS_WP_PLUGIN_URL . 'admin/wp-color-picker-alpha.js', array( 'wp-color-picker' ), get_plugin_data(__FILE__)['Version'], true );
	  // Включаем все формы выбора цвета
	  wp_add_inline_script( 'wp-color-picker', " jQuery(document).ready(function($) { jQuery('.colorPicker').wpColorPicker(); }); " );  
	
	  wp_enqueue_media();

	  // Реєстрація перекладів для JavaScript функцій
	  //wp_register_script( $plugin_name.'-admin-script', plugins_url( '/admin/admin_js.js', __FILE__ ) );
	  wp_set_script_translations( dirname(plugin_basename(__FILE__)).'-admin-script', dirname(plugin_basename(__FILE__)) );

	  wp_add_inline_script( dirname(plugin_basename(__FILE__)).'-admin-script', $solass_wp_admin_script ); // Додаємо скрипт у кінець сторінки адмінки
}
//if(file_exists(CASTOM_FORM_PLUGIN_URL . 'admin/admin_style.css')) {  }
add_action('admin_enqueue_scripts', 'solass_wp_admin_style');


// Прописуємо потрібні посилання у списку назв плагінів
if (!function_exists('solass_wp_settings_link')) {
function solass_wp_settings_link($links) {
	$page_plugin_name = dirname(plugin_basename(__FILE__));
    $settings_link = '<a style="font-weight: bold;" href="'. esc_url( admin_url( "admin.php?page={$page_plugin_name}" ) ) . '">' . esc_html__( 'Налаштування', 'solass-wp' ) . '</a>'; //options-general.php
    array_unshift($links, $settings_link);
    return $links;
}
}
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'solass_wp_settings_link');

// Додавання посилання у списку плагінів (колонка "опис")
/*
function my_plugin_row_meta( $links, $file ) {
    global $plugin_name;
    if ( plugin_basename( __FILE__ ) === $file ) {
     $settings_link = '<a href="'. esc_url( admin_url( "options-general.php?page={$plugin_name}" ) ) . '">' . esc_html__( 'Налаштування', 'custom-form' ) . '</a>';
        $links[] = $settings_link;
    }
    return $links;
}
add_filter( 'plugin_row_meta', 'my_plugin_row_meta', 10, 2 );
*/

// Додавання посилання у кінці лінків списку назв плагінів
/*
function myplugin_settings_link($links) {
    $settings_link = '<a href="admin.php?page=myplugin-settings">Settings</a>';
    array_push($links, $settings_link);
    return $links;
}
add_filter("plugin_action_links_".plugin_basename(__FILE__), 'myplugin_settings_link' );
*/


// ------------------ Функции для чистки правил плагина в .htaccess ------------ // 
// ----------- функция запускается при деактивации или удалении плагина -------- //
register_deactivation_hook( __FILE__, 'solass_wp_deactivate' );
register_uninstall_hook( __FILE__, 'solass_wp_deactivate' );

function solass_wp_deactivate() {
if( is_file(ABSPATH . '.htaccess') ) { // Проверяем существует ли файл .htaccess
$htaccess = ABSPATH . '.htaccess'; 
insert_with_markers($htaccess, "SOLASS WPSettings", array()); // Добавляем правила в файл .htaccess
}
}


// ---------------- Функция запускается при активации плагина ----------- //
register_activation_hook( __FILE__, 'solass_wp_activate' );
 
function solass_wp_activate() { 
}